/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;

@Label(name="Skeleton Flee", description="Skeletons try to stay away from the target.")
public class SkeletonFleeTarget
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> avoidPlayerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> attackWhenAvoidingChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeDistanceFarConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeDistanceNearConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeSpeedNearConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeSpeedFarConfig;
    private final Blacklist.Config entityBlacklistConfig;
    private final List<String> defaultBlacklist = List.of("quark:forgotten");
    public double avoidPlayerChance = 0.5;
    public double attackWhenAvoidingChance = 0.5;
    public double fleeDistanceFar = 16.0;
    public double fleeDistanceNear = 8.0;
    public double fleeSpeedNear = 1.6;
    public double fleeSpeedFar = 1.3;
    public Blacklist entityBlacklist;

    public SkeletonFleeTarget(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.avoidPlayerChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn with the ability to avoid the player").defineInRange("Avoid Player chance", this.avoidPlayerChance, 0.0, 1.0);
        this.attackWhenAvoidingChanceConfig = Config.builder.comment("Chance for a Skeleton to be able to shoot while running from a player").defineInRange("Attack When Avoiding Chance", this.attackWhenAvoidingChance, 0.0, 1.0);
        this.fleeDistanceFarConfig = Config.builder.comment("Distance from a player that will make the skeleton run away.").defineInRange("Flee Distance", this.fleeDistanceFar, 0.0, 32.0);
        this.fleeDistanceNearConfig = Config.builder.comment("Distance from a player that counts as near and will make the skeleton run away faster.").defineInRange("Flee Distance Near", this.fleeDistanceNear, 0.0, 32.0);
        this.fleeSpeedFarConfig = Config.builder.comment("Speed multiplier when the skeleton avoids the player and it's farther than 'Flee Distance Far' blocks from him.").defineInRange("Flee speed Multiplier Far", this.fleeSpeedFar, 0.0, 4.0);
        this.fleeSpeedNearConfig = Config.builder.comment("Speed multiplier when the skeleton avoids the player and it's within 'Flee Distance Near' blocks from him.").defineInRange("Flee speed Multiplier Near", this.fleeSpeedNear, 0.0, 4.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the enhanced Shoot AI").setDefaultList(this.defaultBlacklist).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.avoidPlayerChance = (Double)this.avoidPlayerChanceConfig.get();
        this.attackWhenAvoidingChance = (Double)this.attackWhenAvoidingChanceConfig.get();
        this.fleeDistanceFar = (Double)this.fleeDistanceFarConfig.get();
        this.fleeDistanceNear = (Double)this.fleeDistanceNearConfig.get();
        this.fleeSpeedNear = (Double)this.fleeSpeedNearConfig.get();
        this.fleeSpeedFar = (Double)this.fleeSpeedFarConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    public void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)skeleton)) {
            return;
        }
        CompoundTag persistentData = skeleton.getPersistentData();
        boolean avoidTarget = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:avoid_target", skeleton.f_19853_.f_46441_.nextDouble() < this.avoidPlayerChance);
        boolean attackWhenAvoiding = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:attack_when_avoiding", skeleton.f_19853_.f_46441_.nextDouble() < this.attackWhenAvoidingChance);
        double fleeDistanceFar = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_far", this.fleeDistanceFar);
        double fleeDistanceNear = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_near", this.fleeDistanceNear);
        double fleeSpeedFar = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_far", this.fleeSpeedFar);
        double fleeSpeedNear = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_near", this.fleeSpeedNear);
        if (!avoidTarget) {
            return;
        }
        boolean hasAIArrowAttack = false;
        for (WrappedGoal prioritizedGoal : skeleton.f_21345_.f_25345_) {
            if (!prioritizedGoal.m_26015_().equals(skeleton.f_32130_)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof EAAvoidEntityGoal).toList();
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.f_21345_).m_25363_(arg_0));
        if (hasAIArrowAttack) {
            EAAvoidEntityGoal<Player> avoidEntityGoal = new EAAvoidEntityGoal<Player>((PathfinderMob)skeleton, Player.class, (float)fleeDistanceFar, (float)fleeDistanceNear, fleeSpeedNear, fleeSpeedFar);
            avoidEntityGoal.setAttackWhenRunning(attackWhenAvoiding);
            skeleton.f_21345_.m_25352_(1, avoidEntityGoal);
        }
    }
}

