/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.modules.skeleton.ai.EARangedBowAttackGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import insane96mcp.insanelib.config.MinMax;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

@Label(name="Skeleton Shoot", description="Skeletons are more precise when shooting and strafing is removed, can hit a target from up to 64 blocks and try to stay away from the target.")
public class SkeletonShoot
extends Feature {
    public static final TagKey<Item> BOWS = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("enhancedai", "bows"));
    public static final String STRAFE = "enhancedai:strafe";
    public static final String SHOOTING_RANGE = "enhancedai:shooting_range";
    public static final String SHOOTING_COOLDOWN = "enhancedai:shooting_cooldown";
    public static final String BOW_CHARGE_TICKS = "enhancedai:bow_charge_ticks";
    public static final String INACCURACY = "enhancedai:inaccuracy";
    private static final String SPAMMER = "enhancedai:spammer";
    private final MinMax.Config shootingRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Double> strafeChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> arrowInaccuracyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> spammerChanceConfig;
    private final MinMax.Config shootingCooldownConfig;
    private final MinMax.Config bowChargeTicksConfig;
    private final Blacklist.Config entityBlacklistConfig;
    private final List<String> defaultBlacklist = List.of("quark:forgotten");
    public MinMax shootingRange = new MinMax(24.0, 32.0);
    public double strafeChance = 0.333;
    public double arrowInaccuracy = 4.0;
    public double spammerChance = 0.07;
    public MinMax shootingCooldown = new MinMax(40.0, 60.0);
    public MinMax bowChargeTicks = new MinMax(15.0, 30.0);
    public Blacklist entityBlacklist;

    public SkeletonShoot(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.shootingRangeConfig = new MinMax.Config(Config.builder, "Shooting Range", "The range from where a skeleton will shoot a player").setMinMax(1.0, 64.0, this.shootingRange).build();
        this.strafeChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn with the ability to strafe (like vanilla)").defineInRange("Strafe chance", this.strafeChance, 0.0, 1.0);
        this.arrowInaccuracyConfig = Config.builder.comment("How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.").defineInRange("Arrow Inaccuracy", this.arrowInaccuracy, 0.0, 30.0);
        this.spammerChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn as a spammer, which spams arrows instead of fully charging the bow").defineInRange("Spammer chance", this.spammerChance, 0.0, 1.0);
        this.shootingCooldownConfig = new MinMax.Config(Config.builder, "Shooting Cooldown", "The ticks cooldown after shooting. This is halved in Hard difficulty").setMinMax(1.0, 1200.0, this.shootingCooldown).build();
        this.bowChargeTicksConfig = new MinMax.Config(Config.builder, "Bow charge ticks", "The ticks the skeleton charges the bow. at least 20 ticks for a full charge.").setMinMax(1.0, 1200.0, this.bowChargeTicks).build();
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the enhanced Shoot AI").setDefaultList(this.defaultBlacklist).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.shootingRange = this.shootingRangeConfig.get();
        this.strafeChance = (Double)this.strafeChanceConfig.get();
        this.arrowInaccuracy = (Double)this.arrowInaccuracyConfig.get();
        this.spammerChance = (Double)this.spammerChanceConfig.get();
        this.shootingCooldown = this.shootingCooldownConfig.get();
        this.bowChargeTicks = this.bowChargeTicksConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    public void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)skeleton)) {
            return;
        }
        CompoundTag persistentData = skeleton.getPersistentData();
        boolean strafe = NBTUtils.getBooleanOrPutDefault(persistentData, STRAFE, skeleton.f_19853_.f_46441_.nextDouble() < this.strafeChance);
        int shootingRange = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_RANGE, this.shootingRange.getIntRandBetween(skeleton.m_21187_()));
        boolean spammer = NBTUtils.getBooleanOrPutDefault(persistentData, SPAMMER, skeleton.f_19853_.f_46441_.nextDouble() < this.spammerChance);
        int shootingCooldown1 = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_COOLDOWN, this.shootingCooldown.getIntRandBetween(skeleton.m_21187_()));
        int bowChargeTicks1 = NBTUtils.getIntOrPutDefault(persistentData, BOW_CHARGE_TICKS, this.bowChargeTicks.getIntRandBetween(skeleton.m_21187_()));
        boolean hasAIArrowAttack = false;
        for (WrappedGoal prioritizedGoal : skeleton.f_21345_.f_25345_) {
            if (!prioritizedGoal.m_26015_().equals(skeleton.f_32130_)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof EAAvoidEntityGoal || g.equals(skeleton.f_32130_)).toList();
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.f_21345_).m_25363_(arg_0));
        if (!hasAIArrowAttack && skeleton.m_21093_(stack -> stack.m_204117_(BOWS))) {
            hasAIArrowAttack = true;
            skeleton.f_21345_.m_25363_((Goal)skeleton.f_32131_);
        }
        if (hasAIArrowAttack) {
            double inaccuracy = this.arrowInaccuracy;
            if (spammer) {
                shootingCooldown1 = 30;
                bowChargeTicks1 = 1;
                inaccuracy *= 2.5;
            }
            if (skeleton.f_19853_.m_46791_().equals((Object)Difficulty.HARD)) {
                shootingCooldown1 /= 2;
            }
            EARangedBowAttackGoal<AbstractSkeleton> EARangedBowAttackGoal2 = new EARangedBowAttackGoal<AbstractSkeleton>(skeleton, 1.0, shootingRange, strafe).setAttackCooldown(shootingCooldown1).setBowChargeTicks(bowChargeTicks1).setInaccuracy((float)inaccuracy);
            skeleton.f_21345_.m_25352_(2, EARangedBowAttackGoal2);
        }
    }
}

