/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.spider.feature;

import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.Collections;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Miscellaneous", description="Various small changes to Spiders.")
public class Misc
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> fallDamageReductionConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public double fallDamageReduction = 0.9;
    public Blacklist entityBlacklist;

    public Misc(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.fallDamageReductionConfig = Config.builder.comment("Percentage reduction of the fall damage taken by spiders.").defineInRange("Fall Damage Reduction", this.fallDamageReduction, 0.0, 1.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't be affected by this feature").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.fallDamageReduction = (Double)this.fallDamageReductionConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.fallDamageReduction == 0.0) {
            return;
        }
        if (!event.getSource().equals(DamageSource.f_19315_)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Spider)) {
            return;
        }
        Spider spider = (Spider)entity;
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)spider)) {
            return;
        }
        event.setAmount((float)((double)event.getAmount() * (1.0 - this.fallDamageReduction)));
    }
}

