/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.feature;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Witch Flee Target", description="Witches flee from the target.")
public class WitchFleeTarget
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> avoidPlayerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> attackWhenAvoidingChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeDistanceFarConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeDistanceNearConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeSpeedNearConfig;
    private final ForgeConfigSpec.ConfigValue<Double> fleeSpeedFarConfig;
    public double avoidPlayerChance = 1.0;
    public double attackWhenAvoidingChance = 0.5;
    public double fleeDistanceFar = 16.0;
    public double fleeDistanceNear = 8.0;
    public double fleeSpeedNear = 1.25;
    public double fleeSpeedFar = 1.1;

    public WitchFleeTarget(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.avoidPlayerChanceConfig = Config.builder.comment("Chance for a Witch to spawn with the ability to avoid the player").defineInRange("Avoid Player chance", this.avoidPlayerChance, 0.0, 1.0);
        this.attackWhenAvoidingChanceConfig = Config.builder.comment("Chance for a Witch to be able to throw potions while running from a player").defineInRange("Attack When Avoiding Chance", this.attackWhenAvoidingChance, 0.0, 1.0);
        this.fleeDistanceFarConfig = Config.builder.comment("Distance from a player that will make the Witch run away.").defineInRange("Flee Distance Far", this.fleeDistanceFar, 0.0, 32.0);
        this.fleeDistanceNearConfig = Config.builder.comment("Distance from a player that counts as near and will make the Witch run away faster.").defineInRange("Flee Distance Near", this.fleeDistanceNear, 0.0, 32.0);
        this.fleeSpeedFarConfig = Config.builder.comment("Speed multiplier when the Witch avoids the player and it's farther than 'Flee Distance Near' blocks from him.").defineInRange("Flee speed Multiplier Far", this.fleeSpeedFar, 0.0, 4.0);
        this.fleeSpeedNearConfig = Config.builder.comment("Speed multiplier when the Witch avoids the player and it's within 'Flee Distance Near' blocks from him.").defineInRange("Flee speed Multiplier Near", this.fleeSpeedNear, 0.0, 4.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.avoidPlayerChance = (Double)this.avoidPlayerChanceConfig.get();
        this.attackWhenAvoidingChance = (Double)this.attackWhenAvoidingChanceConfig.get();
        this.fleeDistanceFar = (Double)this.fleeDistanceFarConfig.get();
        this.fleeDistanceNear = (Double)this.fleeDistanceNearConfig.get();
        this.fleeSpeedNear = (Double)this.fleeSpeedNearConfig.get();
        this.fleeSpeedFar = (Double)this.fleeSpeedFarConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getWorld().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Witch)) {
            return;
        }
        Witch witch = (Witch)entity;
        CompoundTag persistentData = witch.getPersistentData();
        boolean avoidTarget = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:avoid_target", witch.f_19853_.f_46441_.nextDouble() < this.avoidPlayerChance);
        boolean attackWhenAvoiding = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:attack_when_avoiding", witch.f_19853_.f_46441_.nextDouble() < this.attackWhenAvoidingChance);
        double fleeDistanceFar = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_far", this.fleeDistanceFar);
        double fleeDistanceNear = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_near", this.fleeDistanceNear);
        double fleeSpeedFar = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_far", this.fleeSpeedFar);
        double fleeSpeedNear = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_near", this.fleeSpeedNear);
        if (!avoidTarget) {
            return;
        }
        EAAvoidEntityGoal<Player> avoidEntityGoal = new EAAvoidEntityGoal<Player>((PathfinderMob)witch, Player.class, (float)fleeDistanceFar, (float)fleeDistanceNear, fleeSpeedNear, fleeSpeedFar);
        avoidEntityGoal.setAttackWhenRunning(attackWhenAvoiding);
        witch.f_21345_.m_25352_(1, avoidEntityGoal);
    }
}

