/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.feature;

import insane96mcp.enhancedai.modules.witch.ai.WitchThrowPotionGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import insane96mcp.insanelib.config.MinMax;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Witch Potion Throwing", description="Witches throw potions farther, faster and more potion types. Also no longer chase player if they can't see him.")
public class WitchPotionThrowing
extends Feature {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> badPotionsListConfig;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> goodPotionsListConfig;
    private final ForgeConfigSpec.ConfigValue<Double> lingeringChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> anotherThrowChanceConfig;
    private final MinMax.Config throwSpeedConfig;
    private final MinMax.Config throwRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> useSlowFallingConfig;
    private final ForgeConfigSpec.ConfigValue<Double> healthThresholdInvisiblityConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public static final List<String> badPotionsListDefault = Arrays.asList("minecraft:weakness,900,0", "minecraft:slowness,1200,1", "minecraft:hunger,600,0", "minecraft:mining_fatigue,600,0", "minecraft:poison,900,0", "minecraft:blindness,120,0", "minecraft:instant_damage,1,0");
    public static final List<String> goodPotionsListDefault = Arrays.asList("minecraft:regeneration,900,0", "minecraft:speed,1800,0", "minecraft:strength,1800,0", "minecraft:instant_health,1,0");
    public ArrayList<MobEffectInstance> badPotionsList;
    public ArrayList<MobEffectInstance> goodPotionsList;
    public double lingeringChance = 0.15;
    public double anotherThrowChance = 0.2;
    public MinMax throwSpeed = new MinMax(50.0, 70.0);
    public MinMax throwRange = new MinMax(16.0, 32.0);
    public boolean useSlowFalling = true;
    public double healthThresholdInvisiblity = 0.5;
    public Blacklist entityBlacklist;

    public WitchPotionThrowing(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.badPotionsListConfig = Config.builder.comment("A list of potions that the witch can throw at enemies. Format is effect_id,duration,amplifier. The potions are applied in order and witches will not throw the same potion if the target has already the effect.").defineList("Bad Potions List", badPotionsListDefault, o -> o instanceof String);
        this.goodPotionsListConfig = Config.builder.comment("A list of potions that the witch can throw at allies (in raids). Format is effect_id,duration,amplifier. The potions are applied in order and witches will not throw the same potion if the target has already the effect.").defineList("Good Potions List", goodPotionsListDefault, o -> o instanceof String);
        this.lingeringChanceConfig = Config.builder.comment("Chance for the potions thrown by the Witch to be lingering.").defineInRange("Lingering Chance", this.lingeringChance, 0.0, 1.0);
        this.anotherThrowChanceConfig = Config.builder.comment("Chance for the Witch to throw another random potion right after she threw one.").defineInRange("Another Throw Chance", this.anotherThrowChance, 0.0, 1.0);
        this.throwSpeedConfig = new MinMax.Config(Config.builder, "Throw Speed", "Speed at which Witches throw potions").setMinMax(10.0, 2.147483647E9, this.throwSpeed).build();
        this.throwRangeConfig = new MinMax.Config(Config.builder, "Throw Range", "Range at which Witches throw potions").setMinMax(8.0, 64.0, this.throwRange).build();
        this.useSlowFallingConfig = Config.builder.comment("If true, witches will throw a potion of slow falling at their feet when they're falling for more than 8 blocks.").define("Use Slow Falling", this.useSlowFalling);
        this.healthThresholdInvisiblityConfig = Config.builder.comment("When below this health percentage Witches will throw Invisibility potions at their feet.").defineInRange("Health Threshold Invisibility", this.healthThresholdInvisiblity, 0.0, 1.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the new Witch ranged attack AI").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.badPotionsList = MCUtils.parseMobEffectsList((List)((List)this.badPotionsListConfig.get()));
        this.goodPotionsList = MCUtils.parseMobEffectsList((List)((List)this.goodPotionsListConfig.get()));
        this.lingeringChance = (Double)this.lingeringChanceConfig.get();
        this.anotherThrowChance = (Double)this.anotherThrowChanceConfig.get();
        this.throwSpeed = this.throwSpeedConfig.get();
        this.throwRange = this.throwRangeConfig.get();
        this.useSlowFalling = (Boolean)this.useSlowFallingConfig.get();
        this.healthThresholdInvisiblity = (Double)this.healthThresholdInvisiblityConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        Witch witch;
        Entity entity;
        if (!this.isEnabled() || event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof Witch) || this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(witch = (Witch)entity))) {
            return;
        }
        CompoundTag persistentData = witch.getPersistentData();
        int attackSpeed = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:attack_speed", this.throwSpeed.getIntRandBetween(witch.m_21187_()));
        int attackRange = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:attack_range", this.throwRange.getIntRandBetween(witch.m_21187_()));
        double lingeringChance = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:lingering_chance", this.lingeringChance);
        double anotherThrowChance = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:another_throw_chance", this.anotherThrowChance);
        List<Goal> rangedAttackGoals = witch.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof RangedAttackGoal).toList();
        rangedAttackGoals.forEach(arg_0 -> ((GoalSelector)witch.f_21345_).m_25363_(arg_0));
        witch.f_21345_.m_25352_(2, (Goal)new WitchThrowPotionGoal(witch, attackSpeed, attackSpeed, attackRange, lingeringChance, anotherThrowChance));
    }

    public boolean shouldUseSlowFalling() {
        return this.isEnabled() && this.useSlowFalling;
    }
}

