/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.config;

import insane96mcp.insanelib.util.IdTagMatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;

public class Blacklist {
    public ArrayList<IdTagMatcher> blacklist;
    public boolean blacklistAsWhitelist;

    public Blacklist(ArrayList<IdTagMatcher> blacklist, boolean blacklistAsWhitelist) {
        this.blacklist = blacklist;
        this.blacklistAsWhitelist = blacklistAsWhitelist;
    }

    public boolean isBlockBlackOrNotWhiteListed(Block entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesBlock(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isItemBlackOrNotWhiteListed(Item entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesItem(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isFluidBlackOrNotWhiteListed(Fluid entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesFluid(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isEntityBlackOrNotWhitelist(Entity entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesEntity(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isEntityBlackOrNotWhitelist(EntityType<?> entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesEntity(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public static class Config {
        private final ForgeConfigSpec.Builder builder;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> listConfig;
        public ForgeConfigSpec.ConfigValue<Boolean> listAsWhitelistConfig;

        public Config(ForgeConfigSpec.Builder builder, String optionName, String description) {
            this.builder = builder;
            builder.comment(description).push(optionName);
        }

        public Config setDefaultList(List<String> defaultValue) {
            this.listConfig = this.builder.defineList("Blacklist", defaultValue, o -> o instanceof String);
            return this;
        }

        public Config setIsDefaultWhitelist(boolean isDefaultWhitelist) {
            this.listAsWhitelistConfig = this.builder.comment("If true the list will be treated as a whitelist instead of blacklist").define("List as Whitelist", isDefaultWhitelist);
            return this;
        }

        public Config build() {
            this.builder.pop();
            return this;
        }

        public Blacklist get() {
            return new Blacklist(IdTagMatcher.parseStringList((List)this.listConfig.get()), (Boolean)this.listAsWhitelistConfig.get());
        }
    }
}

