/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal.feature;

import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Animal Attacking", description="Make animals fight back and no longer flee when attacked")
@LoadFeature(module="enhancedai:animal")
public class AnimalAttacking
extends Feature {
    @Config
    @Label(name="Animals Fight back", description="If true, when attacked, animals will call other animals for help and attack back. Animals have a slightly bigger range to attack. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to change the damage. Base damage is 4")
    public static Boolean animalsFightBack = true;
    @Config
    @Label(name="Animals No Longer Flee", description="If true, when attacked, animals will no longer flee.")
    public static Boolean noMoreFlee = true;
    @Config(min=0.0, max=4.0)
    @Label(name="Movement Speed Multiplier", description="Movement speed multiplier when aggroed.")
    public static Double speedMultiplier = 1.35;
    @Config(min=0.0, max=128.0)
    @Label(name="Knockback", description="Animals' knockback attribute will be set to this value.")
    public static Double knockback = 3.5;
    @Config
    @Label(name="Entity Blacklist", description="Entities that shouldn't be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(List.of(), false);
    private static final double BASE_ATTACK_DAMAGE = 4.0;

    public AnimalAttacking(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, Attributes.f_22281_)) continue;
            event.add(entityType, Attributes.f_22281_, 4.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Animal animal;
        Entity entity;
        if (!this.isEnabled() || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(animal = (Animal)entity))) {
            return;
        }
        CompoundTag persistentData = animal.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", speedMultiplier);
        if (animalsFightBack.booleanValue()) {
            AttributeInstance kbAttribute;
            animal.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)animal, new Class[0]).m_26044_(new Class[0]));
            animal.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)animal, movementSpeedMultiplier, false));
            if (knockback > 0.0 && (kbAttribute = animal.m_21051_(Attributes.f_22282_)) != null) {
                kbAttribute.m_22125_(new AttributeModifier("Animal knockback", knockback.doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        }
        if (noMoreFlee.booleanValue()) {
            ArrayList<Object> goalsToRemove = new ArrayList<Object>();
            for (WrappedGoal prioritizedGoal : animal.f_21345_.f_25345_) {
                Goal goal = prioritizedGoal.m_26015_();
                if (!(goal instanceof PanicGoal)) continue;
                PanicGoal goal2 = (PanicGoal)goal;
                goalsToRemove.add(goal2);
            }
            goalsToRemove.forEach((Consumer<Object>)((Consumer<Goal>)arg_0 -> ((GoalSelector)animal.f_21345_).m_25363_(arg_0)));
        }
    }
}

