/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;

@Label(name="Attacking", description="Changes attack range to use the 1.20.2 mechanic")
@LoadFeature(module="enhancedai:base")
public class Attacking
extends Feature {
    @Config
    @Label(name="Melee Attacks Attribute Based", description="If true melee monsters (zombies, etc) will attack based off the forge:attack_range attribute instead of a fixed ~0.82 blocks. By default, mobs' forge:attack_range is set to 0.82 blocks, like vanilla 1.20.2.")
    public static Boolean meleeAttacksAttributeBased = false;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;

    public Attacking(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void attackRangeAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)ForgeMod.ATTACK_RANGE.get())) continue;
            event.add(entityType, (Attribute)ForgeMod.ATTACK_RANGE.get(), DEFAULT_ATTACK_REACH);
        }
    }

    public static Boolean shouldChangeAttackRange() {
        return Attacking.isEnabled(Attacking.class) && meleeAttacksAttributeBased != false;
    }

    public static boolean isWithinMeleeAttackRange(LivingEntity attacker, LivingEntity attacked) {
        return Attacking.getAttackBoundingBox(attacker).m_82381_(Attacking.getHitbox(attacked));
    }

    protected static AABB getAttackBoundingBox(LivingEntity attacker) {
        AABB aabb;
        Entity entity = attacker.m_20202_();
        if (entity != null) {
            AABB veichleAABB = entity.m_20191_();
            AABB attackerAABB = attacker.m_20191_();
            aabb = new AABB(Math.min(attackerAABB.f_82288_, veichleAABB.f_82288_), attackerAABB.f_82289_, Math.min(attackerAABB.f_82290_, veichleAABB.f_82290_), Math.max(attackerAABB.f_82291_, veichleAABB.f_82291_), attackerAABB.f_82292_, Math.max(attackerAABB.f_82293_, veichleAABB.f_82293_));
        } else {
            aabb = attacker.m_20191_();
        }
        double attackReach = DEFAULT_ATTACK_REACH;
        if (Attacking.shouldChangeAttackRange().booleanValue()) {
            attackReach = attacker.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
        }
        return aabb.m_82377_(attackReach, 0.0, attackReach);
    }

    protected static AABB getHitbox(LivingEntity entity) {
        AABB aabb = entity.m_20191_();
        Entity veichle = entity.m_20202_();
        if (veichle != null) {
            Vec3 vec3 = new Vec3(entity.m_20185_(), veichle.m_6048_(), entity.m_20186_());
            return aabb.m_165887_(Math.max(vec3.f_82480_, aabb.f_82289_));
        }
        return aabb;
    }
}

