/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.AvoidExplosionGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Avoid Explosions", description="Mobs will run away from exploding creepers / TNT")
@LoadFeature(module="enhancedai:base")
public class AvoidExplosions
extends Feature {
    @Config(min=0.0, max=10.0)
    @Label(name="Flee speed Multiplier Near", description="Speed multiplier when the mob runs from explosions and it's within 7 blocks from him.")
    public static Double runSpeedNear = 1.4;
    @Config(min=0.0, max=10.0)
    @Label(name="Flee speed Multiplier Far", description="Speed multiplier when the mob runs from explosions and it's farther than 7 blocks from him.")
    public static Double runSpeedFar = 1.2;
    @Config(min=0.0, max=10.0)
    @Label(name="Entity Blacklist", description="Entities that shouldn't be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public AvoidExplosions(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.addAvoidAI(event);
        this.alertTNT(event);
    }

    private void addAvoidAI(EntityJoinLevelEvent event) {
        PathfinderMob creatureEntity;
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(creatureEntity = (PathfinderMob)entity))) {
            return;
        }
        creatureEntity.f_21345_.m_25352_(1, (Goal)new AvoidExplosionGoal(creatureEntity, runSpeedNear, runSpeedFar));
    }

    private void alertTNT(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PrimedTnt)) {
            return;
        }
        PrimedTnt tnt = (PrimedTnt)entity;
        List creaturesNearby = tnt.f_19853_.m_45976_(PathfinderMob.class, tnt.m_20191_().m_82400_(8.0));
        for (PathfinderMob creatureEntity : creaturesNearby) {
            creatureEntity.f_21345_.f_25345_.forEach(prioritizedGoal -> {
                Goal patt2655$temp = prioritizedGoal.m_26015_();
                if (patt2655$temp instanceof AvoidExplosionGoal) {
                    AvoidExplosionGoal avoidExplosionGoal = (AvoidExplosionGoal)patt2655$temp;
                    avoidExplosionGoal.run((Entity)tnt, 8.0);
                }
            });
        }
    }
}

