/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.EANearestAttackableTarget;
import insane96mcp.enhancedai.modules.base.ai.EASpiderTargetGoal;
import insane96mcp.enhancedai.setup.EAAttributes;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.IdTagMatcher;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Targeting", description="Change how mobs target players")
@LoadFeature(module="enhancedai:base")
public class Targeting
extends Feature {
    @Config(min=0.0, max=128.0)
    @Label(name="Follow Range Override", description="How far away can the mobs see the player. This overrides the vanilla value (16 for most mobs). Setting 'Max' to 0 will leave the follow range as vanilla. I recommend using mods like Mobs Properties Randomness to have more control over the attribute.")
    public static MinMax followRangeOverride = new MinMax(32.0, 64.0);
    @Config(min=0.0, max=128.0)
    @Label(name="XRay Range Override", description="How far away can the mobs see the player even through walls. Setting 'Max' to 0 will make mobs not able to see through walls. I recommend using mods like Mobs Properties Randomness to have more control over the attribute; the attribute name is 'enhancedai:generic.xray_follow_range'.")
    public static MinMax xrayRangeOverride = new MinMax(16.0, 32.0);
    @Config
    @Label(name="Instant Target", description="Mobs will no longer take random time to target a player.")
    public static Boolean instaTarget = true;
    @Config
    @Label(name="Better Path Finding", description="Mobs will be able to find better paths to the target. Note that this might hit performance a bit.")
    public static Boolean betterPathfinding = true;
    @Config
    @Label(name="Prevent Infighting", description="Mobs will no longer attack each other.")
    public static Boolean preventInfighting = true;
    @Config
    @Label(name="Entity Blacklist", description="Entities in here will not be affected by this feature.")
    public static Blacklist entityBlacklist = new Blacklist(List.of(new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:enderman"), new IdTagMatcher(IdTagMatcher.Type.ID, "autumnity:turkey")), false);

    public Targeting(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void xrayRangeAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get())) continue;
            event.add(entityType, (Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get(), 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMobSpawn(EntityJoinLevelEvent event) {
        Mob mobEntity;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Mob) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(mobEntity = (Mob)entity))) {
            return;
        }
        this.processFollowRanges(mobEntity);
        this.processTargetGoal(mobEntity);
        this.processHurtByGoal(mobEntity);
    }

    private void processHurtByGoal(Mob mobEntity) {
        if (!preventInfighting.booleanValue() || !(mobEntity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)mobEntity;
        HurtByTargetGoal toRemove = null;
        for (WrappedGoal prioritizedGoal : mob.f_21346_.f_25345_) {
            HurtByTargetGoal goal;
            Goal goal2 = prioritizedGoal.m_26015_();
            if (!(goal2 instanceof HurtByTargetGoal)) continue;
            toRemove = goal = (HurtByTargetGoal)goal2;
            ArrayList<Class> toIgnoreDamage = new ArrayList<Class>(Arrays.asList(goal.f_26035_));
            toIgnoreDamage.add(Enemy.class);
            HurtByTargetGoal newGoal = new HurtByTargetGoal(mob, (Class[])toIgnoreDamage.toArray(Class[]::new));
            if (goal.f_26036_ != null) {
                newGoal = newGoal.m_26044_(goal.f_26036_);
            }
            mob.f_21346_.m_25352_(prioritizedGoal.m_26012_(), (Goal)newGoal);
            break;
        }
        if (toRemove != null) {
            mobEntity.f_21346_.m_25363_(toRemove);
        }
    }

    private void processTargetGoal(Mob mobEntity) {
        ArrayList<WrappedGoal> goalsToAdd = new ArrayList<WrappedGoal>();
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : mobEntity.f_21346_.f_25345_) {
            Goal goal = prioritizedGoal.m_26015_();
            if (!(goal instanceof NearestAttackableTargetGoal)) continue;
            NearestAttackableTargetGoal goal2 = (NearestAttackableTargetGoal)goal;
            if (goal2.f_26048_ != Player.class) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
            EANearestAttackableTarget newTargetGoal = mobEntity instanceof Spider ? new EASpiderTargetGoal<Player>((Spider)mobEntity, Player.class, true, false, (Predicate<LivingEntity>)goal2.f_26051_.f_26879_) : new EANearestAttackableTarget(mobEntity, Player.class, false, false, goal2.f_26051_.f_26879_);
            if (instaTarget.booleanValue()) {
                newTargetGoal.setInstaTarget();
            }
            goalsToAdd.add(new WrappedGoal(prioritizedGoal.m_26012_(), newTargetGoal));
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)mobEntity.f_21346_).m_25363_(arg_0));
        goalsToAdd.forEach(wrappedGoal -> mobEntity.f_21346_.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_()));
        if (betterPathfinding.booleanValue()) {
            mobEntity.m_21573_().m_26529_(4.0f);
        }
    }

    private void processFollowRanges(Mob mobEntity) {
        CompoundTag persistentData = mobEntity.getPersistentData();
        if (!persistentData.m_128471_("enhancedai:follow_ranges_processed")) {
            if (Targeting.followRangeOverride.min != 0.0 && mobEntity.m_21051_(Attributes.f_22277_) != null && mobEntity.m_21051_(Attributes.f_22277_).m_22115_() < Targeting.followRangeOverride.min) {
                MCUtils.setAttributeValue((LivingEntity)mobEntity, (Attribute)Attributes.f_22277_, (double)followRangeOverride.getIntRandBetween(mobEntity.m_217043_()));
            }
            if (Targeting.xrayRangeOverride.min != 0.0 && mobEntity.m_21051_((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()) != null && mobEntity.m_21051_((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()).m_22115_() < Targeting.xrayRangeOverride.min) {
                MCUtils.setAttributeValue((LivingEntity)mobEntity, (Attribute)((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()), (double)xrayRangeOverride.getIntRandBetween(mobEntity.m_217043_()));
            }
            persistentData.m_128379_("enhancedai:follow_ranges_processed", true);
        }
    }
}

