/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.blaze.feature;

import insane96mcp.enhancedai.modules.blaze.ai.EABlazeAttackGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Blaze Attack", description="Make blazes fire faster/more fireballs")
@LoadFeature(module="enhancedai:blaze")
public class BlazeAttack
extends Feature {
    @Config(min=1.0, max=300.0)
    @Label(name="Time Between Fireballs", description="How many ticks pass between shooting fireballs. Vanilla is 6")
    public static MinMax timeBetweenFireballs = new MinMax(4.0, 10.0);
    @Config(min=1.0, max=64.0)
    @Label(name="Fireballs shot", description="How many fireballs blazes shoots. Vanilla is 3")
    public static MinMax fireballsShot = new MinMax(3.0, 8.0);
    @Config(min=1.0, max=600.0)
    @Label(name="Recharge time", description="Time (in ticks) taken by the blaze to recharge (before setting himself on fire). Vanilla is 100")
    public static MinMax rechargeTime = new MinMax(60.0, 100.0);
    @Config(min=1.0, max=600.0)
    @Label(name="Charge time", description="Time (in ticks) taken by the blaze to charge (while on fire before shooting fireballs). Vanilla is 60")
    public static MinMax chargeTime = new MinMax(30.0, 60.0);
    @Config(min=1.0, max=8.0)
    @Label(name="Fireballs Per Shot", description="How many fireballs are shot per shot. Vanilla is 1")
    public static MinMax fireballsPerShot = new MinMax(1.0, 2.0);
    @Config(min=-1.0, max=32.0)
    @Label(name="Inaccuracy", description="The higher the more spread up shots will be. Setting both to -1 will use the vanilla behaviour (farther = more inaccuracy)")
    public static MinMax inaccuracy = new MinMax(2.0, 8.0);
    @Config
    @Label(name="Entity Blacklist", description="Entities that shouldn't be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public BlazeAttack(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Blaze blaze;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Blaze) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(blaze = (Blaze)entity))) {
            return;
        }
        CompoundTag persistentData = blaze.getPersistentData();
        int timeBetweenFireballs1 = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:time_between_fireballs", timeBetweenFireballs.getIntRandBetween(blaze.m_217043_()));
        int fireballsShot1 = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:fireballs_shot", fireballsShot.getIntRandBetween(blaze.m_217043_()));
        int rechargeTime1 = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:recharge_time", rechargeTime.getIntRandBetween(blaze.m_217043_()));
        int chargeTime1 = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:charge_time", chargeTime.getIntRandBetween(blaze.m_217043_()));
        int fireballsPerShot1 = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:fireballs_per_shot", fireballsPerShot.getIntRandBetween(blaze.m_217043_()));
        int inaccuracy1 = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:inaccuracy", inaccuracy.getIntRandBetween(blaze.m_217043_()));
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        blaze.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Blaze.BlazeAttackGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)blaze.f_21345_).m_25363_(arg_0));
        blaze.f_21345_.m_25352_(4, (Goal)new EABlazeAttackGoal(blaze).setTimeBetweenFireballs(timeBetweenFireballs1).setFireballShot(fireballsShot1).setRechargeTime(rechargeTime1).setChargeTime(chargeTime1).setFireballsPerShot(fireballsPerShot1).setInaccuracy(inaccuracy1));
    }
}

