/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.feature;

import insane96mcp.enhancedai.modules.creeper.ai.AICreeperLaunchGoal;
import insane96mcp.enhancedai.modules.creeper.ai.AICreeperSwellGoal;
import insane96mcp.enhancedai.setup.EASounds;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Creeper Swell", description="Various changes to Creepers exploding. Ignoring Walls, Walking Fuse and smarter exploding based off explosion size")
@LoadFeature(module="enhancedai:creeper")
public class CreeperSwell
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Walking Fuse Chance", description="Percentage chance for a Creeper to keep walking while exploding.")
    public static Double walkingFuseChance = 0.1;
    @Config(min=0.0, max=1.0)
    @Label(name="Ignore Walls Chance", description="Percentage chance for a Creeper to ignore walls while targeting a player. This means that a creeper will be able to explode if it's in the correct range from a player even if there's a wall between.")
    public static Double ignoreWallsChance = 0.1;
    @Config(min=0.0, max=1.0)
    @Label(name="Launch Chance", description="Launching creepers will try ignite and throw themselves at the player.")
    public static Double launchChance = 0.05;
    @Config(min=0.0, max=1.0)
    @Label(name="Breach Chance", description="Breaching creepers will try to open an hole in the wall to let mobs in.")
    public static Double breachChance = 0.075;
    @Config
    @Label(name="TNT Like", description="If true creepers will ignite if damaged by an explosion.")
    public static Boolean tntLike = false;
    @Config(min=0.0, max=1.0)
    @Label(name="Cena.Chance", description="AND HIS NAME IS ...")
    public static Double cenaChance = 0.02;
    @Config
    @Label(name="Cena.Generates fire", description="If true, Creeper Cena explosion will generate fire")
    public static Boolean cenaFire = false;
    @Config(min=0.0, max=12.0)
    @Label(name="Cena.Explosion power", description="Explosion power of Creeper Cena")
    public static Double cenaExplosionPower = 6.0;

    public CreeperSwell(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void explosionStartEvent(ExplosionEvent.Detonate event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion e = event.getExplosion();
        Entity entity = e.getExploder();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        if (creeper.getPersistentData().m_128471_("enhancedai:cena")) {
            creeper.m_5496_((SoundEvent)EASounds.CREEPER_CENA_EXPLODE.get(), 4.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        creeper.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof SwellGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)creeper.f_21345_).m_25363_(arg_0));
        CompoundTag persistentData = creeper.getPersistentData();
        boolean walkingFuse = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:walking_fuse", creeper.m_217043_().m_188500_() < walkingFuseChance);
        boolean ignoreWalls = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:ignore_walls", creeper.m_217043_().m_188500_() < ignoreWallsChance);
        boolean breach = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:breach", creeper.m_217043_().m_188500_() < breachChance);
        boolean launch = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:launch", creeper.m_217043_().m_188500_() < launchChance);
        boolean cena = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:cena", creeper.m_217043_().m_188500_() < cenaChance);
        if (cena) {
            creeper.m_6593_((Component)Component.m_237113_((String)"Creeper Cena"));
            CompoundTag compoundNBT = new CompoundTag();
            creeper.m_7380_(compoundNBT);
            compoundNBT.m_128376_("Fuse", (short)36);
            compoundNBT.m_128344_("ExplosionRadius", cenaExplosionPower.byteValue());
            creeper.m_7378_(compoundNBT);
            if (cenaFire.booleanValue()) {
                persistentData.m_128379_("insanelib:explosion_causes_fire", true);
            }
        }
        AICreeperSwellGoal swellGoal = new AICreeperSwellGoal(creeper).setWalkingFuse(walkingFuse).setIgnoreWalls(ignoreWalls).setBreaching(breach);
        creeper.f_21345_.m_25352_(2, (Goal)swellGoal);
        if (launch) {
            creeper.f_21345_.m_25352_(1, (Goal)new AICreeperLaunchGoal(creeper));
        }
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && tntLike.booleanValue() && event.getSource().m_19372_() && (livingEntity = event.getEntity()) instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)livingEntity;
        creeper.m_32312_();
    }

    @SubscribeEvent
    public void onLaunchCreeperUpdate(LivingEvent.LivingTickEvent event) {
        Creeper creeper;
        block6: {
            block5: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || event.getEntity().f_19797_ % 20 != 0 || !((livingEntity = event.getEntity()) instanceof Creeper)) break block5;
                creeper = (Creeper)livingEntity;
                if (!creeper.f_19853_.f_46443_) break block6;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)creeper.f_19853_;
        if (creeper.getPersistentData().m_128471_("enhancedai:launch")) {
            for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
                serverLevel.m_8624_(serverplayer, (ParticleOptions)ParticleTypes.f_123796_, true, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), 10, 0.1, 0.1, 0.1, 0.1);
            }
        }
    }
}

