/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.ai;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.setup.Reflection;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EARangedBowAttackGoal<T extends Monster>
extends Goal {
    private final T entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private int bowChargeTicks;
    private float inaccuracy;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private final boolean canStrafe;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EARangedBowAttackGoal(T mob, double moveSpeedAmpIn, float maxAttackDistanceIn, boolean canStrafe) {
        this.entity = mob;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.canStrafe = canStrafe;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public EARangedBowAttackGoal<T> setAttackCooldown(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
        return this;
    }

    public EARangedBowAttackGoal<T> setBowChargeTicks(int bowChargeTicks) {
        this.bowChargeTicks = bowChargeTicks;
        return this;
    }

    public EARangedBowAttackGoal<T> setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null && this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return this.entity.m_21093_(stack -> stack.m_41720_() instanceof BowItem);
    }

    public boolean m_8045_() {
        return this.m_8036_() && this.isBowInMainhand();
    }

    public void m_8056_() {
        super.m_8056_();
        this.entity.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.m_5810_();
    }

    public void m_8037_() {
        boolean flag1;
        LivingEntity target = this.entity.m_5448_();
        if (target == null) {
            return;
        }
        double distanceFromTarget = this.entity.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean canSeeTarget = this.entity.m_21574_().m_148306_((Entity)target);
        boolean bl = flag1 = this.seeTime > 0;
        if (canSeeTarget != flag1) {
            this.seeTime = 0;
        }
        this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
        if (distanceFromTarget > (double)this.maxAttackDistance) {
            this.entity.m_21573_().m_5624_((Entity)target, this.moveSpeedAmp);
        } else {
            int i;
            this.strafingTime = distanceFromTarget >= 49.0 && distanceFromTarget <= (double)this.maxAttackDistance && this.seeTime >= 20 && this.canStrafe() ? ++this.strafingTime : -1;
            if (this.strafingTime >= 20) {
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if ((i = this.entity.m_21252_()) > 12) {
                this.entity.m_21573_().m_26573_();
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else if (this.strafingTime > -1 && this.canStrafe()) {
                if (distanceFromTarget > (double)(this.maxAttackDistance * 0.9f)) {
                    this.strafingBackwards = false;
                } else if (distanceFromTarget < (double)(this.maxAttackDistance * 0.8f)) {
                    this.strafingBackwards = true;
                }
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            }
            this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.entity.m_6117_()) {
                if (!canSeeTarget && this.seeTime < -60) {
                    this.entity.m_5810_();
                } else if (canSeeTarget && i >= this.bowChargeTicks) {
                    this.entity.m_5810_();
                    this.attackEntityWithRangedAttack(this.entity, target, i);
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.entity.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.entity, item -> item == Items.f_42411_));
            }
        }
    }

    private boolean canStrafe() {
        return this.canStrafe && ((Monster)this.entity).f_21345_.m_25386_().noneMatch(p -> p.m_26015_() instanceof EAAvoidEntityGoal);
    }

    private void attackEntityWithRangedAttack(T entity, LivingEntity target, int chargeTicks) {
        AbstractArrow abstractarrowentity;
        ItemStack itemstack = entity.m_6298_(entity.m_21120_(ProjectileUtil.getWeaponHoldingHand(entity, item -> item == Items.f_42411_)));
        double distance = entity.m_20270_((Entity)target);
        double distanceY = target.m_20186_() - entity.m_20186_();
        float f = 1.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton skeleton = (AbstractSkeleton)entity;
            abstractarrowentity = Reflection.AbstractSkeleton_getArrow(skeleton, itemstack, BowItem.m_40661_((int)chargeTicks));
        } else {
            abstractarrowentity = ProjectileUtil.m_37300_(entity, (ItemStack)itemstack, (float)f);
        }
        if (entity.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)entity.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double dirX = target.m_20185_() - entity.m_20185_();
        double dirZ = target.m_20189_() - entity.m_20189_();
        double distanceXZ = Math.sqrt(dirX * dirX + dirZ * dirZ);
        double yPos = target.m_20227_(0.0);
        yPos += (double)target.m_20192_() * 0.5;
        if (distanceXZ != 0.0) {
            yPos += distanceY / distanceXZ;
        }
        double dirY = yPos - abstractarrowentity.m_20186_();
        abstractarrowentity.m_6686_(dirX, dirY + distanceXZ * 0.17, dirZ, f * 1.1f + (float)distance / 32.0f + (float)Math.max(distanceY / 48.0, 0.0), this.inaccuracy);
        entity.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
        ((Monster)entity).f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public boolean m_183429_() {
        return true;
    }
}

