/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.feature;

import insane96mcp.enhancedai.modules.witch.ai.WitchThrowPotionGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Witch Potion Throwing", description="Witches throw potions farther, faster and more potion types. Also no longer chase player if they can't see him.")
@LoadFeature(module="enhancedai:witch")
public class WitchPotionThrowing
extends Feature {
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> badPotionsListConfig;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> goodPotionsListConfig;
    public static final List<String> badPotionsListDefault;
    public static final List<String> goodPotionsListDefault;
    public static ArrayList<MobEffectInstance> badPotionsList;
    public static ArrayList<MobEffectInstance> goodPotionsList;
    @Config(min=0.0, max=1.0)
    @Label(name="Lingering Chance", description="Chance for the potions thrown by the Witch to be lingering.")
    public static Double lingeringChance;
    @Config(min=0.0, max=1.0)
    @Label(name="Another Throw Chance", description="Chance for the Witch to throw another random potion right after she threw one.")
    public static Double anotherThrowChance;
    @Config(min=1.0)
    @Label(name="Throw Speed", description="Speed at which Witches throw potions (in ticks).")
    public static MinMax throwSpeed;
    @Config(min=8.0, max=64.0)
    @Label(name="Throw Range", description="Range at which Witches throw potions.")
    public static MinMax throwRange;
    @Config
    @Label(name="Use Slow Falling", description="If true, witches will throw a potion of slow falling at their feet when they're falling for more than 8 blocks.")
    public static Boolean useSlowFalling;
    @Config(min=0.0, max=1.0)
    @Label(name="Health Threshold Invisibility", description="When below this health percentage Witches will throw Invisibility potions at their feet.")
    public static Double healthThresholdInvisibility;
    @Config
    @Label(name="Entity Blacklist", description="Entities that will not get affected by this feature")
    public static Blacklist entityBlacklist;

    public WitchPotionThrowing(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void loadConfigOptions() {
        super.loadConfigOptions();
        badPotionsListConfig = this.getBuilder().comment("A list of potions that the witch can throw at enemies. Format is effect_id,duration,amplifier. The potions are applied in order and witches will not throw the same potion if the target has already the effect.").defineList("Bad Potions List", badPotionsListDefault, o -> o instanceof String);
        goodPotionsListConfig = this.getBuilder().comment("A list of potions that the witch can throw at allies (in raids). Format is effect_id,duration,amplifier. The potions are applied in order and witches will not throw the same potion if the target has already the effect.").defineList("Good Potions List", goodPotionsListDefault, o -> o instanceof String);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        badPotionsList = MCUtils.parseMobEffectsList((List)((List)badPotionsListConfig.get()));
        goodPotionsList = MCUtils.parseMobEffectsList((List)((List)goodPotionsListConfig.get()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Witch witch;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Witch) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(witch = (Witch)entity))) {
            return;
        }
        CompoundTag persistentData = witch.getPersistentData();
        int attackSpeed = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:attack_speed", throwSpeed.getIntRandBetween(witch.m_217043_()));
        int attackRange = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:attack_range", throwRange.getIntRandBetween(witch.m_217043_()));
        double lingeringChance1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:lingering_chance", lingeringChance);
        double anotherThrowChance1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:another_throw_chance", anotherThrowChance);
        List<Goal> rangedAttackGoals = witch.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof RangedAttackGoal).toList();
        rangedAttackGoals.forEach(arg_0 -> ((GoalSelector)witch.f_21345_).m_25363_(arg_0));
        witch.f_21345_.m_25352_(2, (Goal)new WitchThrowPotionGoal(witch, attackSpeed, attackSpeed, attackRange, lingeringChance1, anotherThrowChance1));
    }

    public static boolean shouldUseSlowFalling() {
        return WitchPotionThrowing.isEnabled(WitchPotionThrowing.class) && useSlowFalling != false;
    }

    static {
        badPotionsListDefault = Arrays.asList("minecraft:weakness,900,0", "minecraft:slowness,1200,1", "minecraft:hunger,600,0", "minecraft:mining_fatigue,600,0", "minecraft:poison,900,0", "minecraft:blindness,120,0", "minecraft:instant_damage,1,0");
        goodPotionsListDefault = Arrays.asList("minecraft:regeneration,900,0", "minecraft:speed,1800,0", "minecraft:strength,1800,0", "minecraft:instant_health,1,0");
        lingeringChance = 0.15;
        anotherThrowChance = 0.2;
        throwSpeed = new MinMax(50.0, 70.0);
        throwRange = new MinMax(16.0, 32.0);
        useSlowFalling = true;
        healthThresholdInvisibility = 0.5;
        entityBlacklist = new Blacklist(Collections.emptyList(), false);
    }
}

