/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.feature;

import insane96mcp.enhancedai.modules.zombie.ai.PearlUseGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.IdTagMatcher;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Pearler Zombie", description="Let zombies use ender pearls. Either put ender pearls in main or off hand and when far enough from the player they will throw it.")
@LoadFeature(module="enhancedai:zombie")
public class PearlerZombie
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Equip Ender Pearl Chance", description="Chance for a Zombie to spawn with an ender pearl in the offhand. I highly recommend using something like Mobs Properties Randomness to have more control over mobs equipment.")
    public static Double equipEnderPearlChance = 0.05;
    @Config(min=0.0, max=16.0)
    @Label(name="Ender Pearl Amount", description="How many ender pearls will Zombies spawn with.")
    public static Integer enderPearlAmount = 2;
    @Config(min=1.0, max=128.0)
    @Label(name="Inaccuracy", description="Inaccuracy when throwing the ender pearl.")
    public static Integer inaccuracy = 4;
    @Config(min=1.0, max=128.0)
    @Label(name="Entity Blacklist", description="Entities that will not be affected by this module.")
    public static Blacklist entityBlacklist = new Blacklist(List.of(new IdTagMatcher(IdTagMatcher.Type.ID, "quark:forgotten")), false);

    public PearlerZombie(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Zombie zombie;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Zombie) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(zombie = (Zombie)entity))) {
            return;
        }
        if (zombie.m_217043_().m_188500_() < equipEnderPearlChance) {
            zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42584_, enderPearlAmount.intValue()));
        }
        zombie.f_21345_.m_25352_(2, (Goal)new PearlUseGoal(zombie));
    }
}

