/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.modules.skeleton.ai.EARangedBowAttackGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.IdTagMatcher;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;

@Label(name="Skeleton Shoot", description="Skeletons are more precise when shooting and strafing is removed, can hit a target from up to 64 blocks and try to stay away from the target.")
@LoadFeature(module="enhancedai:skeleton")
public class SkeletonShoot
extends Feature {
    public static final String STRAFE = "enhancedai:strafe";
    public static final String SHOOTING_RANGE = "enhancedai:shooting_range";
    public static final String INACCURACY = "enhancedai:inaccuracy";
    @Config(min=1.0, max=64.0)
    @Label(name="Shooting Range", description="The range from where a skeleton will shoot a player")
    public static MinMax shootingRange = new MinMax(24.0, 32.0);
    @Config(min=0.0, max=1.0)
    @Label(name="Strafe chance", description="Chance for a Skeleton to spawn with the ability to strafe (like vanilla)")
    public static Double strafeChance = 0.333;
    @Config(min=0.0, max=30.0)
    @Label(name="Arrow Inaccuracy", description="How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.")
    public static Double arrowInaccuracy = 2.0;
    @Config(min=0.0, max=1.0)
    @Label(name="Spammer chance", description="Chance for a Skeleton to spawn as a spammer, which spams arrows instead of fully charging the bow")
    public static Double spammerChance = 0.07;
    @Config
    @Label(name="Entity Blacklist", description="Entities that will not get affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(List.of(new IdTagMatcher(IdTagMatcher.Type.ID, "quark:forgotten")), false);

    public SkeletonShoot(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!SkeletonShoot.isEnabled(SkeletonShoot.class) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)skeleton)) {
            return;
        }
        CompoundTag persistentData = skeleton.getPersistentData();
        boolean strafe = NBTUtils.getBooleanOrPutDefault(persistentData, STRAFE, skeleton.m_217043_().m_188500_() < strafeChance);
        int shootingRange1 = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_RANGE, shootingRange.getIntRandBetween(skeleton.m_217043_()));
        double inaccuracy = NBTUtils.getDoubleOrPutDefault(persistentData, INACCURACY, arrowInaccuracy);
        boolean hasAIArrowAttack = false;
        for (WrappedGoal prioritizedGoal : skeleton.f_21345_.f_25345_) {
            if (!prioritizedGoal.m_26015_().equals(skeleton.f_32130_)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof EAAvoidEntityGoal).toList();
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.f_21345_).m_25363_(arg_0));
        if (hasAIArrowAttack) {
            int attackCooldown = 20;
            int bowChargeTicks = 20;
            if (skeleton.m_217043_().m_188500_() < spammerChance) {
                attackCooldown = 5;
                bowChargeTicks = 5;
                inaccuracy *= 2.0;
            }
            if (!skeleton.f_19853_.m_46791_().equals((Object)Difficulty.HARD)) {
                attackCooldown *= 2;
            }
            EARangedBowAttackGoal<AbstractSkeleton> EARangedBowAttackGoal2 = new EARangedBowAttackGoal<AbstractSkeleton>(skeleton, 1.0, shootingRange1, strafe).setAttackCooldown(attackCooldown).setBowChargeTicks(bowChargeTicks).setInaccuracy((float)inaccuracy);
            skeleton.f_21345_.m_25352_(2, EARangedBowAttackGoal2);
        }
    }
}

