/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.spider.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.Collections;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Miscellaneous", description="Various small changes to Spiders.")
@LoadFeature(module="enhancedai:spider")
public class Misc
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Fall Damage Reduction", description="Percentage reduction of the fall damage taken by spiders.")
    public static Double fallDamageReduction = 0.9;
    @Config
    @Label(name="Entity Blacklist", description="Entities that shouldn't be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public Misc(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(LivingDamageEvent event) {
        Spider spider;
        LivingEntity livingEntity;
        if (!this.isEnabled() || fallDamageReduction == 0.0 || !event.getSource().equals(DamageSource.f_19315_) || !((livingEntity = event.getEntity()) instanceof Spider) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(spider = (Spider)livingEntity))) {
            return;
        }
        event.setAmount((float)((double)event.getAmount() * (1.0 - fallDamageReduction)));
    }
}

