/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.spider.feature;

import insane96mcp.enhancedai.modules.spider.ai.WebThrowGoal;
import insane96mcp.enhancedai.modules.spider.entity.projectile.TemporaryCobwebTask;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.scheduled.ScheduledTasks;
import insane96mcp.insanelib.util.scheduled.ScheduledTickTask;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Throwing Web", description="Makes spiders throw a web at a player, slowing them.")
@LoadFeature(module="enhancedai:spider")
public class ThrowingWeb
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Web Throw Chance", description="Chance for a Spider to spawn with the ability to throw webs at the target.")
    public static Double webThrowChance = 0.1;
    @Config(min=0.0, max=6000.0)
    @Label(name="Destroy Web After", description="After how many ticks will the cobweb placed by the web projectile be destroyed?")
    public static Integer destroyWebAfter = 100;
    @Config(min=0.0, max=128.0)
    @Label(name="Web Damage", description="Damage when the projectiles hits a mob. The damage is set for normal difficulty. Hard difficulty gets +50% damage and Easy gets (-50% + 1) damage.")
    public static Double thrownWebDamage = 3.0;
    @Config(min=1.0, max=1200.0)
    @Label(name="Cooldown", description="Every how many ticks do spiders throw the projectile")
    public static MinMax throwingCooldown = new MinMax(40.0, 60.0);
    @Config(min=0.0, max=64.0)
    @Label(name="Distance Required", description="Distance Required for the spider to throw webs. Setting 'Minimum' to 0 will make the spider throw webs even when attacking the player.")
    public static MinMax distance = new MinMax(2.5, 32.0);
    @Config
    @Label(name="Always web", description="If true entities will get webbed when hit.")
    public static Boolean alwaysWeb = false;
    @Config
    @Label(name="Cave spiders poisonous webs", description="If true cave spiders' thrown web will poison entities hit like when they hit the entity melee.")
    public static Boolean caveSpidersPoisonousWebs = true;
    @Config
    @Label(name="Apply Slowness", description="If true entities will get slowness when hit.")
    public static Boolean applySlowness = true;
    @Config(min=0.0, max=6000.0)
    @Label(name="Slowness.Duration", description="How many ticks of slowness are applied to the target hit by the web?")
    public static Integer slownessDuration = 120;
    @Config(min=0.0, max=128.0)
    @Label(name="Slowness.Amplifier", description="How many levels of slowness are applied to the target hit by the web?")
    public static Integer slownessAmplifier = 1;
    @Config
    @Label(name="Slowness.Stacking Amplifier", description="Should multiple hits on a target with slowness increase the level of Slowness? (This works with any type of slowness)")
    public static Boolean stackSlowness = true;
    @Config(min=0.0, max=128.0)
    @Label(name="Slowness.Max Amplifier", description="How many max levels of slowness can be applied to the target?")
    public static Integer maxSlowness = 2;
    @Config
    @Label(name="Entity Blacklist", description="Entities that will not be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public ThrowingWeb(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Spider spider;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Spider) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(spider = (Spider)entity))) {
            return;
        }
        CompoundTag persistentData = spider.getPersistentData();
        boolean webThrower = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:web_thrower", spider.m_217043_().m_188500_() < webThrowChance);
        if (webThrower) {
            spider.f_21345_.m_25352_(2, (Goal)new WebThrowGoal(spider));
        }
    }

    public static void applyEffects(LivingEntity spider, LivingEntity entity) {
        ThrowingWeb.applySlowness(entity);
        ThrowingWeb.applyPoison(spider, entity);
    }

    public static void applySlowness(LivingEntity entity) {
        if (!applySlowness.booleanValue()) {
            return;
        }
        MobEffectInstance slowness = entity.m_21124_(MobEffects.f_19597_);
        if (stackSlowness.booleanValue() && slowness != null) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessDuration.intValue(), Math.min(slowness.m_19564_() + slownessAmplifier, maxSlowness - 1), true, true, true));
        } else {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessDuration.intValue(), slownessAmplifier - 1, true, true, true));
        }
    }

    public static void applyPoison(LivingEntity spider, LivingEntity entity) {
        if (!caveSpidersPoisonousWebs.booleanValue() || !(spider instanceof CaveSpider)) {
            return;
        }
        CaveSpider caveSpider = (CaveSpider)spider;
        int i = 0;
        if (caveSpider.f_19853_.m_46791_() == Difficulty.NORMAL) {
            i = 7;
        } else if (caveSpider.f_19853_.m_46791_() == Difficulty.HARD) {
            i = 15;
        }
        if (i > 0) {
            entity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0), (Entity)caveSpider);
        }
    }

    public static void applyWeb(LivingEntity entity) {
        if (!alwaysWeb.booleanValue()) {
            return;
        }
        BlockPos spawnCobwebAt = entity.m_20183_();
        if (FallingBlock.m_53241_((BlockState)entity.f_19853_.m_8055_(spawnCobwebAt))) {
            entity.f_19853_.m_7731_(spawnCobwebAt, Blocks.f_50033_.m_49966_(), 3);
            ScheduledTasks.schedule((ScheduledTickTask)new TemporaryCobwebTask(destroyWebAfter, entity.f_19853_, spawnCobwebAt));
            for (int i = 0; i < 32; ++i) {
                entity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50033_.m_49966_()), (double)spawnCobwebAt.m_123341_() + entity.m_217043_().m_188500_(), (double)spawnCobwebAt.m_123342_() + entity.m_217043_().m_188500_(), (double)spawnCobwebAt.m_123343_() + entity.m_217043_().m_188500_(), 0.0, 0.0, 0.0);
            }
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12388_, SoundSource.HOSTILE, 1.0f, 0.5f);
        }
    }
}

