/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.ai;

import insane96mcp.enhancedai.modules.zombie.feature.DiggerZombie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class DiggingGoal
extends Goal {
    private final Zombie digger;
    private LivingEntity target;
    private final double reachDistance;
    private final double maxDistanceFromTarget;
    private final List<BlockPos> targetBlocks = new ArrayList<BlockPos>();
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private BlockState blockState = null;
    private int prevBreakProgress = 0;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private Vec3 lastPosition = null;
    private int lastPositionTickstamp = 0;

    public DiggingGoal(Zombie digger, double maxDistanceFromTarget, boolean toolOnly, boolean properToolOnly) {
        this.digger = digger;
        this.reachDistance = 4.0;
        this.maxDistanceFromTarget = maxDistanceFromTarget == 0.0 ? 4096.0 : maxDistanceFromTarget * maxDistanceFromTarget;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.toolOnly && !(this.digger.m_21206_().m_41720_() instanceof DiggerItem)) {
            return false;
        }
        if (this.digger.m_5448_() == null) {
            return false;
        }
        return this.isStuck() && this.digger.m_20280_((Entity)this.digger.m_5448_()) > 2.0 && this.digger.m_20280_((Entity)this.digger.m_5448_()) < this.maxDistanceFromTarget;
    }

    public boolean m_8045_() {
        if (this.properToolOnly && this.blockState != null && !this.canHarvestBlock()) {
            return false;
        }
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        Path path = this.digger.m_21573_().m_6570_((Entity)this.target, 1);
        return !this.targetBlocks.isEmpty() && this.targetBlocks.get(0).m_123331_((Vec3i)this.digger.m_20183_()) < this.reachDistance * this.reachDistance && this.digger.m_21573_().m_26571_() && !this.digger.f_19853_.m_8055_(this.targetBlocks.get(0)).m_60795_() && path != null && (double)path.m_77407_() > 1.5;
    }

    public void m_8056_() {
        this.target = this.digger.m_5448_();
        if (this.target == null) {
            return;
        }
        this.fillTargetBlocks();
        if (!this.targetBlocks.isEmpty()) {
            this.initBlockBreak();
        }
    }

    public void m_8041_() {
        this.target = null;
        if (!this.targetBlocks.isEmpty()) {
            this.digger.f_19853_.m_6801_(this.digger.m_19879_(), this.targetBlocks.get(0), -1);
            this.targetBlocks.clear();
        }
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.blockState = null;
        this.prevBreakProgress = 0;
        this.lastPosition = null;
    }

    public void m_8037_() {
        if (this.targetBlocks.isEmpty()) {
            return;
        }
        if (this.properToolOnly && this.blockState != null && !this.canHarvestBlock()) {
            return;
        }
        ++this.breakingTick;
        this.digger.m_21563_().m_24946_((double)this.targetBlocks.get(0).m_123341_() + 0.5, (double)this.targetBlocks.get(0).m_123342_() + 0.5, (double)this.targetBlocks.get(0).m_123343_() + 0.5);
        if (this.prevBreakProgress != (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f)) {
            this.digger.f_19853_.m_6801_(this.digger.m_19879_(), this.targetBlocks.get(0), this.prevBreakProgress);
            this.prevBreakProgress = (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f);
        }
        if (this.breakingTick % 6 == 0) {
            this.digger.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.breakingTick % 4 == 0) {
            SoundType soundType = this.blockState.getSoundType((LevelReader)this.digger.f_19853_, this.targetBlocks.get(0), (Entity)this.digger);
            this.digger.f_19853_.m_5594_(null, this.targetBlocks.get(0), soundType.m_56778_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
        if (this.breakingTick >= this.tickToBreak) {
            this.digger.f_19853_.m_46953_(this.targetBlocks.get(0), true, (Entity)this.digger);
            this.digger.f_19853_.m_6801_(this.digger.m_19879_(), this.targetBlocks.get(0), -1);
            this.targetBlocks.remove(0);
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            } else if (this.digger.m_20280_((Entity)this.target) > 2.0 && !this.digger.m_21574_().m_148306_((Entity)this.target)) {
                this.m_8056_();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.digger.f_19853_.m_8055_(this.targetBlocks.get(0));
        this.tickToBreak = this.computeTickToBreak();
        this.breakingTick = 0;
    }

    private void fillTargetBlocks() {
        int mobHeight = Mth.m_14167_((float)this.digger.m_20206_());
        for (int i = 0; i < mobHeight; ++i) {
            BlockState state;
            double distance;
            BlockHitResult rayTraceResult = this.digger.f_19853_.m_45547_(new ClipContext(this.digger.m_20182_().m_82520_(0.0, (double)i + 0.5, 0.0), this.target.m_20299_(1.0f).m_82520_(0.0, (double)i, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.digger));
            if (rayTraceResult.m_6662_() == HitResult.Type.MISS || this.targetBlocks.contains(rayTraceResult.m_82425_()) || rayTraceResult.m_82425_().m_123342_() > DiggerZombie.maxYDig || (distance = this.digger.m_20238_(rayTraceResult.m_82450_())) > this.reachDistance * this.reachDistance || (state = this.digger.f_19853_.m_8055_(rayTraceResult.m_82425_())).m_155947_() || state.m_60800_((BlockGetter)this.digger.f_19853_, rayTraceResult.m_82425_()) == -1.0f || DiggerZombie.blockBlacklist.isBlockBlackOrNotWhiteListed(state.m_60734_())) continue;
            this.targetBlocks.add(rayTraceResult.m_82425_());
        }
        Collections.reverse(this.targetBlocks);
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean isStuck() {
        if (this.digger.m_5448_() == null) {
            return false;
        }
        if (this.lastPosition == null || this.digger.m_20238_(this.lastPosition) > 2.25) {
            this.lastPosition = this.digger.m_20182_();
            this.lastPositionTickstamp = this.digger.f_19797_;
        }
        return this.digger.m_21573_().m_26571_() || this.digger.f_19797_ - this.lastPositionTickstamp >= 60;
    }

    private int computeTickToBreak() {
        int canHarvestBlock = this.canHarvestBlock() ? 30 : 100;
        double diggingSpeed = this.getDigSpeed() / this.blockState.m_60800_((BlockGetter)this.digger.f_19853_, this.targetBlocks.get(0)) / (float)canHarvestBlock;
        return Mth.m_14165_((double)(1.0 / diggingSpeed * DiggerZombie.miningSpeedMultiplier));
    }

    private float getDigSpeed() {
        float digSpeed = this.digger.m_21206_().m_41691_(this.blockState);
        if (digSpeed > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.m_44926_((LivingEntity)this.digger);
            ItemStack itemstack = this.digger.m_21206_();
            if (efficiencyLevel > 0 && !itemstack.m_41619_()) {
                digSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)this.digger)) {
            digSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)this.digger) + 1) * 0.2f;
        }
        if (this.digger.m_21023_(MobEffects.f_19599_)) {
            float miningFatigueAmplifier = switch (this.digger.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            digSpeed *= miningFatigueAmplifier;
        }
        if (this.digger.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)this.digger)) {
            digSpeed /= 5.0f;
        }
        return digSpeed;
    }

    private boolean canHarvestBlock() {
        if (!this.blockState.m_60834_()) {
            return true;
        }
        ItemStack stack = this.digger.m_21206_();
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41735_(this.blockState);
    }
}

