/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.feature;

import insane96mcp.enhancedai.modules.zombie.ai.DiggingGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Digger Zombie", description="Zombies can mine blocks to reach the target. Uses offhand item to mine")
@LoadFeature(module="enhancedai:zombie")
public class DiggerZombie
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Digger Chance", description="Chance for a Zombie to spawn with the digger ability")
    public static Double diggerChance = 0.07;
    @Config
    @Label(name="Digger Tool Only", description="Zombies with Digger AI will mine only if they have any tool in the off-hand")
    public static Boolean diggerToolOnly = false;
    @Config
    @Label(name="Digger Proper Tool Only", description="Zombies with Digger AI will mine only if their off-hand tool can mine targeted blocks (e.g. zombies with shovels will not mine stone). Blocks that require no tool (e.g. planks) will be minable regardless of proper tool or not.")
    public static Boolean diggerProperToolOnly = false;
    @Config
    @Label(name="Equip Wooden Pick", description="Zombies with Digger AI will spawn with a Wooden Pickaxe.")
    public static Boolean equipWoodenPick = true;
    @Config(min=-64.0, max=320.0)
    @Label(name="Max Y Dig", description="The maximum Y coordinate at which Zombies can mine.")
    public static Integer maxYDig = 64;
    @Config(min=0.0, max=128.0)
    @Label(name="Max Distance", description="The maximum distance from the target at which the zombie can mine. Set to 0 to always mine.")
    public static Integer maxDistance = 0;
    @Config
    @Label(name="Blacklist Tile Entities", description="Zombies with Digger AI will not be able to break tile entities")
    public static Boolean blacklistTileEntities = false;
    @Config(min=0.0, max=128.0)
    @Label(name="Digger Speed Multiplier", description="Multiplier for digger zombies mining speed. E.g. with this set to 2, zombies will take twice the time to mine a block.")
    public static Double miningSpeedMultiplier = 1.0;
    @Config
    @Label(name="Block Blacklist", description="Blocks in here will not be minable by zombies (or will be the only minable in case it's whitelist)")
    public static Blacklist blockBlacklist = new Blacklist(Collections.emptyList(), false);
    @Config
    @Label(name="Entity Blacklist", description="Entities in this list will not be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public DiggerZombie(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Zombie zombie;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Zombie) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(zombie = (Zombie)entity))) {
            return;
        }
        CompoundTag persistentData = zombie.getPersistentData();
        boolean miner = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:miner", zombie.m_217043_().m_188500_() < diggerChance);
        boolean diggerToolOnly1 = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:tool_only", diggerToolOnly);
        boolean diggerProperToolOnly1 = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:proper_tool_only", diggerProperToolOnly);
        if (miner) {
            zombie.f_21345_.m_25352_(1, (Goal)new DiggingGoal(zombie, maxDistance.intValue(), diggerToolOnly1, diggerProperToolOnly1));
            if (equipWoodenPick.booleanValue()) {
                zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42422_));
                zombie.m_21409_(EquipmentSlot.OFFHAND, -1.0f);
            }
        }
    }
}

