/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base.config;

import insane96mcp.insanelib.base.ConfigOption;
import insane96mcp.insanelib.util.ConfigUtils;
import insane96mcp.insanelib.util.IdTagMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;

public class Blacklist {
    public List<IdTagMatcher> blacklist;
    public boolean blacklistAsWhitelist;

    public Blacklist(List<IdTagMatcher> blacklist, boolean blacklistAsWhitelist) {
        this.blacklist = blacklist;
        this.blacklistAsWhitelist = blacklistAsWhitelist;
    }

    public Blacklist(List<IdTagMatcher> blacklist) {
        this(blacklist, false);
    }

    public Blacklist() {
        this(Collections.emptyList(), false);
    }

    public List<String> getStringList() {
        ArrayList<String> list = new ArrayList<String>();
        for (IdTagMatcher idTagMatcher : this.blacklist) {
            list.add(idTagMatcher.asString());
        }
        return list;
    }

    public boolean isBlockBlackOrNotWhiteListed(Block entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesBlock(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isItemBlackOrNotWhiteListed(Item entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesItem(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isFluidBlackOrNotWhiteListed(Fluid entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesFluid(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isEntityBlackOrNotWhitelist(Entity entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesEntity(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public boolean isEntityBlackOrNotWhitelist(EntityType<?> entry) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : this.blacklist) {
            if (!blacklistEntry.matchesEntity(entry)) continue;
            if (!this.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && this.blacklistAsWhitelist;
    }

    public List<? extends String> getListAsString() {
        ArrayList<String> list = new ArrayList<String>();
        for (IdTagMatcher idTagMatcher : this.blacklist) {
            list.add(idTagMatcher.asString());
        }
        return list;
    }

    public static class Config
    extends ConfigOption<Blacklist> {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> listConfig;
        public ForgeConfigSpec.ConfigValue<Boolean> listAsWhitelistConfig;

        public Config(ForgeConfigSpec.Builder builder, String name, String description, Blacklist defaultValue) {
            super(builder, name, description);
            List<String> split = ConfigUtils.split(name);
            builder.push(split);
            this.listConfig = builder.defineList("Blacklist", defaultValue.getStringList(), o -> o instanceof String);
            this.listAsWhitelistConfig = builder.comment("If true the list will be treated as a whitelist instead of blacklist").define("List as Whitelist", defaultValue.blacklistAsWhitelist);
            builder.pop(split.size());
        }

        @Override
        public Blacklist get() {
            return new Blacklist(IdTagMatcher.parseStringList((List)this.listConfig.get()), (Boolean)this.listAsWhitelistConfig.get());
        }

        @Override
        public void set(Object value) {
            Blacklist blacklist = (Blacklist)value;
            this.listConfig.set(blacklist.getListAsString());
            this.listAsWhitelistConfig.set((Object)blacklist.blacklistAsWhitelist);
        }
    }
}

