/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base.config;

import insane96mcp.insanelib.base.ConfigOption;
import insane96mcp.insanelib.util.ConfigUtils;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.ForgeConfigSpec;

public class MinMax {
    public double min;
    public double max;

    public MinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public MinMax(double value) {
        this.min = value;
        this.max = value;
    }

    public double getRandBetween(RandomSource random) {
        return Mth.m_216263_((RandomSource)random, (double)this.min, (double)(this.max - 1.0));
    }

    public int getIntRandBetween(RandomSource random) {
        return Mth.m_216271_((RandomSource)random, (int)((int)this.min), (int)((int)this.max - 1));
    }

    public static class Config
    extends ConfigOption<MinMax> {
        private final ForgeConfigSpec.DoubleValue minConfig;
        private final ForgeConfigSpec.DoubleValue maxConfig;

        public Config(ForgeConfigSpec.Builder builder, String name, String description, MinMax defaultValue, double rangeMin, double rangeMax) {
            super(builder, name, description);
            List<String> split = ConfigUtils.split(name);
            builder.push(split);
            this.minConfig = builder.defineInRange("Minimum", defaultValue.min, rangeMin, rangeMax);
            this.maxConfig = builder.defineInRange("Maximum", defaultValue.max, rangeMin, rangeMax);
            builder.pop(split.size());
        }

        @Override
        public MinMax get() {
            return new MinMax((Double)this.minConfig.get(), (Double)this.maxConfig.get());
        }

        @Override
        public void set(Object value) {
            MinMax minMax = (MinMax)value;
            this.minConfig.set((Object)minMax.min);
            this.maxConfig.set((Object)minMax.max);
        }
    }
}

