/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal;

import insane96mcp.enhancedai.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Animals Scared Attack", description="Make animals fight back or be scared by players. Use the entity type tag enhancedai:can_fight_back and enhancedai:can_be_scared_by_players to add/remove animals.")
@LoadFeature(module="enhancedai:animal")
public class AnimalScaredAttack
extends Feature {
    public static final TagKey<EntityType<?>> CAN_FIGHT_BACK = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_fight_back"));
    public static final TagKey<EntityType<?>> CAN_BE_SCARED_BY_PLAYERS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_be_scared_by_players"));
    public static final String CAN_ATTACK_BACK = "enhancedai:can_attack_back";
    public static final String PLAYER_SCARED = "enhancedai:player_scared";
    @Config(min=0.0, max=1.0)
    @Label(name="Fight back chance", description="Animals have this percentage chance to be able to fight back instead of fleeing. Animals have a slightly bigger range to attack. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to change the damage. Base damage is 3")
    public static Double fightBackChance = 0.3;
    @Config(min=0.0, max=1.0)
    @Label(name="Players Scared chance", description="Animals have this percentage chance to be scared by players and run away. Fight back chance has priority over this")
    public static Double playersScaredChance = 0.4;
    @Config(min=0.0, max=4.0)
    @Label(name="Movement Speed Multiplier", description="Movement speed multiplier when aggroed.")
    public static Double speedMultiplier = 1.1;
    @Config(min=0.0, max=128.0)
    @Label(name="Knockback", description="Animals' knockback attribute will be set to this value.")
    public static Double knockback = 1.5;
    @Config
    @Label(name="Knockback size based", description="Animals' knockback attribute will be increased/decreased based on the side of the mob.")
    public static Boolean knockbackSizeBased = true;
    private static final double BASE_ATTACK_DAMAGE = 3.0;

    public AnimalScaredAttack(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, Attributes.f_22281_)) continue;
            event.add(entityType, Attributes.f_22281_, 3.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        CompoundTag persistentData = animal.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", speedMultiplier);
        boolean canAttackBack = NBTUtils.getBooleanOrPutDefault(persistentData, CAN_ATTACK_BACK, animal.m_6095_().m_204039_(CAN_FIGHT_BACK) && animal.m_217043_().m_188500_() < fightBackChance);
        boolean playerScared = NBTUtils.getBooleanOrPutDefault(persistentData, PLAYER_SCARED, !canAttackBack && animal.m_6095_().m_204039_(CAN_BE_SCARED_BY_PLAYERS) && animal.m_217043_().m_188500_() < playersScaredChance);
        if (canAttackBack && !animal.m_6162_()) {
            animal.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)animal, new Class[0]).m_26044_(new Class[0]));
            animal.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)animal, movementSpeedMultiplier, true));
            animal.f_21345_.f_25345_.removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof PanicGoal);
            if (knockback > 0.0) {
                AttributeInstance kbAttribute;
                double baseSize = 1.053;
                double actualKnockback = knockback;
                if (knockbackSizeBased.booleanValue()) {
                    actualKnockback = (double)(animal.m_20205_() * animal.m_20205_() * animal.m_20206_()) * knockback / baseSize;
                }
                if ((kbAttribute = animal.m_21051_(Attributes.f_22282_)) != null) {
                    kbAttribute.m_22125_(new AttributeModifier("Animal knockback", actualKnockback, AttributeModifier.Operation.ADDITION));
                }
            }
        } else if (playerScared) {
            EAAvoidEntityGoal<Player> avoidEntityGoal = new EAAvoidEntityGoal<Player>((PathfinderMob)animal, Player.class, 16.0f, 8.0f, 1.25, 1.1);
            animal.f_21345_.m_25352_(1, avoidEntityGoal);
        }
    }
}

