/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.illager.shoot;

import insane96mcp.enhancedai.modules.illager.shoot.EAPillagerAttackGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.base.config.MinMax;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Pillager Shoot", description="Use the enhancedai:better_pillager_shoot entity type tag to add more skeletons that are affected by this feature")
@LoadFeature(module="enhancedai:illager")
public class PillagerShoot
extends Feature {
    public static final TagKey<EntityType<?>> BETTER_PILLAGER_SHOOT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "better_pillager_shoot"));
    public static final String SHOOTING_RANGE = "enhancedai:shooting_range";
    public static final String SHOOTING_COOLDOWN = "enhancedai:shooting_cooldown";
    public static final String INACCURACY = "enhancedai:inaccuracy";
    @Config(min=1.0, max=64.0)
    @Label(name="Shooting Range", description="The range from where a pillager will shoot a player")
    public static MinMax shootingRange = new MinMax(24.0, 32.0);
    @Config(min=0.0)
    @Label(name="Shooting Cooldown", description="The ticks cooldown before shooting. Vanilla is random between 20 and 40")
    public static MinMax shootingCooldown = new MinMax(20.0, 40.0);
    @Config(min=0.0, max=30.0)
    @Label(name="Arrow Inaccuracy", description="How much inaccuracy does the arrow fired by pillagers have. Vanilla pillagers have 10/6/2 inaccuracy in easy/normal/hard difficulty.")
    public static Difficulty arrowInaccuracy = new Difficulty(5.0, 3.0, 1.0);

    public PillagerShoot(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Pillager pillager;
        block3: {
            block2: {
                Entity entity;
                if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Pillager)) break block2;
                pillager = (Pillager)entity;
                if (event.getEntity().m_6095_().m_204039_(BETTER_PILLAGER_SHOOT)) break block3;
            }
            return;
        }
        CompoundTag persistentData = pillager.getPersistentData();
        int shootingRange1 = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_RANGE, shootingRange.getIntRandBetween(pillager.m_217043_()));
        double inaccuracy = NBTUtils.getDoubleOrPutDefault(persistentData, INACCURACY, arrowInaccuracy.getByDifficulty(pillager.m_9236_()));
        int shootingCooldown1 = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_COOLDOWN, shootingCooldown.getIntRandBetween(pillager.m_217043_()));
        pillager.f_21345_.m_262460_(goal -> goal instanceof RangedCrossbowAttackGoal);
        EAPillagerAttackGoal attackGoal = new EAPillagerAttackGoal(pillager, 1.0, shootingRange1, shootingCooldown1, (float)inaccuracy);
        pillager.f_21345_.m_25352_(3, (Goal)attackGoal);
    }
}

