/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Item Disruption", description="Endermen will make the player's item fall from his hands. Add/remove mobs via the enhancedai:can_disrupt_item entity type tag")
@LoadFeature(module="enhancedai:mobs")
public class ItemDisruption
extends Feature {
    public static final TagKey<EntityType<?>> CAN_DISRUPT_ITEM = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_disrupt_item"));
    public static final String ITEM_DISRUPTION_CHANCE = "enhancedai:item_disruption_chance";
    @Config(min=0.0, max=1.0)
    @Label(name="Chance", description="Chance can be changed within entity data's ForgeData.\"enhancedai:item_disruption_chance\"")
    public static Difficulty chance = new Difficulty(0.25, 0.25, 0.35);

    public ItemDisruption(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onHit(LivingDamageEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity;
        block10: {
            block9: {
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) break block9;
                player = (ServerPlayer)livingEntity;
                livingEntity = event.getSource().m_7640_();
                if (livingEntity instanceof Mob) break block10;
            }
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_217043_().m_188501_() < mob.getPersistentData().m_128457_(ITEM_DISRUPTION_CHANCE)) {
            ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandItem = player.m_21120_(InteractionHand.OFF_HAND);
            if (mainHandItem.m_41619_() && offHandItem.m_41619_()) {
                return;
            }
            ItemStack stack = !mainHandItem.m_41619_() ? (!offHandItem.m_41619_() ? (mob.m_217043_().m_188499_() ? mainHandItem.m_41777_() : offHandItem.m_41777_()) : mainHandItem.m_41777_()) : offHandItem.m_41777_();
            event.setCanceled(true);
            player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 0.5f);
            Inventory inventory = player.m_150109_();
            int slot = inventory.m_36030_(stack);
            if (slot == -1) {
                slot = 40;
            }
            inventory.m_7407_(slot, stack.m_41613_());
            if (player.m_21211_() == stack && stack.m_41613_() == 1) {
                player.m_5810_();
            }
            player.f_36096_.m_182417_((Container)inventory, slot).ifPresent(i -> {
                player.f_36096_.m_150404_(i, inventory.m_8020_(i));
                player.f_36096_.m_150429_();
            });
            ItemEntity itementity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), stack);
            double x = player.m_20185_() - mob.m_20185_();
            double z = player.m_20189_() - mob.m_20189_();
            Vec2 dir = new Vec2((float)x, (float)z).m_165902_();
            if (mob.m_217043_().m_188499_()) {
                itementity.m_20256_(itementity.m_20184_().m_82520_((double)(-dir.f_82471_ * 0.4f), 0.0, (double)(dir.f_82470_ * 0.4f)));
            } else {
                itementity.m_20256_(itementity.m_20184_().m_82520_((double)(dir.f_82471_ * 0.4f), 0.0, (double)(-dir.f_82470_ * 0.4f)));
            }
            itementity.m_32010_(40);
            player.m_20193_().m_7967_((Entity)itementity);
        }
    }

    @SubscribeEvent
    public void onJoinLevelEvent(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_DISRUPT_ITEM) || mob.getPersistentData().m_128441_(ITEM_DISRUPTION_CHANCE)) {
            return;
        }
        mob.getPersistentData().m_128350_(ITEM_DISRUPTION_CHANCE, (float)chance.getByDifficulty(mob.m_9236_()));
    }
}

