/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Open Doors", description="Use enhancedai:can_open_doors to add more mobs that can open doors.")
@LoadFeature(module="enhancedai:mobs")
public class OpenDoors
extends Feature {
    public static final TagKey<EntityType<?>> CAN_OPEN_DOORS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_open_doors"));

    public OpenDoors(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob) || !OpenDoors.shouldBeAbleToOpenDoors(mob = (Mob)entity) || event.getLevel().f_46443_) {
            return;
        }
        PathNavigation pathNavigation = mob.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundPathNavigation = (GroundPathNavigation)pathNavigation;
            groundPathNavigation.m_26477_(true);
            groundPathNavigation.m_148214_(true);
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            for (WrappedGoal wrappedGoal : mob.f_21345_.m_148105_()) {
                if (!(wrappedGoal.m_26015_() instanceof OpenDoorGoal)) continue;
                toRemove.add(wrappedGoal.m_26015_());
            }
            toRemove.forEach(arg_0 -> ((GoalSelector)mob.f_21345_).m_25363_(arg_0));
            mob.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal(mob, false));
        }
    }

    public static boolean shouldBeAbleToOpenDoors(Mob mob) {
        return Feature.isEnabled(OpenDoors.class) && mob.m_6095_().m_204039_(CAN_OPEN_DOORS);
    }
}

