/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.miner;

import insane96mcp.enhancedai.modules.mobs.miner.MinerMobs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class BlockBreakerGoal
extends Goal {
    private final Mob miner;
    private LivingEntity target;
    private final double reachDistance;
    private final double maxDistanceFromTarget;
    private final double timeToBreakMultiplier;
    private final List<BlockPos> targetBlocks = new ArrayList<BlockPos>();
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private BlockState blockState = null;
    private int prevBreakProgress = 0;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private final boolean properToolRequired;
    private Vec3 lastPosition = null;
    private int lastPositionTickstamp = 0;
    private Path path = null;

    public BlockBreakerGoal(Mob miner, double maxDistanceFromTarget, double timeToBreakMultiplier, boolean toolOnly, boolean properToolOnly, boolean properToolRequired) {
        this.miner = miner;
        this.reachDistance = 4.0;
        this.maxDistanceFromTarget = maxDistanceFromTarget == 0.0 ? 4096.0 : maxDistanceFromTarget * maxDistanceFromTarget;
        this.timeToBreakMultiplier = timeToBreakMultiplier;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.properToolRequired = properToolRequired;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.toolOnly && !(this.miner.m_21206_().m_41720_() instanceof DiggerItem)) {
            return false;
        }
        if (this.miner.m_5448_() == null) {
            return false;
        }
        return this.isStuck() && (this.miner.m_20280_((Entity)this.miner.m_5448_()) > 2.0 || !this.miner.m_142582_((Entity)this.miner.m_5448_())) && this.miner.m_20280_((Entity)this.miner.m_5448_()) < this.maxDistanceFromTarget;
    }

    public boolean m_8045_() {
        if (this.targetBlocks.isEmpty()) {
            return false;
        }
        if (this.properToolOnly && this.blockState != null && !this.canBreakBlock()) {
            return false;
        }
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        return this.targetBlocks.get(0).m_123331_((Vec3i)this.miner.m_20183_()) < this.reachDistance * this.reachDistance && this.miner.m_21573_().m_26571_() && !this.miner.m_9236_().m_8055_(this.targetBlocks.get(0)).m_60795_() && this.path != null && ((double)this.path.m_77407_() > 1.5 || !this.miner.m_142582_((Entity)this.target));
    }

    public void m_8056_() {
        this.target = this.miner.m_5448_();
        if (this.target == null) {
            return;
        }
        this.fillTargetBlocks();
        if (!this.targetBlocks.isEmpty()) {
            this.initBlockBreak();
            this.miner.m_21561_(true);
        }
    }

    public void m_8041_() {
        this.target = null;
        if (!this.targetBlocks.isEmpty()) {
            this.miner.m_9236_().m_6801_(this.miner.m_19879_(), this.targetBlocks.get(0), -1);
            this.targetBlocks.clear();
        }
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.blockState = null;
        this.prevBreakProgress = 0;
        this.lastPosition = null;
        this.path = null;
        this.miner.m_21561_(false);
    }

    public void m_8037_() {
        Level level;
        if (this.targetBlocks.isEmpty()) {
            return;
        }
        if (this.properToolOnly && this.blockState != null && !this.canBreakBlock()) {
            return;
        }
        BlockPos pos = this.targetBlocks.get(0);
        ++this.breakingTick;
        this.miner.m_21563_().m_24946_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (this.prevBreakProgress != (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f)) {
            this.prevBreakProgress = (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f);
            this.miner.m_9236_().m_6801_(this.miner.m_19879_(), pos, this.prevBreakProgress);
        }
        if (this.breakingTick % 6 == 0) {
            this.miner.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.breakingTick % 4 == 0) {
            SoundType soundType = this.blockState.getSoundType((LevelReader)this.miner.m_9236_(), pos, (Entity)this.miner);
            this.miner.m_9236_().m_5594_(null, pos, soundType.m_56778_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 8.0f, soundType.m_56774_() * 0.5f);
        }
        if (this.breakingTick >= this.tickToBreak && (level = this.miner.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockEntity blockentity = this.blockState.m_155947_() ? this.miner.m_9236_().m_7702_(pos) : null;
            LootParams.Builder lootparams$builder = new LootParams.Builder(level2).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)this.miner.m_21206_()).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.miner);
            this.blockState.m_222967_(level2, pos, this.miner.m_21206_(), true);
            this.blockState.m_287290_(lootparams$builder).forEach(itemStack -> level2.m_7967_((Entity)new ItemEntity((Level)level2, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), itemStack)));
            this.miner.m_9236_().m_46953_(pos, false, (Entity)this.miner);
            this.miner.m_9236_().m_6801_(this.miner.m_19879_(), pos, -1);
            this.targetBlocks.remove(0);
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            } else if (this.miner.m_20280_((Entity)this.target) > 2.0 && !this.miner.m_21574_().m_148306_((Entity)this.target)) {
                this.m_8056_();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.miner.m_9236_().m_8055_(this.targetBlocks.get(0));
        this.tickToBreak = this.computeTickToBreak();
        this.breakingTick = 0;
        this.path = this.miner.m_21573_().m_6570_((Entity)this.target, 1);
    }

    private void fillTargetBlocks() {
        int mobHeight = Mth.m_14167_((float)this.miner.m_20206_());
        for (int i = 0; i < mobHeight; ++i) {
            BlockState state;
            double distance;
            BlockHitResult rayTraceResult = this.miner.m_9236_().m_45547_(new ClipContext(this.miner.m_20182_().m_82520_(0.0, (double)i + 0.5, 0.0), this.target.m_20299_(1.0f).m_82520_(0.0, (double)i, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.miner));
            if (rayTraceResult.m_6662_() == HitResult.Type.MISS || this.targetBlocks.contains(rayTraceResult.m_82425_()) || rayTraceResult.m_82425_().m_123342_() > MinerMobs.maxY || (distance = this.miner.m_20238_(rayTraceResult.m_82450_())) > this.reachDistance * this.reachDistance || (state = this.miner.m_9236_().m_8055_(rayTraceResult.m_82425_())).m_155947_() || state.m_60800_((BlockGetter)this.miner.m_9236_(), rayTraceResult.m_82425_()) == -1.0f || state.m_204336_(MinerMobs.BLOCK_BLACKLIST) || state.m_155947_() && MinerMobs.blacklistTileEntities.booleanValue()) continue;
            this.targetBlocks.add(rayTraceResult.m_82425_());
        }
        Collections.reverse(this.targetBlocks);
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean isStuck() {
        if (this.miner.m_5448_() == null) {
            return false;
        }
        if (this.lastPosition == null || this.miner.m_20238_(this.lastPosition) > 2.25) {
            this.lastPosition = this.miner.m_20182_();
            this.lastPositionTickstamp = this.miner.f_19797_;
        }
        return this.miner.m_21573_().m_26571_() || this.miner.f_19797_ - this.lastPositionTickstamp >= 60;
    }

    private int computeTickToBreak() {
        int canHarvestBlock = this.canHarvestBlock() ? 30 : 100;
        double diggingSpeed = this.getDigSpeed() / this.blockState.m_60800_((BlockGetter)this.miner.m_9236_(), this.targetBlocks.get(0)) / (float)canHarvestBlock;
        return Mth.m_14165_((double)(1.0 / diggingSpeed * this.timeToBreakMultiplier));
    }

    private float getDigSpeed() {
        float digSpeed = this.miner.m_21206_().m_41691_(this.blockState);
        if (digSpeed > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.m_44926_((LivingEntity)this.miner);
            ItemStack itemstack = this.miner.m_21206_();
            if (efficiencyLevel > 0 && !itemstack.m_41619_()) {
                digSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)this.miner)) {
            digSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)this.miner) + 1) * 0.2f;
        }
        if (this.miner.m_21023_(MobEffects.f_19599_)) {
            float miningFatigueAmplifier = switch (this.miner.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            digSpeed *= miningFatigueAmplifier;
        }
        if (this.miner.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)this.miner)) {
            digSpeed /= 5.0f;
        }
        return digSpeed;
    }

    private boolean canBreakBlock() {
        if (!ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this.miner, (BlockPos)this.targetBlocks.get(0), (BlockState)this.blockState)) {
            return false;
        }
        if (!this.blockState.m_60834_() || !this.properToolRequired) {
            return true;
        }
        ItemStack stack = this.miner.m_21206_();
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41735_(this.blockState);
    }

    private boolean canHarvestBlock() {
        if (!this.blockState.m_60834_()) {
            return true;
        }
        ItemStack stack = this.miner.m_21206_();
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41735_(this.blockState);
    }
}

