/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.miner;

import insane96mcp.enhancedai.modules.mobs.miner.BlockBreakerGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.data.IdTagMatcher;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Miner Mobs", description="Mobs can mine blocks to reach the target. Uses offhand item to mine. Only mobs in the entity type tag enhancedai:can_be_miner can spawn with the ability to mine and blocks in the tag enhancedai:miner_block_blacklist cannot be mined.")
@LoadFeature(module="enhancedai:mobs")
public class MinerMobs
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_MINER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_be_miner"));
    public static final TagKey<Block> BLOCK_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("enhancedai", "miner_block_blacklist"));
    public static final String MINER = "enhancedai:miner";
    public static final String TIME_TO_BREAK_MULTIPLIER = "enhancedai:time_to_break_multiplier";
    public static final String TOOL_ONLY = "enhancedai:tool_only";
    public static final String PROPER_TOOL_ONLY = "enhancedai:proper_tool_only";
    public static final String ALWAYS_REQUIRE_PROPER_TOOL = "enhancedai:always_require_proper_tool";
    @Config(min=0.0, max=1.0)
    @Label(name="Miner Chance", description="Chance for a mob in the entity type tag enhancedai:can_be_miner to spawn with the miner ability")
    public static Double minerChance = 0.07;
    @Config
    @Label(name="Can mine with tool only", description="Mobs with the miner AI will mine only if they have any tool in the off-hand")
    public static Boolean canMineWithToolOnly = true;
    @Config
    @Label(name="Can mine with proper tool only", description="Mobs with the miner AI will mine only if their off-hand tool can mine targeted blocks (e.g. zombies with shovels will not mine stone). Blocks that require no tool (e.g. planks) will be minable regardless of proper tool or not.")
    public static Boolean canMineWithProperToolOnly = false;
    @Config
    @Label(name="Always require proper tool", description="If 'Can mine with proper tool only' is enabled, mobs with the miner AI will mine blocks that don't require a tool only with the proper tool.")
    public static Boolean alwaysRequireProperTool = false;
    @Config
    @Label(name="Equip Stone Pick", description="Mobs with Miner AI will spawn with a Stone Pickaxe that never drops.")
    public static Boolean equipStonePick = true;
    @Config(min=-512.0, max=1024.0)
    @Label(name="Max Y", description="Mobs can mine from the bottom of the world to this Y level.")
    public static Integer maxY = 320;
    @Config(min=0.0, max=128.0)
    @Label(name="Max Distance", description="The maximum distance from the target at which the Mobs can mine. Set to 0 to always mine.")
    public static Integer maxDistance = 0;
    @Config
    @Label(name="Blacklist Tile Entities", description="Mobs with Miner AI will not be able to break tile entities")
    public static Boolean blacklistTileEntities = false;
    @Config(min=0.0, max=128.0)
    @Label(name="Time to break multiplier", description="Multiplier for the time a mob takes to break blocks. E.g. with this set to 2, mobs will take twice the time to mine a block.")
    public static Double timeToBreakMultiplier = 1.0;
    @Config
    @Label(name="Dimension Blacklist", description="Dimensions where mobs can't spawn with the ability to mine.")
    public static Blacklist dimensionBlacklist = new Blacklist();

    public MinerMobs(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob) || !(mob = (Mob)entity).m_6095_().m_204039_(CAN_BE_MINER) || MinerMobs.isDimensionBlackOrNotWhitelisted(event.getLevel())) {
            return;
        }
        CompoundTag persistentData = mob.getPersistentData();
        boolean miner = NBTUtils.getBooleanOrPutDefault(persistentData, MINER, mob.m_217043_().m_188500_() < minerChance);
        double timeToBreakMultiplier1 = NBTUtils.getDoubleOrPutDefault(persistentData, TIME_TO_BREAK_MULTIPLIER, timeToBreakMultiplier);
        boolean toolOnly = NBTUtils.getBooleanOrPutDefault(persistentData, TOOL_ONLY, canMineWithToolOnly);
        boolean properToolOnly = NBTUtils.getBooleanOrPutDefault(persistentData, PROPER_TOOL_ONLY, canMineWithProperToolOnly);
        boolean properToolRequired = NBTUtils.getBooleanOrPutDefault(persistentData, ALWAYS_REQUIRE_PROPER_TOOL, alwaysRequireProperTool);
        if (miner) {
            mob.f_21345_.m_25352_(1, (Goal)new BlockBreakerGoal(mob, maxDistance.intValue(), timeToBreakMultiplier1, toolOnly, properToolOnly, properToolRequired));
            if (equipStonePick.booleanValue() && mob.m_21206_().m_41619_()) {
                mob.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42427_));
                mob.m_21409_(EquipmentSlot.OFFHAND, -1.0f);
            }
        }
    }

    public static boolean isDimensionBlackOrNotWhitelisted(Level level) {
        boolean isInWhitelist = false;
        boolean isInBlacklist = false;
        for (IdTagMatcher blacklistEntry : MinerMobs.dimensionBlacklist.blacklist) {
            if (!blacklistEntry.location.equals((Object)level.m_46472_().m_135782_())) continue;
            if (!MinerMobs.dimensionBlacklist.blacklistAsWhitelist) {
                isInBlacklist = true;
                break;
            }
            isInWhitelist = true;
            break;
        }
        return isInBlacklist || !isInWhitelist && MinerMobs.dimensionBlacklist.blacklistAsWhitelist;
    }
}

