/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch;

import insane96mcp.enhancedai.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Witch Flee Target", description="Witches flee from the target.")
@LoadFeature(module="enhancedai:witch")
public class WitchFleeTarget
extends Feature {
    public static final TagKey<EntityType<?>> WITCH_FLEE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "witch_flee"));
    @Config(min=0.0, max=1.0)
    @Label(name="Avoid Player chance", description="Chance for a Witch to spawn with the ability to avoid the player")
    public static Double avoidPlayerChance = 1.0;
    @Config(min=0.0, max=1.0)
    @Label(name="Attack When Avoiding Chance", description="Chance for a Witch to be able to throw potions while running from a player")
    public static Double attackWhenAvoidingChance = 0.5;
    @Config(min=0.0, max=32.0)
    @Label(name="Flee Distance Far", description="Distance from a player that will make the Witch run away.")
    public static Double fleeDistanceFar = 13.0;
    @Config(min=0.0, max=32.0)
    @Label(name="Flee Distance Near", description="Distance from a player that counts as near and will make the Witch run away faster.")
    public static Double fleeDistanceNear = 7.0;
    @Config(min=0.0, max=4.0)
    @Label(name="Flee speed Multiplier Far", description="Speed multiplier when the Witch avoids the player and it's farther than 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedFar = 1.0;
    @Config(min=0.0, max=4.0)
    @Label(name="Flee speed Multiplier Near", description="Speed multiplier when the Witch avoids the player and it's within 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedNear = 1.1;

    public WitchFleeTarget(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Witch witch;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Witch) || !(witch = (Witch)entity).m_6095_().m_204039_(WITCH_FLEE)) {
            return;
        }
        CompoundTag persistentData = witch.getPersistentData();
        boolean avoidTarget = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:avoid_target", witch.m_217043_().m_188500_() < avoidPlayerChance);
        boolean attackWhenAvoiding = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:attack_when_avoiding", witch.m_217043_().m_188500_() < attackWhenAvoidingChance);
        double fleeDistanceFar1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_far", fleeDistanceFar);
        double fleeDistanceNear1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_near", fleeDistanceNear);
        double fleeSpeedFar1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_far", fleeSpeedFar);
        double fleeSpeedNear1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_near", fleeSpeedNear);
        if (!avoidTarget) {
            return;
        }
        EAAvoidEntityGoal<Player> avoidEntityGoal = new EAAvoidEntityGoal<Player>((PathfinderMob)witch, Player.class, (float)fleeDistanceFar1, (float)fleeDistanceNear1, fleeSpeedNear1, fleeSpeedFar1);
        avoidEntityGoal.setAttackWhenRunning(attackWhenAvoiding);
        witch.f_21345_.m_25352_(1, avoidEntityGoal);
    }
}

