/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class Config {
    public static Boolean enableSelectionBox;
    public static float selectionBoxRed;
    public static float selectionBoxGreen;
    public static float selectionBoxBlue;
    public static float selectionBoxAlpha;
    public static float selectionBoxThickness;
    public static float sectionsRed;
    public static float sectionsGreen;
    public static float sectionsBlue;
    public static float sectionsAlpha;
    public static float sectionsBorderRed;
    public static float sectionsBorderGreen;
    public static float sectionsBorderBlue;
    public static float sectionsBorderAlpha;
    private static Boolean enableGuiSections;
    private static Boolean enableClientPlayerWorld;
    private static String clientPlayerWorldHudStyle;
    private static Boolean enableClientPerformance;
    private static Boolean enableClientFps;
    private static Boolean enableClientMemory;
    private static Boolean enableClientLatency;
    private static Boolean enableNetworkPackets;
    private static Boolean enablePlayerPosition;
    private static Boolean enablePlayerCoords;
    private static Boolean enablePlayerFacing;
    private static Boolean enablePlayerRotation;
    private static Boolean enablePlayerSpeed;
    private static Boolean enableWorldInfo;
    private static Boolean enablePlayerBiome;
    private static Boolean enableDebugEntities;
    private static Boolean enablePlayerLight;
    private static Boolean enableWorldTime;
    private static String worldTimeStyle;
    private static Boolean enableWorldDays;
    private static Boolean enableWarningArea;
    private static Boolean enableTimeSinceLastRest;
    private static Boolean enableLowHealthWarning;
    private static Boolean enableCriticalHealthCursorWarning;
    private static Boolean enableHungerWarning;
    private static Boolean enableOxygenCounter;
    private static Boolean enableOxygenCounterAltHud;
    private static String oxygenCounterAltHudLocation;
    private static Boolean enableSaturationWarning;
    private static Boolean enableFreezeCounter;
    private static Boolean enableWarningCounters;
    private static Boolean enablePointedBlock;
    private static Boolean enablePointedBlockTags;
    private static Boolean enablePointedBlockBreakingProgress;
    private static Boolean enablePointedBlockProperties;
    private static Boolean enablePointedEntity;
    private static Boolean enablePointedEntityProperties;
    private static Boolean enablePlayerEquipment;
    private static Boolean enablePlayerGear;
    private static Boolean enablePlayerGearDarkMode;
    private static Boolean enablePlayerQuiver;
    private static Boolean enablePlayerFoodStats;
    private static Boolean enablePlayerOnScreenEquipment;
    private static String playerOnScreenEquipmentHudLocation;
    private static Boolean enablePlayerOnScreenEquipmentDurability;
    private static String playerOnScreenEquipmentDurabilityStyle;
    private static Boolean enablePlayerOnScreenEquipmentArms;
    private static Boolean enablePlayerOnScreenEquipmentTexture;
    private static Boolean enablePlayerShulkerBoxHud;
    private static Boolean enablePlayerBundleHud;
    private static Boolean enableBiomeTimeWeather;
    private static Boolean enableBiomeTimeWeatherSlimes;
    private static String biomeTimeWeatherHudLocation;
    private static Boolean enableAdvancedTooltips;
    private static Boolean enableItemDurability;
    private static Boolean enableItemPenaltyLevel;
    private static Boolean enableFoodStats;
    private static Boolean enableBeeNestInfo;
    private static Boolean enableLodestoneCompassInfo;
    private static Boolean enableBundleCapacity;
    private static Boolean enableAxolotlBucketInfo;
    private static Boolean enablePumpkinTexture;
    private static Boolean enableVignetteTexture;
    private static Boolean enableWitherDarkenSky;
    private static Boolean enableRainParticles;
    private static Boolean enableOtherParticles;
    private static Boolean enableStatusEffectsDuration;
    public static File configFile;

    public static void loadConfig() throws IOException {
        configFile.getParentFile().mkdirs();
        String content = configFile.exists() ? FileUtils.readFileToString((File)configFile, (String)"utf-8") : "{}";
        JsonElement jsonElement = new JsonParser().parse(content);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        enableSelectionBox = jsonObject.has("enableSelectionBox") ? jsonObject.get("enableSelectionBox").getAsBoolean() : true;
        selectionBoxRed = jsonObject.has("selectionBoxRed") ? (float)jsonObject.get("selectionBoxRed").getAsInt() / 255.0f : 1.0f;
        selectionBoxGreen = jsonObject.has("selectionBoxGreen") ? (float)jsonObject.get("selectionBoxGreen").getAsInt() / 255.0f : 1.0f;
        selectionBoxBlue = jsonObject.has("selectionBoxBlue") ? (float)jsonObject.get("selectionBoxBlue").getAsInt() / 255.0f : 1.0f;
        selectionBoxAlpha = jsonObject.has("selectionBoxAlpha") ? (float)jsonObject.get("selectionBoxAlpha").getAsInt() / 255.0f : 0.666666f;
        selectionBoxThickness = jsonObject.has("selectionBoxThickness") ? (float)jsonObject.get("selectionBoxThickness").getAsInt() : 2.0f;
        sectionsRed = jsonObject.has("sectionsRed") ? (float)jsonObject.get("sectionsRed").getAsInt() / 255.0f : 0.058823f;
        sectionsGreen = jsonObject.has("sectionsGreen") ? (float)jsonObject.get("sectionsGreen").getAsInt() / 255.0f : 0.058823f;
        sectionsBlue = jsonObject.has("sectionsBlue") ? (float)jsonObject.get("sectionsBlue").getAsInt() / 255.0f : 0.058823f;
        sectionsAlpha = jsonObject.has("sectionsAlpha") ? (float)jsonObject.get("sectionsAlpha").getAsInt() / 255.0f : 0.62745f;
        sectionsBorderRed = jsonObject.has("sectionsBorderRed") ? (float)jsonObject.get("sectionsBorderRed").getAsInt() / 255.0f : 0.0f;
        sectionsBorderGreen = jsonObject.has("sectionsBorderGreen") ? (float)jsonObject.get("sectionsBorderGreen").getAsInt() / 255.0f : 0.0f;
        sectionsBorderBlue = jsonObject.has("sectionsBorderBlue") ? (float)jsonObject.get("sectionsBorderBlue").getAsInt() / 255.0f : 0.0f;
        sectionsBorderAlpha = jsonObject.has("sectionsBorderAlpha") ? (float)jsonObject.get("sectionsBorderAlpha").getAsInt() / 255.0f : 1.0f;
        enableGuiSections = jsonObject.has("enableGuiSections") ? jsonObject.get("enableGuiSections").getAsBoolean() : true;
        enableClientPlayerWorld = jsonObject.has("enableClientPlayerWorld") ? jsonObject.get("enableClientPlayerWorld").getAsBoolean() : true;
        clientPlayerWorldHudStyle = jsonObject.has("clientPlayerWorldHudStyle") ? jsonObject.get("clientPlayerWorldHudStyle").getAsString() : "screen.hud_style.compact-blocks";
        enableClientPerformance = jsonObject.has("enableClientPerformance") ? jsonObject.get("enableClientPerformance").getAsBoolean() : true;
        enableClientFps = jsonObject.has("enableClientFps") ? jsonObject.get("enableClientFps").getAsBoolean() : true;
        enableClientMemory = jsonObject.has("enableClientMemory") ? jsonObject.get("enableClientMemory").getAsBoolean() : true;
        enableClientLatency = jsonObject.has("enableClientLatency") ? jsonObject.get("enableClientLatency").getAsBoolean() : true;
        enableNetworkPackets = jsonObject.has("enableNetworkPackets") ? jsonObject.get("enableNetworkPackets").getAsBoolean() : true;
        enablePlayerPosition = jsonObject.has("enablePlayerPosition") ? jsonObject.get("enablePlayerPosition").getAsBoolean() : true;
        enablePlayerCoords = jsonObject.has("enablePlayerCoords") ? jsonObject.get("enablePlayerCoords").getAsBoolean() : true;
        enablePlayerFacing = jsonObject.has("enablePlayerFacing") ? jsonObject.get("enablePlayerFacing").getAsBoolean() : true;
        enablePlayerRotation = jsonObject.has("enablePlayerRotation") ? jsonObject.get("enablePlayerRotation").getAsBoolean() : true;
        enablePlayerSpeed = jsonObject.has("enablePlayerSpeed") ? jsonObject.get("enablePlayerSpeed").getAsBoolean() : true;
        enableWorldInfo = jsonObject.has("enableWorldInfo") ? jsonObject.get("enableWorldInfo").getAsBoolean() : true;
        enablePlayerBiome = jsonObject.has("enablePlayerBiome") ? jsonObject.get("enablePlayerBiome").getAsBoolean() : true;
        enableDebugEntities = jsonObject.has("enableDebugEntities") ? jsonObject.get("enableDebugEntities").getAsBoolean() : true;
        enablePlayerLight = jsonObject.has("enablePlayerLight") ? jsonObject.get("enablePlayerLight").getAsBoolean() : true;
        enableWorldTime = jsonObject.has("enableWorldTime") ? jsonObject.get("enableWorldTime").getAsBoolean() : true;
        worldTimeStyle = jsonObject.has("worldTimeStyle") ? jsonObject.get("worldTimeStyle").getAsString() : "screen.world_info.time.style.hour";
        enableWorldDays = jsonObject.has("enableWorldDays") ? jsonObject.get("enableWorldDays").getAsBoolean() : true;
        enableWarningArea = jsonObject.has("enableWarningArea") ? jsonObject.get("enableWarningArea").getAsBoolean() : true;
        enableTimeSinceLastRest = jsonObject.has("enableTimeSinceLastRest") ? jsonObject.get("enableTimeSinceLastRest").getAsBoolean() : true;
        enableLowHealthWarning = jsonObject.has("enableLowHealthWarning") ? jsonObject.get("enableLowHealthWarning").getAsBoolean() : true;
        enableCriticalHealthCursorWarning = jsonObject.has("enableCriticalHealthCursorWarning") ? jsonObject.get("enableCriticalHealthCursorWarning").getAsBoolean() : true;
        enableHungerWarning = jsonObject.has("enableHungerWarning") ? jsonObject.get("enableHungerWarning").getAsBoolean() : true;
        enableOxygenCounter = jsonObject.has("enableOxygenCounter") ? jsonObject.get("enableOxygenCounter").getAsBoolean() : true;
        enableOxygenCounterAltHud = jsonObject.has("enableOxygenCounterAltHud") ? jsonObject.get("enableOxygenCounterAltHud").getAsBoolean() : true;
        oxygenCounterAltHudLocation = jsonObject.has("oxygenCounterAltHudLocation") ? jsonObject.get("oxygenCounterAltHudLocation").getAsString() : "screen.oxygen_counter.hud_location.bottom";
        enableSaturationWarning = jsonObject.has("enableSaturationWarning") ? jsonObject.get("enableSaturationWarning").getAsBoolean() : true;
        enableFreezeCounter = jsonObject.has("enableFreezeCounter") ? jsonObject.get("enableFreezeCounter").getAsBoolean() : true;
        enableWarningCounters = jsonObject.has("enableWarningCounters") ? jsonObject.get("enableWarningCounters").getAsBoolean() : true;
        enablePointedBlock = jsonObject.has("enablePointedBlock") ? jsonObject.get("enablePointedBlock").getAsBoolean() : true;
        enablePointedBlockTags = jsonObject.has("enablePointedBlockTags") ? jsonObject.get("enablePointedBlockTags").getAsBoolean() : true;
        enablePointedBlockBreakingProgress = jsonObject.has("enablePointedBlockBreakingProgress") ? jsonObject.get("enablePointedBlockBreakingProgress").getAsBoolean() : true;
        enablePointedBlockProperties = jsonObject.has("enablePointedBlockProperties") ? jsonObject.get("enablePointedBlockProperties").getAsBoolean() : true;
        enablePointedEntity = jsonObject.has("enablePointedEntity") ? jsonObject.get("enablePointedEntity").getAsBoolean() : true;
        enablePointedEntityProperties = jsonObject.has("enablePointedEntityProperties") ? jsonObject.get("enablePointedEntityProperties").getAsBoolean() : true;
        enablePlayerEquipment = jsonObject.has("enablePlayerEquipment") ? jsonObject.get("enablePlayerEquipment").getAsBoolean() : true;
        enablePlayerGear = jsonObject.has("enablePlayerGear") ? jsonObject.get("enablePlayerGear").getAsBoolean() : true;
        enablePlayerGearDarkMode = jsonObject.has("enablePlayerGearDarkMode") ? jsonObject.get("enablePlayerGearDarkMode").getAsBoolean() : true;
        enablePlayerQuiver = jsonObject.has("enablePlayerQuiver") ? jsonObject.get("enablePlayerQuiver").getAsBoolean() : true;
        enablePlayerFoodStats = jsonObject.has("enablePlayerFoodStats") ? jsonObject.get("enablePlayerFoodStats").getAsBoolean() : true;
        enablePlayerOnScreenEquipment = jsonObject.has("enablePlayerOnScreenEquipment") ? jsonObject.get("enablePlayerOnScreenEquipment").getAsBoolean() : true;
        playerOnScreenEquipmentHudLocation = jsonObject.has("playerOnScreenEquipmentHudLocation") ? jsonObject.get("playerOnScreenEquipmentHudLocation").getAsString() : "screen.on_screen_equipment.hud_location.middle_right";
        enablePlayerOnScreenEquipmentDurability = jsonObject.has("enablePlayerOnScreenEquipmentDurability") ? jsonObject.get("enablePlayerOnScreenEquipmentDurability").getAsBoolean() : true;
        playerOnScreenEquipmentDurabilityStyle = jsonObject.has("playerOnScreenEquipmentDurabilityStyle") ? jsonObject.get("playerOnScreenEquipmentDurabilityStyle").getAsString() : "screen.on_screen_equipment.durability.hud_style.damage";
        enablePlayerOnScreenEquipmentArms = jsonObject.has("enablePlayerOnScreenEquipmentArms") ? jsonObject.get("enablePlayerOnScreenEquipmentArms").getAsBoolean() : true;
        enablePlayerOnScreenEquipmentTexture = jsonObject.has("enablePlayerOnScreenEquipmentTexture") ? jsonObject.get("enablePlayerOnScreenEquipmentTexture").getAsBoolean() : false;
        enablePlayerShulkerBoxHud = jsonObject.has("enablePlayerShulkerBoxHud") ? jsonObject.get("enablePlayerShulkerBoxHud").getAsBoolean() : true;
        enablePlayerBundleHud = jsonObject.has("enablePlayerBundleHud") ? jsonObject.get("enablePlayerBundleHud").getAsBoolean() : true;
        enableBiomeTimeWeather = jsonObject.has("enableBiomeTimeWeather") ? jsonObject.get("enableBiomeTimeWeather").getAsBoolean() : true;
        enableBiomeTimeWeatherSlimes = jsonObject.has("enableBiomeTimeWeatherSlimes") ? jsonObject.get("enableBiomeTimeWeatherSlimes").getAsBoolean() : true;
        biomeTimeWeatherHudLocation = jsonObject.has("biomeTimeWeatherHudLocation") ? jsonObject.get("biomeTimeWeatherHudLocation").getAsString() : "screen.biome-weather-time.hud_location.top_left";
        enableAdvancedTooltips = jsonObject.has("enableAdvancedTooltips") ? jsonObject.get("enableAdvancedTooltips").getAsBoolean() : true;
        enableItemDurability = jsonObject.has("enableItemDurability") ? jsonObject.get("enableItemDurability").getAsBoolean() : true;
        enableItemPenaltyLevel = jsonObject.has("enableItemPenaltyLevel") ? jsonObject.get("enableItemPenaltyLevel").getAsBoolean() : true;
        enableFoodStats = jsonObject.has("enableFoodStats") ? jsonObject.get("enableFoodStats").getAsBoolean() : true;
        enableBeeNestInfo = jsonObject.has("enableBeeNestInfo") ? jsonObject.get("enableBeeNestInfo").getAsBoolean() : true;
        enableLodestoneCompassInfo = jsonObject.has("enableLodestoneCompassInfo") ? jsonObject.get("enableLodestoneCompassInfo").getAsBoolean() : true;
        enableBundleCapacity = jsonObject.has("enableBundleCapacity") ? jsonObject.get("enableBundleCapacity").getAsBoolean() : true;
        enableAxolotlBucketInfo = jsonObject.has("enableAxolotlBucketInfo") ? jsonObject.get("enableAxolotlBucketInfo").getAsBoolean() : true;
        enablePumpkinTexture = jsonObject.has("enablePumpkinTexture") ? jsonObject.get("enablePumpkinTexture").getAsBoolean() : false;
        enableVignetteTexture = jsonObject.has("enableVignetteTexture") ? jsonObject.get("enableVignetteTexture").getAsBoolean() : false;
        enableWitherDarkenSky = jsonObject.has("enableWitherDarkenSky") ? jsonObject.get("enableWitherDarkenSky").getAsBoolean() : true;
        enableRainParticles = jsonObject.has("enableRainParticles") ? jsonObject.get("enableRainParticles").getAsBoolean() : true;
        enableOtherParticles = jsonObject.has("enableOtherParticles") ? jsonObject.get("enableOtherParticles").getAsBoolean() : true;
        enableStatusEffectsDuration = jsonObject.has("enableStatusEffectsDuration") ? jsonObject.get("enableStatusEffectsDuration").getAsBoolean() : true;
        Config.saveConfig();
    }

    public static void saveConfig() throws FileNotFoundException {
        JsonObject object = new JsonObject();
        object.addProperty("enableSelectionBox", enableSelectionBox);
        object.addProperty("selectionBoxRed", (Number)((int)(selectionBoxRed * 255.0f)));
        object.addProperty("selectionBoxGreen", (Number)((int)(selectionBoxGreen * 255.0f)));
        object.addProperty("selectionBoxBlue", (Number)((int)(selectionBoxBlue * 255.0f)));
        object.addProperty("selectionBoxAlpha", (Number)((int)(selectionBoxAlpha * 255.0f)));
        object.addProperty("selectionBoxThickness", (Number)((int)selectionBoxThickness));
        object.addProperty("sectionsRed", (Number)((int)(sectionsRed * 255.0f)));
        object.addProperty("sectionsGreen", (Number)((int)(sectionsGreen * 255.0f)));
        object.addProperty("sectionsBlue", (Number)((int)(sectionsBlue * 255.0f)));
        object.addProperty("sectionsAlpha", (Number)((int)(sectionsAlpha * 255.0f)));
        object.addProperty("sectionsBorderRed", (Number)((int)(sectionsBorderRed * 255.0f)));
        object.addProperty("sectionsBorderGreen", (Number)((int)(sectionsBorderGreen * 255.0f)));
        object.addProperty("sectionsBorderBlue", (Number)((int)(sectionsBorderBlue * 255.0f)));
        object.addProperty("sectionsBorderAlpha", (Number)((int)(sectionsBorderAlpha * 255.0f)));
        object.addProperty("enableGuiSections", enableGuiSections);
        object.addProperty("enableClientPlayerWorld", enableClientPlayerWorld);
        object.addProperty("clientPlayerWorldHudStyle", clientPlayerWorldHudStyle);
        object.addProperty("enableClientPerformance", enableClientPerformance);
        object.addProperty("enableClientFps", enableClientFps);
        object.addProperty("enableClientMemory", enableClientMemory);
        object.addProperty("enableClientLatency", enableClientLatency);
        object.addProperty("enableNetworkPackets", enableNetworkPackets);
        object.addProperty("enablePlayerPosition", enablePlayerPosition);
        object.addProperty("enablePlayerCoords", enablePlayerCoords);
        object.addProperty("enablePlayerFacing", enablePlayerFacing);
        object.addProperty("enablePlayerRotation", enablePlayerRotation);
        object.addProperty("enablePlayerSpeed", enablePlayerSpeed);
        object.addProperty("enableWorldInfo", enableWorldInfo);
        object.addProperty("enablePlayerBiome", enablePlayerBiome);
        object.addProperty("enableDebugEntities", enableDebugEntities);
        object.addProperty("enablePlayerLight", enablePlayerLight);
        object.addProperty("enableWorldTime", enableWorldTime);
        object.addProperty("worldTimeStyle", worldTimeStyle);
        object.addProperty("enableWorldDays", enableWorldDays);
        object.addProperty("enableWarningArea", enableWarningArea);
        object.addProperty("enableTimeSinceLastRest", enableTimeSinceLastRest);
        object.addProperty("enableLowHealthWarning", enableLowHealthWarning);
        object.addProperty("enableCriticalHealthCursorWarning", enableCriticalHealthCursorWarning);
        object.addProperty("enableHungerWarning", enableHungerWarning);
        object.addProperty("enableOxygenCounter", enableOxygenCounter);
        object.addProperty("enableOxygenCounterAltHud", enableOxygenCounterAltHud);
        object.addProperty("oxygenCounterAltHudLocation", oxygenCounterAltHudLocation);
        object.addProperty("enableSaturationWarning", enableSaturationWarning);
        object.addProperty("enableFreezeCounter", enableFreezeCounter);
        object.addProperty("enableWarningCounters", enableWarningCounters);
        object.addProperty("enablePointedBlock", enablePointedBlock);
        object.addProperty("enablePointedBlockTags", enablePointedBlockTags);
        object.addProperty("enablePointedBlockBreakingProgress", enablePointedBlockBreakingProgress);
        object.addProperty("enablePointedBlockProperties", enablePointedBlockProperties);
        object.addProperty("enablePointedEntity", enablePointedEntity);
        object.addProperty("enablePointedEntityProperties", enablePointedEntityProperties);
        object.addProperty("enablePlayerEquipment", enablePlayerEquipment);
        object.addProperty("enablePlayerGear", enablePlayerGear);
        object.addProperty("enablePlayerGearDarkMode", enablePlayerGearDarkMode);
        object.addProperty("enablePlayerQuiver", enablePlayerQuiver);
        object.addProperty("enablePlayerFoodStats", enablePlayerFoodStats);
        object.addProperty("enablePlayerOnScreenEquipment", enablePlayerOnScreenEquipment);
        object.addProperty("playerOnScreenEquipmentHudLocation", playerOnScreenEquipmentHudLocation);
        object.addProperty("enablePlayerOnScreenEquipmentDurability", enablePlayerOnScreenEquipmentDurability);
        object.addProperty("playerOnScreenEquipmentDurabilityStyle", playerOnScreenEquipmentDurabilityStyle);
        object.addProperty("enablePlayerOnScreenEquipmentArms", enablePlayerOnScreenEquipmentArms);
        object.addProperty("enablePlayerOnScreenEquipmentTexture", enablePlayerOnScreenEquipmentTexture);
        object.addProperty("enablePlayerShulkerBoxHud", enablePlayerShulkerBoxHud);
        object.addProperty("enablePlayerBundleHud", enablePlayerBundleHud);
        object.addProperty("enableBiomeTimeWeather", enableBiomeTimeWeather);
        object.addProperty("enableBiomeTimeWeatherSlimes", enableBiomeTimeWeatherSlimes);
        object.addProperty("biomeTimeWeatherHudLocation", biomeTimeWeatherHudLocation);
        object.addProperty("enableAdvancedTooltips", enableAdvancedTooltips);
        object.addProperty("enableItemDurability", enableItemDurability);
        object.addProperty("enableItemPenaltyLevel", enableItemPenaltyLevel);
        object.addProperty("enableFoodStats", enableFoodStats);
        object.addProperty("enableBeeNestInfo", enableBeeNestInfo);
        object.addProperty("enableLodestoneCompassInfo", enableLodestoneCompassInfo);
        object.addProperty("enableBundleCapacity", enableBundleCapacity);
        object.addProperty("enableAxolotlBucketInfo", enableAxolotlBucketInfo);
        object.addProperty("enablePumpkinTexture", enablePumpkinTexture);
        object.addProperty("enableVignetteTexture", enableVignetteTexture);
        object.addProperty("enableWitherDarkenSky", enableWitherDarkenSky);
        object.addProperty("enableRainParticles", enableRainParticles);
        object.addProperty("enableOtherParticles", enableOtherParticles);
        object.addProperty("enableStatusEffectsDuration", enableStatusEffectsDuration);
        if (configFile.exists()) {
            configFile.delete();
        }
        PrintWriter writer = new PrintWriter(configFile);
        writer.print(Config.objectToString(object));
        writer.close();
    }

    private static String objectToString(JsonObject object) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent("\t");
            Streams.write((JsonElement)object, (JsonWriter)jsonWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void resetSelectionBox() throws FileNotFoundException {
        Config.setSelectionBoxRed(0.0f);
        Config.setSelectionBoxGreen(0.0f);
        Config.setSelectionBoxBlue(0.0f);
        Config.setSelectionBoxAlpha(0.4f);
        Config.setSelectionBoxThickness(2.0f);
        Config.saveConfig();
    }

    public static void resetSectionsColor() throws FileNotFoundException {
        Config.setSectionsRed(0.1176f);
        Config.setSectionsGreen(0.1176f);
        Config.setSectionsBlue(0.1176f);
        Config.setSectionsAlpha(0.8235f);
        Config.saveConfig();
    }

    public static void resetSectionsBorderColor() throws FileNotFoundException {
        Config.setSectionsBorderRed(0.0f);
        Config.setSectionsBorderGreen(0.0f);
        Config.setSectionsBorderBlue(0.0f);
        Config.setSectionsBorderAlpha(1.0f);
        Config.saveConfig();
    }

    public static boolean isSelectionBoxEnabled() {
        return enableSelectionBox;
    }

    public static float getSelectionBoxRed() {
        return Config.between(selectionBoxRed, 0.0f, 1.0f);
    }

    public static float getSelectionBoxGreen() {
        return Config.between(selectionBoxGreen, 0.0f, 1.0f);
    }

    public static float getSelectionBoxBlue() {
        return Config.between(selectionBoxBlue, 0.0f, 1.0f);
    }

    public static float getSelectionBoxAlpha() {
        return Config.between(selectionBoxAlpha, 0.0f, 1.0f);
    }

    public static float getSelectionBoxThickness() {
        return Config.between(selectionBoxThickness, 1.0f, 4.0f);
    }

    public static float getSectionsRed() {
        return Config.between(sectionsRed, 0.0f, 1.0f);
    }

    public static float getSectionsGreen() {
        return Config.between(sectionsGreen, 0.0f, 1.0f);
    }

    public static float getSectionsBlue() {
        return Config.between(sectionsBlue, 0.0f, 1.0f);
    }

    public static float getSectionsAlpha() {
        return Config.between(sectionsAlpha, 0.0f, 1.0f);
    }

    public static float getSectionsBorderRed() {
        return Config.between(sectionsBorderRed, 0.0f, 1.0f);
    }

    public static float getSectionsBorderGreen() {
        return Config.between(sectionsBorderGreen, 0.0f, 1.0f);
    }

    public static float getSectionsBorderBlue() {
        return Config.between(sectionsBorderBlue, 0.0f, 1.0f);
    }

    public static float getSectionsBorderAlpha() {
        return Config.between(sectionsBorderAlpha, 0.0f, 1.0f);
    }

    public static boolean isGuiSectionsEnabled() {
        return enableGuiSections;
    }

    public static boolean isClientPlayerWorldEnabled() {
        return enableClientPlayerWorld;
    }

    public static String getClientPlayerWorldHudStyle() {
        return clientPlayerWorldHudStyle;
    }

    public static boolean isClientPerformanceEnabled() {
        return enableClientPerformance;
    }

    public static boolean isClientFpsEnabled() {
        return enableClientFps;
    }

    public static boolean isClientMemoryEnabled() {
        return enableClientMemory;
    }

    public static boolean isClientLatencyEnabled() {
        return enableClientLatency;
    }

    public static boolean isNetworkPacketsEnabled() {
        return enableNetworkPackets;
    }

    public static boolean isPlayerPositionEnabled() {
        return enablePlayerPosition;
    }

    public static boolean isPlayerCoordsEnabled() {
        return enablePlayerCoords;
    }

    public static boolean isPlayerFacingEnabled() {
        return enablePlayerFacing;
    }

    public static boolean isPlayerRotationEnabled() {
        return enablePlayerRotation;
    }

    public static boolean isPlayerSpeedEnabled() {
        return enablePlayerSpeed;
    }

    public static boolean isWorldInfoEnabled() {
        return enableWorldInfo;
    }

    public static boolean isPlayerBiomeEnabled() {
        return enablePlayerBiome;
    }

    public static boolean isDebugEntitiesEnabled() {
        return enableDebugEntities;
    }

    public static boolean isPlayerLightEnabled() {
        return enablePlayerLight;
    }

    public static boolean isWorldTimeEnabled() {
        return enableWorldTime;
    }

    public static String getWorldTimeStyle() {
        return worldTimeStyle;
    }

    public static boolean isWorldDaysEnabled() {
        return enableWorldDays;
    }

    public static boolean isWarningAreaEnabled() {
        return enableWarningArea;
    }

    public static boolean isTimeSinceLastRestEnabled() {
        return enableTimeSinceLastRest;
    }

    public static boolean isLowHealthWarningEnabled() {
        return enableLowHealthWarning;
    }

    public static boolean isCriticalHealthCursorWarningEnabled() {
        return enableCriticalHealthCursorWarning;
    }

    public static boolean isHungerWarningEnabled() {
        return enableHungerWarning;
    }

    public static boolean isOxygenCounterEnabled() {
        return enableOxygenCounter;
    }

    public static boolean isOxygenCounterAltHudEnabled() {
        return enableOxygenCounterAltHud;
    }

    public static String getOxygenCounterAltHudLocation() {
        return oxygenCounterAltHudLocation;
    }

    public static boolean isSaturationWarningEnabled() {
        return enableSaturationWarning;
    }

    public static boolean isFreezeCounterEnabled() {
        return enableFreezeCounter;
    }

    public static boolean isWarningCountersEnabled() {
        return enableWarningCounters;
    }

    public static boolean isPointedBlockEnabled() {
        return enablePointedBlock;
    }

    public static boolean isPointedBlockTagsEnabled() {
        return enablePointedBlockTags;
    }

    public static boolean isPointedBlockBreakingProgressEnabled() {
        return enablePointedBlockBreakingProgress;
    }

    public static boolean isPointedBlockPropertiesEnabled() {
        return enablePointedBlockProperties;
    }

    public static boolean isPointedEntityEnabled() {
        return enablePointedEntity;
    }

    public static boolean isPointedEntityPropertiesEnabled() {
        return enablePointedEntityProperties;
    }

    public static boolean isPlayerEquipmentEnabled() {
        return enablePlayerEquipment;
    }

    public static boolean isPlayerGearEnabled() {
        return enablePlayerGear;
    }

    public static boolean isPlayerGearDarkModeEnabled() {
        return enablePlayerGearDarkMode;
    }

    public static boolean isPlayerQuiverEnabled() {
        return enablePlayerQuiver;
    }

    public static boolean isPlayerFoodStatsEnabled() {
        return enablePlayerFoodStats;
    }

    public static boolean isPlayerOnScreenEquipmentEnabled() {
        return enablePlayerOnScreenEquipment;
    }

    public static String getPlayerOnScreenEquipmentHudLocation() {
        return playerOnScreenEquipmentHudLocation;
    }

    public static boolean isPlayerOnScreenEquipmentDurabilityEnabled() {
        return enablePlayerOnScreenEquipmentDurability;
    }

    public static String getPlayerOnScreenEquipmentDurabilityStyle() {
        return playerOnScreenEquipmentDurabilityStyle;
    }

    public static boolean isPlayerOnScreenEquipmentArmsEnabled() {
        return enablePlayerOnScreenEquipmentArms;
    }

    public static boolean isPlayerOnScreenEquipmentTextureEnabled() {
        return enablePlayerOnScreenEquipmentTexture;
    }

    public static boolean isPlayerShulkerBoxHudEnabled() {
        return enablePlayerShulkerBoxHud;
    }

    public static boolean isPlayerBundleHudEnabled() {
        return enablePlayerBundleHud;
    }

    public static boolean isBiomeTimeWeatherEnabled() {
        return enableBiomeTimeWeather;
    }

    public static boolean isBiomeTimeWeatherSlimesEnabled() {
        return enableBiomeTimeWeatherSlimes;
    }

    public static String getBiomeTimeWeatherHudLocation() {
        return biomeTimeWeatherHudLocation;
    }

    public static boolean isAdvancedTooltipsEnabled() {
        return enableAdvancedTooltips;
    }

    public static boolean isItemDurabilityEnabled() {
        return enableItemDurability;
    }

    public static boolean isItemPenaltyLevelEnabled() {
        return enableItemPenaltyLevel;
    }

    public static boolean isFoodStatsEnabled() {
        return enableFoodStats;
    }

    public static boolean isBeeNestInfoEnabled() {
        return enableBeeNestInfo;
    }

    public static boolean isLodestoneCompassInfoEnabled() {
        return enableLodestoneCompassInfo;
    }

    public static boolean isBundleCapacityEnabled() {
        return enableBundleCapacity;
    }

    public static boolean isAxolotlBucketInfoEnabled() {
        return enableAxolotlBucketInfo;
    }

    public static boolean isPumpkinOverlayEnabled() {
        return enablePumpkinTexture;
    }

    public static boolean isVignetteOverlayEnabled() {
        return enableVignetteTexture;
    }

    public static boolean isWitherDarkenSkyEnabled() {
        return enableWitherDarkenSky;
    }

    public static boolean isRainParticlesEnabled() {
        return enableRainParticles;
    }

    public static boolean isOtherParticlesEnabled() {
        return enableOtherParticles;
    }

    public static boolean isStatusEffectsDurationEnabled() {
        return enableStatusEffectsDuration;
    }

    public static void setSelectionBoxEnabled(boolean enabled) {
        enableSelectionBox = enabled;
    }

    public static void setSelectionBoxRed(float r) {
        selectionBoxRed = Config.between(r, 0.0f, 1.0f);
    }

    public static void setSelectionBoxGreen(float g) {
        selectionBoxGreen = Config.between(g, 0.0f, 1.0f);
    }

    public static void setSelectionBoxBlue(float b) {
        selectionBoxBlue = Config.between(b, 0.0f, 1.0f);
    }

    public static void setSelectionBoxAlpha(float a) {
        selectionBoxAlpha = Config.between(a, 0.0f, 1.0f);
    }

    public static void setSelectionBoxThickness(float t) {
        selectionBoxThickness = Config.between(t, 1.0f, 4.0f);
    }

    public static void setSectionsRed(float r) {
        sectionsRed = Config.between(r, 0.0f, 1.0f);
    }

    public static void setSectionsGreen(float g) {
        sectionsGreen = Config.between(g, 0.0f, 1.0f);
    }

    public static void setSectionsBlue(float b) {
        sectionsBlue = Config.between(b, 0.0f, 1.0f);
    }

    public static void setSectionsAlpha(float a) {
        sectionsAlpha = Config.between(a, 0.0f, 1.0f);
    }

    public static void setSectionsBorderRed(float r) {
        sectionsBorderRed = Config.between(r, 0.0f, 1.0f);
    }

    public static void setSectionsBorderGreen(float g) {
        sectionsBorderGreen = Config.between(g, 0.0f, 1.0f);
    }

    public static void setSectionsBorderBlue(float b) {
        sectionsBorderBlue = Config.between(b, 0.0f, 1.0f);
    }

    public static void setSectionsBorderAlpha(float a) {
        sectionsBorderAlpha = Config.between(a, 0.0f, 1.0f);
    }

    public static void setGuiSectionsEnabled(boolean enabled) {
        enableGuiSections = enabled;
    }

    public static void setClientPlayerWorldEnabled(boolean enabled) {
        enableClientPlayerWorld = enabled;
    }

    public static void setClientPlayerWorldHudStyle(String hud) {
        clientPlayerWorldHudStyle = hud;
    }

    public static void setClientPerformanceEnabled(boolean enabled) {
        enableClientPerformance = enabled;
    }

    public static void setClientFpsEnabled(boolean enabled) {
        enableClientFps = enabled;
    }

    public static void setClientMemoryEnabled(boolean enabled) {
        enableClientMemory = enabled;
    }

    public static void setClientLatencyEnabled(boolean enabled) {
        enableClientLatency = enabled;
    }

    public static void setNetworkPacketsEnabled(boolean enabled) {
        enableNetworkPackets = enabled;
    }

    public static void setPlayerPositionEnabled(boolean enabled) {
        enablePlayerPosition = enabled;
    }

    public static void setPlayerCoordsEnabled(boolean enabled) {
        enablePlayerCoords = enabled;
    }

    public static void setPlayerFacingEnabled(boolean enabled) {
        enablePlayerFacing = enabled;
    }

    public static void setPlayerRotationEnabled(boolean enabled) {
        enablePlayerRotation = enabled;
    }

    public static void setPlayerSpeedEnabled(boolean enabled) {
        enablePlayerSpeed = enabled;
    }

    public static void setWorldInfoEnabled(boolean enabled) {
        enableWorldInfo = enabled;
    }

    public static void setPlayerBiomeEnabled(boolean enabled) {
        enablePlayerBiome = enabled;
    }

    public static void setDebugEntitiesEnabled(boolean enabled) {
        enableDebugEntities = enabled;
    }

    public static void setPlayerLightEnabled(boolean enabled) {
        enablePlayerLight = enabled;
    }

    public static void setWorldTimeEnabled(boolean enabled) {
        enableWorldTime = enabled;
    }

    public static void setWorldTimeStyle(String style) {
        worldTimeStyle = style;
    }

    public static void setWorldDaysEnabled(boolean enabled) {
        enableWorldDays = enabled;
    }

    public static void setWarningAreaEnabled(boolean enabled) {
        enableWarningArea = enabled;
    }

    public static void setTimeSinceLastRestEnabled(boolean enabled) {
        enableTimeSinceLastRest = enabled;
    }

    public static void setLowHealthWarningEnabled(boolean enabled) {
        enableLowHealthWarning = enabled;
    }

    public static void setCriticalHealthCursorWarningEnabled(boolean enabled) {
        enableCriticalHealthCursorWarning = enabled;
    }

    public static void setHungerWarningEnabled(boolean enabled) {
        enableHungerWarning = enabled;
    }

    public static void setOxygenCounterEnabled(boolean enabled) {
        enableOxygenCounter = enabled;
    }

    public static void setOxygenCounterAltHudEnabled(boolean enabled) {
        enableOxygenCounterAltHud = enabled;
    }

    public static void setOxygenCounterAltHudLocation(String position) {
        oxygenCounterAltHudLocation = position;
    }

    public static void setSaturationWarningEnabled(boolean enabled) {
        enableSaturationWarning = enabled;
    }

    public static void setFreezeCounterEnabled(boolean enabled) {
        enableFreezeCounter = enabled;
    }

    public static void setWarningCountersEnabled(boolean enabled) {
        enableWarningCounters = enabled;
    }

    public static void setPointedBlockEnabled(boolean enabled) {
        enablePointedBlock = enabled;
    }

    public static void setPointedBlockTagsEnabled(boolean enabled) {
        enablePointedBlockTags = enabled;
    }

    public static void setPointedBlockBreakingProgressEnabled(boolean enabled) {
        enablePointedBlockBreakingProgress = enabled;
    }

    public static void setPointedBlockPropertiesEnabled(boolean enabled) {
        enablePointedBlockProperties = enabled;
    }

    public static void setPointedEntityEnabled(boolean enabled) {
        enablePointedEntity = enabled;
    }

    public static void setPointedEntityPropertiesEnabled(boolean enabled) {
        enablePointedEntityProperties = enabled;
    }

    public static void setPlayerEquipmentEnabled(boolean enabled) {
        enablePlayerEquipment = enabled;
    }

    public static void setPlayerGearEnabled(boolean enabled) {
        enablePlayerGear = enabled;
    }

    public static void setPlayerGearDarkModeEnabled(boolean enabled) {
        enablePlayerGearDarkMode = enabled;
    }

    public static void setPlayerQuiverEnabled(boolean enabled) {
        enablePlayerQuiver = enabled;
    }

    public static void setPlayerFoodStatsEnabled(boolean enabled) {
        enablePlayerFoodStats = enabled;
    }

    public static void setPlayerOnScreenEquipmentEnabled(boolean enabled) {
        enablePlayerOnScreenEquipment = enabled;
    }

    public static void setPlayerOnScreenEquipmentHudLocation(String location) {
        playerOnScreenEquipmentHudLocation = location;
    }

    public static void setPlayerOnScreenEquipmentDurabilityEnabled(boolean enabled) {
        enablePlayerOnScreenEquipmentDurability = enabled;
    }

    public static void setPlayerOnScreenEquipmentDurabilityStyle(String style) {
        playerOnScreenEquipmentDurabilityStyle = style;
    }

    public static void setPlayerOnScreenEquipmentArmsEnabled(boolean enabled) {
        enablePlayerOnScreenEquipmentArms = enabled;
    }

    public static void setPlayerOnScreenEquipmentTextureEnabled(boolean enabled) {
        enablePlayerOnScreenEquipmentTexture = enabled;
    }

    public static void setPlayerShulkerBoxHudEnabled(boolean enabled) {
        enablePlayerShulkerBoxHud = enabled;
    }

    public static void setPlayerBundleHudEnabled(boolean enabled) {
        enablePlayerBundleHud = enabled;
    }

    public static void setBiomeTimeWeatherEnabled(boolean enabled) {
        enableBiomeTimeWeather = enabled;
    }

    public static void setBiomeTimeWeatherSlimesEnabled(boolean enabled) {
        enableBiomeTimeWeatherSlimes = enabled;
    }

    public static void setBiomeTimeWeatherHudLocation(String location) {
        biomeTimeWeatherHudLocation = location;
    }

    public static void setAdvancedTooltipsEnabled(boolean enabled) {
        enableAdvancedTooltips = enabled;
    }

    public static void setItemDurabilityEnabled(boolean enabled) {
        enableItemDurability = enabled;
    }

    public static void setItemPenaltyLevelEnabled(boolean enabled) {
        enableItemPenaltyLevel = enabled;
    }

    public static void setFoodStatsEnabled(boolean enabled) {
        enableFoodStats = enabled;
    }

    public static void setBeeNestInfoEnabled(boolean enabled) {
        enableBeeNestInfo = enabled;
    }

    public static void setLodestoneCompassInfoEnabled(boolean enabled) {
        enableLodestoneCompassInfo = enabled;
    }

    public static void setBundleCapacityEnabled(boolean enabled) {
        enableBundleCapacity = enabled;
    }

    public static void setAxolotlBucketInfoEnabled(boolean enabled) {
        enableAxolotlBucketInfo = enabled;
    }

    public static void setPumpkinOverlayEnabled(boolean enabled) {
        enablePumpkinTexture = enabled;
    }

    public static void setVignetteOverlayEnabled(boolean enabled) {
        enableVignetteTexture = enabled;
    }

    public static void setWitherDarkenSkyEnabled(boolean enabled) {
        enableWitherDarkenSky = enabled;
    }

    public static void setRainParticlesEnabled(boolean enabled) {
        enableRainParticles = enabled;
    }

    public static void setOtherParticlesEnabled(boolean enabled) {
        enableOtherParticles = enabled;
    }

    public static void setStatusEffectsDurationEnabled(boolean enabled) {
        enableStatusEffectsDuration = enabled;
    }

    private static float between(float i, float x, float y) {
        if (i < x) {
            i = x;
        }
        if (i > y) {
            i = y;
        }
        return i;
    }

    static {
        configFile = new File(FabricLoader.getInstance().getConfigDir() + File.separator + "EssentialGUI" + File.separator + "config.json");
    }
}

