/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lordrius.essentialgui.config.Config;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2588;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_316;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class HudClientPlayerWorld
extends class_332 {
    private class_310 mc;
    private class_1297 entity;
    private class_2338 blockPos;
    private class_2791 chunk;

    public HudClientPlayerWorld(class_310 mc) {
        this.mc = mc;
        this.entity = mc.method_1560();
        this.blockPos = new class_2338(mc.method_1560().method_23317(), mc.method_1560().method_23318(), mc.method_1560().method_23321());
        this.chunk = mc.field_1687.method_22350(this.blockPos);
        this.drawClientPlayerWorld();
    }

    private void drawClientPlayerWorld() {
        boolean isBiomeWeather = Config.isBiomeTimeWeatherEnabled() && Config.getBiomeTimeWeatherHudLocation().equalsIgnoreCase("screen.biome-weather-time.hud_location.top_left");
        int biomeWeather = isBiomeWeather ? 32 : 0;
        int y = 4 + biomeWeather;
        if (Config.getClientPlayerWorldHudStyle().equalsIgnoreCase("screen.hud_style.individual")) {
            for (int i = 0; i < this.getStringListIndividual().size(); ++i) {
                String s = this.getStringListIndividual().get(i);
                int sWidth = this.mc.field_1772.method_1727(s);
                Draw.drawBoxText(4, 14 * i + y, sWidth, s);
            }
        } else if (Config.getClientPlayerWorldHudStyle().equalsIgnoreCase("screen.hud_style.compact-block")) {
            Draw.drawBoxTextResizable(4, y, this.getStringListCompact());
        } else if (Config.getClientPlayerWorldHudStyle().equalsIgnoreCase("screen.hud_style.compact-blocks")) {
            int playerPositionY = this.getClientPerformanceStrings().size() > 0 ? y + 10 * this.getClientPerformanceStrings().size() + 4 : y;
            int worldInfoY = this.getPlayerPositionStrings().size() > 0 ? playerPositionY + 10 * this.getPlayerPositionStrings().size() + 4 : playerPositionY;
            Draw.drawBoxTextResizable(4, y, this.getClientPerformanceStrings());
            Draw.drawBoxTextResizable(4, playerPositionY, this.getPlayerPositionStrings());
            Draw.drawBoxTextResizable(4, worldInfoY, this.getWorldInfoStrings());
        } else {
            this.drawSimpleHUD();
        }
    }

    private List<String> getStringListCompact() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getClientPerformanceStrings());
        if (this.getClientPerformanceStrings().size() > 0 && (this.getPlayerPositionStrings().size() > 0 || this.getWorldInfoStrings().size() > 0)) {
            list.add("\u00a78--------------");
        }
        list.addAll(this.getPlayerPositionStrings());
        if (this.getWorldInfoStrings().size() > 0 && (this.getPlayerPositionStrings().size() > 0 || this.getClientPerformanceStrings().size() <= 0)) {
            list.add("\u00a78--------------");
        }
        list.addAll(this.getWorldInfoStrings());
        return list;
    }

    private List<String> getStringListIndividual() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getClientPerformanceStrings());
        list.addAll(this.getPlayerPositionStrings());
        list.addAll(this.getWorldInfoStrings());
        return list;
    }

    private List<String> getClientPerformanceStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (Config.isClientPerformanceEnabled()) {
            if (Config.isClientFpsEnabled()) {
                list.add(this.getClientFps());
            }
            if (Config.isClientMemoryEnabled()) {
                list.add(this.getClientMemory());
            }
            if (Config.isClientLatencyEnabled()) {
                list.add(this.getClientLatency());
            }
            if (Config.isNetworkPacketsEnabled()) {
                list.add(this.getDebugNetwork());
            }
        }
        return list;
    }

    private List<String> getPlayerPositionStrings() {
        ArrayList<String> list = new ArrayList<String>();
        boolean individual = Config.getClientPlayerWorldHudStyle().equalsIgnoreCase("screen.hud_style.individual");
        if (Config.isPlayerPositionEnabled()) {
            if (Config.isPlayerCoordsEnabled()) {
                if (individual) {
                    list.add(this.getPlayerCoordinates());
                } else {
                    list.add(this.getPlayerCoordinatesX());
                    list.add(this.getPlayerCoordinatesY());
                    list.add(this.getPlayerCoordinatesZ());
                }
            }
            if (Config.isPlayerFacingEnabled()) {
                list.add(this.getPlayerFacing());
            }
            if (Config.isPlayerRotationEnabled()) {
                if (individual) {
                    list.add(this.getPlayerPitchYaw());
                } else {
                    list.add(this.getPlayerYaw());
                    list.add(this.getPlayerPitch());
                }
            }
            if (Config.isPlayerSpeedEnabled()) {
                list.add(this.getPlayerSpeed());
            }
        }
        return list;
    }

    private List<String> getWorldInfoStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (Config.isWorldInfoEnabled()) {
            if (Config.isPlayerBiomeEnabled()) {
                list.add(this.getBiomeName());
            }
            if (Config.isDebugEntitiesEnabled()) {
                list.add(this.getDebugEntities());
            }
            if (Config.isPlayerLightEnabled()) {
                list.add(this.getLightValue());
            }
            if (Config.isWorldTimeEnabled()) {
                list.add(HudClientPlayerWorld.getDayTime());
            }
        }
        return list;
    }

    private String getClientFps() {
        boolean hasVsync = this.mc.field_1690.field_1884;
        int refreshRate = this.mc.method_22683().method_22092();
        int maxfps = this.mc.field_1690.field_1909;
        boolean unlimited = (double)this.mc.field_1690.field_1909 == class_316.field_1935.method_18617();
        String prefix = "\u00a7cF: \u00a7r" + this.mc.field_1770.replaceAll(" fps.*", "");
        return prefix + (String)(hasVsync ? "/" + refreshRate : (unlimited ? "" : "/" + maxfps)) + "fps";
    }

    private String getClientMemory() {
        long n;
        long l = Runtime.getRuntime().maxMemory();
        long m = Runtime.getRuntime().totalMemory();
        long o = m - (n = Runtime.getRuntime().freeMemory());
        long p = o * 100L / l;
        String color = p >= 0L && p < 46L ? "\u00a72" : (p >= 46L && p < 76L ? "\u00a76" : "\u00a7c");
        return String.format(Locale.ROOT, "\u00a7cM: " + color + "%2d%%\u00a7r %.1f/%.1fGB", p, Float.valueOf((float)o / 1024.0f / 1024.0f / 1024.0f), Float.valueOf((float)l / 1024.0f / 1024.0f / 1024.0f));
    }

    private String getClientLatency() {
        class_634 handler = this.mc.field_1724.field_3944;
        class_640 playerListEntry = handler.method_2871(this.mc.field_1724.method_5667());
        int latency = playerListEntry != null ? playerListEntry.method_2959() : 0;
        return "\u00a7cP: \u00a7r" + (latency <= 179 ? "\u00a72" : "\u00a7c") + latency + "ms";
    }

    private String getDebugNetwork() {
        float f = this.mc.method_1562().method_2872().method_10745();
        float g = this.mc.method_1562().method_2872().method_10762();
        return String.format("\u00a7cN: \u00a7r\u00a77%.0f \u00a7c\u2191\u00a7r %.0f \u00a72\u2193", Float.valueOf(f), Float.valueOf(g));
    }

    private String getPlayerCoordinates() {
        return String.format(Locale.ROOT, "\u00a7cX\u00a72Y\u00a79Z: \u00a7r%d / %d / %d", this.mc.method_1560().method_31477(), this.mc.method_1560().method_31478(), this.mc.method_1560().method_31479());
    }

    private String getPlayerCoordinatesX() {
        return String.format(Locale.ROOT, "\u00a7cX: \u00a7r%d", this.mc.method_1560().method_31477());
    }

    private String getPlayerCoordinatesY() {
        return String.format(Locale.ROOT, "\u00a72Y: \u00a7r%d", this.mc.method_1560().method_31478());
    }

    private String getPlayerCoordinatesZ() {
        return String.format(Locale.ROOT, "\u00a79Z: \u00a7r%d", this.mc.method_1560().method_31479());
    }

    private String getPlayerFacing() {
        return String.format(Locale.ROOT, "\u00a7cF: \u00a7r%s", this.getPlayerRotationValue());
    }

    private String getPlayerPitchYaw() {
        float degreesPitch = class_3532.method_15393((float)this.entity.method_36455());
        String pitchArrow = ((double)degreesPitch >= 0.1 ? "\u00a76\u2193" : (degreesPitch < 0.0f ? "\u00a76\u2191" : "\u00a76\u25ac")) + "\u00a7r";
        float degreesYaw = class_3532.method_15393((float)this.entity.method_36454());
        String yawArrow = ((double)degreesYaw >= 0.1 ? "\u00a76\u2192" : (degreesYaw < 0.0f ? "\u00a76\u2190" : "\u00a76\u25ac")) + "\u00a7r";
        return String.format(Locale.ROOT, "\u00a7cR: \u00a7r%.1f\u00b0 " + yawArrow + " %.1f\u00b0 " + pitchArrow, Float.valueOf(degreesYaw), Float.valueOf(degreesPitch));
    }

    private String getPlayerYaw() {
        float degreesYaw = class_3532.method_15393((float)this.entity.method_36454());
        String yawArrow = "\u00a78[" + ((double)degreesYaw >= 0.1 ? "\u00a76\u2192" : (degreesYaw < 0.0f ? "\u00a76\u2190" : "\u00a76\u25ac")) + "\u00a78]\u00a7r";
        return String.format(Locale.ROOT, "\u00a7cY: " + yawArrow + " %.1f\u00b0 ", Float.valueOf(degreesYaw));
    }

    private String getPlayerPitch() {
        float degreesPitch = class_3532.method_15393((float)this.entity.method_36455());
        String pitchArrow = "\u00a78[" + ((double)degreesPitch >= 0.1 ? "\u00a76\u2193" : (degreesPitch < 0.0f ? "\u00a76\u2191" : "\u00a76\u25ac")) + "\u00a78]\u00a7r";
        return String.format(Locale.ROOT, "\u00a7cP: " + pitchArrow + " %.1f\u00b0 ", Float.valueOf(degreesPitch));
    }

    private String getPlayerRotationValue() {
        int yaw = (int)this.mc.field_1724.method_36454();
        yaw += 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        int facingValue = yaw / 45;
        class_2588 facingPoint = new class_2588("");
        switch (facingValue) {
            case 0: {
                facingPoint = new class_2588("hud.position.facing.south");
                break;
            }
            case 1: {
                facingPoint = new class_2588("hud.position.facing.south-west");
                break;
            }
            case 2: {
                facingPoint = new class_2588("hud.position.facing.west");
                break;
            }
            case 3: {
                facingPoint = new class_2588("hud.position.facing.north-west");
                break;
            }
            case 4: {
                facingPoint = new class_2588("hud.position.facing.north");
                break;
            }
            case 5: {
                facingPoint = new class_2588("hud.position.facing.north-east");
                break;
            }
            case 6: {
                facingPoint = new class_2588("hud.position.facing.east");
                break;
            }
            case 7: {
                facingPoint = new class_2588("hud.position.facing.south-east");
            }
        }
        return facingPoint.getString();
    }

    private String getBiomeName() {
        if (this.chunk != null) {
            String biomePath = this.mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)this.mc.field_1687.method_23753(this.blockPos)).toString().replaceAll(":", ".");
            boolean isVanillaBiome = this.mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)this.mc.field_1687.method_23753(this.blockPos)).toString().contains("minecraft");
            return "\u00a7cB: \u00a7r" + (isVanillaBiome ? new class_2588("biome." + biomePath).getString() : this.mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)this.mc.field_1687.method_23753(this.blockPos)).toString());
        }
        return "";
    }

    private String getPlayerSpeed() {
        class_243 lastPos = new class_243(this.mc.field_1724.field_6038, this.mc.field_1724.field_5971, this.mc.field_1724.field_5989);
        class_243 pos = new class_243(this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321());
        double speed = Math.abs(lastPos.method_1022(pos) * 20.0);
        return String.format(Locale.ROOT, "\u00a7cS:\u00a7r %.1f (b/s)", speed);
    }

    private String getDebugEntities() {
        String debugEntitiesString = this.mc.field_1769.method_3272().replaceAll("E: ", "").replaceAll(",.*", "");
        String debugEntities = String.format(Locale.ROOT, "\u00a7cE: \u00a7r" + debugEntitiesString, new Object[0]);
        String debugTileEntities = " | \u00a7cT:\u00a7r " + this.mc.field_1687.method_8500(this.blockPos).method_12214().size();
        return debugEntities + debugTileEntities;
    }

    private String getLightValue() {
        if (this.mc.field_1687 != null && this.mc.field_1687.method_22340(this.blockPos) && this.chunk != null) {
            int getLightSubstracted = this.mc.field_1687.method_2935().method_12130().method_22363(this.blockPos, 0);
            int getLightSky = this.mc.field_1687.method_8314(class_1944.field_9284, this.blockPos);
            int getLightBlock = this.mc.field_1687.method_8314(class_1944.field_9282, this.blockPos);
            String lightSubstractedPrefix = getLightSubstracted <= 7 ? "\u00a7c" : "\u00a72";
            String lightSkyPrefix = getLightSky <= 7 ? "\u00a7c" : "\u00a73";
            String lightBlockPrefix = getLightBlock <= 7 ? "\u00a7c" : "\u00a76";
            return "\u00a7cL: \u00a7r" + lightSubstractedPrefix + getLightSubstracted + "\u00a7r (" + lightSkyPrefix + getLightSky + " | " + lightBlockPrefix + getLightBlock + "\u00a7r)";
        }
        return "";
    }

    private static String getDayTime() {
        return "\u00a7cT: " + Utils.getTime();
    }

    private void drawSimpleHUD() {
        int width = this.mc.method_22683().method_4486();
        int height = this.mc.method_22683().method_4502();
        String s = String.format(Locale.ROOT, "\u00a7cX\u00a72Y\u00a79Z: \u00a7r%d \u00a78| \u00a7r%d \u00a78| \u00a7r%d", this.mc.method_1560().method_31477(), this.mc.method_1560().method_31478(), this.mc.method_1560().method_31479()) + "\u00a72 \u00b7 " + this.getPlayerRotationValue() + " \u00b7 \u00a7r" + Utils.getTime();
        int sWidth = this.mc.field_1772.method_1727(s);
        Draw.drawBoxTextCenter((width - sWidth - 2) / 2, height - 85, sWidth, s);
    }
}

