/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import lordrius.essentialgui.config.Config;
import lordrius.essentialgui.util.Draw;
import net.minecraft.class_1496;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3468;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5498;
import net.minecraft.class_757;

public class HudPlayerWarningArea
extends class_332 {
    private class_2960 ICONS = new class_2960("essentialgui:textures/icons.png");
    private class_310 mc;
    private int width;
    private int height;
    private int timeSinceRest;
    private int health;
    private int hunger;
    private int saturation;
    private int oxygen;
    private int maxOxygen;
    private int freeze;
    private boolean isChatOpen;

    public HudPlayerWarningArea(class_310 mc) {
        this.mc = mc;
        this.width = mc.method_22683().method_4486();
        this.height = mc.method_22683().method_4502();
        this.health = (int)Math.ceil(mc.field_1724.method_6032());
        this.hunger = mc.field_1724.method_7344().method_7586();
        this.saturation = (int)mc.field_1724.method_7344().method_7589();
        this.oxygen = mc.field_1724.method_5669();
        this.maxOxygen = mc.field_1724.method_5748();
        this.freeze = mc.field_1724.method_32312() / 20;
        this.isChatOpen = mc.field_1755 instanceof class_408;
        this.drawWarningArea();
    }

    private void drawWarningArea() {
        if (Config.isWarningAreaEnabled()) {
            this.drawWarnings();
            if (Config.isCriticalHealthCursorWarningEnabled() && this.mc.field_1690.method_31044() == class_5498.field_26664) {
                this.drawCriticalHealthCursorWarning();
            }
        }
    }

    private void drawWarnings() {
        boolean lowHealth = Config.isLowHealthWarningEnabled() && this.health < 20;
        boolean lowFood = Config.isHungerWarningEnabled() && this.hunger < 20;
        boolean lowOxygen = Config.isOxygenCounterEnabled() && this.mc.field_1724.method_5869() && !this.mc.field_1724.method_7337() && !this.mc.field_1724.method_7325();
        boolean hasSaturation = Config.isSaturationWarningEnabled() && !this.mc.field_1724.method_7337() && !this.mc.field_1724.method_7325() && !(this.mc.field_1724.method_5854() instanceof class_1496);
        boolean isFreezing = Config.isFreezeCounterEnabled() && this.freeze > 0 && !this.mc.field_1724.method_7337() && !this.mc.field_1724.method_7325();
        int separation = 23;
        int assleepDaysX = this.isChatOpen ? 2 : 1;
        int assleepDaysY = this.isChatOpen ? this.height - 38 : this.height - 23;
        int healthWarningX = this.playerNeedRest() ? assleepDaysX + separation : assleepDaysX;
        int healthWarningY = assleepDaysY;
        int foodWarningX = lowHealth ? healthWarningX + separation : (this.playerNeedRest() ? assleepDaysX + separation : assleepDaysX);
        int foodWarningY = assleepDaysY;
        int oxygenWarningX = lowFood ? foodWarningX + separation : (lowHealth ? healthWarningX + separation : (this.playerNeedRest() ? assleepDaysX + separation : assleepDaysX));
        int oxygenWarningY = assleepDaysY;
        int freezeWarningX = lowOxygen ? oxygenWarningX + separation : (lowFood ? foodWarningX + separation : (lowHealth ? healthWarningX + separation : (this.playerNeedRest() ? assleepDaysX + separation : assleepDaysX)));
        int freezeWarningY = assleepDaysY;
        if (this.playerNeedRest()) {
            this.drawRestWarning(assleepDaysX, assleepDaysY, this.timeSinceRest);
        }
        if (lowHealth) {
            this.drawHealthWarning(healthWarningX, healthWarningY);
        }
        if (lowFood) {
            this.drawHungerWarning(foodWarningX, foodWarningY);
        }
        if (lowOxygen) {
            this.drawPlayerOxygenWarning(oxygenWarningX, oxygenWarningY);
        }
        if (hasSaturation && this.saturation > 0) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.ICONS);
            this.method_25302(new class_4587(), this.width / 2 + 10, this.height - 35, 0, 241, 5, 5);
        }
        if (isFreezing) {
            this.drawFreezeWarning(freezeWarningX, freezeWarningY);
        }
    }

    private boolean playerNeedRest() {
        if (Config.isTimeSinceLastRestEnabled() && this.mc.field_1687.method_8597().method_12491()) {
            if (System.currentTimeMillis() / 1000L % 16L == 15L) {
                this.mc.method_1562().method_2883((class_2596)new class_2799(class_2799.class_2800.field_12775));
            }
            this.timeSinceRest = this.mc.field_1724.method_3143().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15429)) / 24000;
            return this.timeSinceRest >= 1;
        }
        return false;
    }

    private void drawRestWarning(int x, int y, int timeSinceRest) {
        Draw.drawWarningRect(x, y);
        this.mc.method_1480().method_4010(new class_1799((class_1935)class_2246.field_10069), x + 2, y + 3);
        if (Config.isWarningCountersEnabled() && !this.isChatOpen) {
            Draw.drawBoxTextCenter(x + 3, y - 11, 17, String.valueOf(this.timeSinceRest), Draw.getSectionColor().getRGB(), this.timeSinceRest >= 3 ? Draw.RED.getRGB() : Draw.GRAY.getRGB());
        }
    }

    private void drawHealthWarning(int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.ICONS);
        Draw.drawWarningRect(x, y);
        RenderSystem.setShader(class_757::method_34542);
        Draw.drawScaledCustomSizeModalRect(x + 2, y + 2, 18.0f, -9.0f, 9, 9, 18, 18, 256.0f, 256.0f);
        if (Config.isWarningCountersEnabled() && !this.isChatOpen) {
            Draw.drawBoxTextCenter(x + 3, y - 11, 17, String.valueOf(this.health), Draw.getSectionColor().getRGB(), this.health <= 10 ? Draw.RED.getRGB() : Draw.DARK_GREEN.getRGB());
        }
    }

    private void drawHungerWarning(int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.ICONS);
        Draw.drawWarningRect(x, y);
        RenderSystem.setShader(class_757::method_34542);
        Draw.drawScaledCustomSizeModalRect(x + 2, y + 2, 45.0f, -9.0f, 9, 9, 18, 18, 256.0f, 256.0f);
        if (Config.isWarningCountersEnabled() && !this.isChatOpen) {
            Draw.drawBoxTextCenter(x + 3, y - 11, 17, String.valueOf(this.hunger), Draw.getSectionColor().getRGB(), this.hunger <= 10 ? Draw.RED.getRGB() : Draw.DARK_GREEN.getRGB());
        }
    }

    private void drawPlayerOxygenWarning(int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.ICONS);
        Draw.drawWarningRect(x, y);
        RenderSystem.setShader(class_757::method_34542);
        Draw.drawScaledCustomSizeModalRect(x + 2, y + 2, 27.0f, -9.0f, 9, 9, 18, 18, 256.0f, 256.0f);
        if (Config.isWarningCountersEnabled() && !this.isChatOpen) {
            this.drawPlayerOxygenBar(x, y - 14, 21, false);
        }
        if (Config.isOxygenCounterAltHudEnabled()) {
            int hudX = (this.width - 40) / 2;
            int hudY = Config.getOxygenCounterAltHudLocation().equalsIgnoreCase("screen.oxygen_counter.hud_location.top") ? this.height / 2 - 65 : (Config.getClientPlayerWorldHudStyle().equalsIgnoreCase("screen.hud_style.simple") ? this.height - 102 : this.height - 88);
            this.drawPlayerOxygenBar(hudX, hudY, 50, true);
        }
    }

    private void drawPlayerOxygenBar(int x, int y, int maxSize, boolean drawIcon) {
        int barColor = this.oxygen / 20 >= 0 && this.oxygen / 20 < 4 ? Draw.DARK_RED.getRGB() : (this.oxygen / 20 >= 4 && this.oxygen / 20 <= 7 ? Draw.DARK_AQUA.getRGB() : Draw.DARK_AQUA.getRGB());
        int scaled = (this.oxygen * maxSize - 1) / this.maxOxygen;
        if (scaled < 0) {
            scaled = 0;
        }
        if (drawIcon) {
            Draw.drawCustomRectangle(x - 14, y, 12, 12);
            Draw.drawIconOxygen(x - 12, y + 2);
        }
        Draw.drawCustomRectangle(x, y, maxSize, 12);
        Draw.drawRect(x + 1, y + 1, x + scaled + 1, y + 12, barColor);
    }

    private void drawFreezeWarning(int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.ICONS);
        Draw.drawWarningRect(x, y);
        RenderSystem.setShader(class_757::method_34542);
        Draw.drawScaledCustomSizeModalRect(x + 2, y + 2, 63.0f, -9.0f, 9, 9, 18, 18, 256.0f, 256.0f);
        if (Config.isWarningCountersEnabled() && !this.isChatOpen) {
            Draw.drawBoxTextCenter(x + 3, y - 11, 17, String.valueOf(this.freeze));
        }
    }

    private void drawCriticalHealthCursorWarning() {
        if (!this.mc.method_1496() && this.mc.field_1690.field_1907.method_1434()) {
            return;
        }
        if (this.isChatOpen) {
            return;
        }
        if (this.health <= 10) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        this.method_25302(new class_4587(), (this.width - 15) / 2, (this.height - 15) / 2, 0, 0, 15, 15);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

