/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.fishontheline.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ConfigHandler {
    public static PropertyMirror<Boolean> mustHoldBellInOffhand = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("mustHoldBellInOffhand", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("If enabled, the fish on the line sound will only go off if a bell is held in the offhand while fishing.").finishValue(arg_0 -> mustHoldBellInOffhand.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "fishontheline-fabric.json");
        ConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

