/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mrbysco.flatterentities.Flattener;
import com.mrbysco.flatterentities.FlatterEntities;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class FlatConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    private static boolean isValidResourceLocation(Object object) {
        boolean flag = object instanceof String;
        if (flag) {
            String value = (String)object;
            if (value.isEmpty()) {
                return true;
            }
            return ResourceLocation.func_208304_a((String)value) != null;
        }
        return false;
    }

    public static boolean isValidOption(Object object) {
        boolean flag = object instanceof String;
        if (flag) {
            String[] splitValue;
            String value = (String)object;
            if (value.isEmpty()) {
                return true;
            }
            if (value.contains(",") && (splitValue = value.split(",")).length == 2) {
                return ResourceLocation.func_208304_a((String)splitValue[0]) != null && ResourceLocation.func_208304_a((String)splitValue[1]) != null;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        FlatterEntities.LOGGER.debug("Loaded Flatter Entities' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        FlatterEntities.LOGGER.debug("Flatter Entities' config just got changed on the file system!");
    }

    @SubscribeEvent
    public static void onReload(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getModId().equals("flatterentities")) {
            Flattener.reloadCache();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityDimensionWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensionBlacklist;
        public final ForgeConfigSpec.BooleanValue invertDimensionBlacklist;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.entityBlacklist = builder.comment("A list of entities that won't show flat ever [Syntax: \"modid:entity\" ]\n[Example: \"minecraft:cow\"]").defineListAllowEmpty(Collections.singletonList("entityBlacklist"), () -> Collections.singletonList(""), x$0 -> FlatConfig.isValidResourceLocation(x$0));
            this.entityDimensionWhitelist = builder.comment("A list of entities that will show flat even when a dimension is blacklisted [Syntax: \"modid:entity,modid:dimension\" ]\n[Example: \"minecraft:bee,minecraft:the_nether\"]").defineListAllowEmpty(Collections.singletonList("entityDimensionWhitelist"), () -> Collections.singletonList(""), FlatConfig::isValidOption);
            this.dimensionBlacklist = builder.comment("A list of dimensions that won't have flat entities [Syntax: \"modid:dimension\" ]\n[Example: \"minecraft:the_nether\"]").defineListAllowEmpty(Collections.singletonList("dimensionBlacklist"), () -> Collections.singletonList(""), x$0 -> FlatConfig.isValidResourceLocation(x$0));
            this.invertDimensionBlacklist = builder.comment("Invert the Dimension Blacklist").define("invertDimensionBlacklist", false);
            builder.pop();
        }
    }
}

