/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flatterentities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.flatterentities.FlatConfig;
import com.mrbysco.flatterentities.FlatterEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class Flattener {
    public static boolean renderingEnabled = true;
    private static final List<EntityType<?>> entityBlacklist = new ArrayList();
    private static final Map<RegistryKey<World>, List<EntityType<?>>> entityDimensionWhitelist = new HashMap();
    private static final List<RegistryKey<World>> dimensionBlacklist = new ArrayList<RegistryKey<World>>();
    private static boolean dimensionListIsWhitelist = false;

    public static void prepareFlatRendering(float f, double x, double z, MatrixStack poseStack, Entity entityIn) {
        if (renderingEnabled) {
            EntityType entityType = entityIn.func_200600_R();
            RegistryKey entityDimension = entityIn.func_130014_f_().func_234923_W_();
            boolean entityInList = entityBlacklist.contains(entityIn.func_200600_R());
            boolean worldInList = dimensionBlacklist.contains(entityDimension);
            boolean entityBlacklisted = !entityBlacklist.isEmpty() && entityInList;
            boolean dimensionFlat = dimensionBlacklist.isEmpty() || !dimensionBlacklist.isEmpty() && dimensionListIsWhitelist == worldInList;
            boolean renderAnyway = false;
            if (!dimensionBlacklist.isEmpty() && !entityDimensionWhitelist.isEmpty()) {
                List whitelist = entityDimensionWhitelist.getOrDefault(entityDimension, new ArrayList());
                boolean bl = renderAnyway = whitelist.contains(entityType) && !entityBlacklisted;
            }
            if (!entityBlacklisted && (dimensionFlat || renderAnyway)) {
                double angle1 = MathHelper.func_76138_g((double)(Math.atan2(z, x) / Math.PI * 180.0));
                double angle2 = MathHelper.func_76138_g((double)(Math.floor(((double)f - angle1) / 45.0) * 45.0));
                PointOfView viewPoint = Minecraft.func_71410_x().field_71474_y.func_243230_g();
                boolean isPlayer = entityIn == Minecraft.func_71410_x().field_71439_g;
                float offset = 0.0f;
                if (isPlayer && entityIn instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entityIn;
                    offset = MathHelper.func_76142_g((float)(livingEntity.field_70759_as - livingEntity.field_70758_at));
                }
                if (isPlayer) {
                    if (viewPoint == PointOfView.FIRST_PERSON || viewPoint == PointOfView.THIRD_PERSON_BACK) {
                        angle1 = -90.0f - offset;
                    }
                    if (viewPoint == PointOfView.THIRD_PERSON_FRONT) {
                        angle1 = 90.0f + offset;
                    }
                }
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle1));
                poseStack.func_227862_a_(0.02f, 1.0f, 1.0f);
                if (isPlayer) {
                    if (viewPoint == PointOfView.FIRST_PERSON || viewPoint == PointOfView.THIRD_PERSON_BACK) {
                        angle2 = 90.0f + offset;
                    }
                    if (viewPoint == PointOfView.THIRD_PERSON_FRONT) {
                        angle2 = -90.0f - offset;
                    }
                }
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle2));
            }
        }
    }

    public static void reloadCache() {
        ResourceLocation resourceLocation;
        entityBlacklist.clear();
        for (String value : (List)FlatConfig.CLIENT.entityBlacklist.get()) {
            if (value.isEmpty()) continue;
            resourceLocation = ResourceLocation.func_208304_a((String)value);
            if (resourceLocation != null) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
                if (entityType != null) {
                    entityBlacklist.add(entityType);
                    continue;
                }
                FlatterEntities.LOGGER.error("Invalid entity blacklist value: {}, Unable to locate entity", (Object)value);
                continue;
            }
            FlatterEntities.LOGGER.error("Invalid entity blacklist value: {}, Are you sure this is the resource location of the entity?", (Object)value);
        }
        entityDimensionWhitelist.clear();
        for (String value : (List)FlatConfig.CLIENT.entityDimensionWhitelist.get()) {
            String[] splitValue;
            if (!value.contains(",") || (splitValue = value.split(",")).length != 2) continue;
            ResourceLocation entityLocation = ResourceLocation.func_208304_a((String)splitValue[0]);
            ResourceLocation worldLocation = ResourceLocation.func_208304_a((String)splitValue[1]);
            if (entityLocation == null || worldLocation == null) continue;
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entityLocation);
            if (entityType != null) {
                RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)worldLocation);
                List entityList = entityDimensionWhitelist.getOrDefault(worldKey, new ArrayList());
                entityList.add(entityType);
                entityDimensionWhitelist.put((RegistryKey<World>)worldKey, entityList);
                continue;
            }
            FlatterEntities.LOGGER.error("Invalid entity dimension whitelist value: {}, Unable to locate entity", (Object)value);
        }
        dimensionListIsWhitelist = (Boolean)FlatConfig.CLIENT.invertDimensionBlacklist.get();
        dimensionBlacklist.clear();
        for (String value : (List)FlatConfig.CLIENT.dimensionBlacklist.get()) {
            if (value.isEmpty()) continue;
            resourceLocation = ResourceLocation.func_208304_a((String)value);
            if (resourceLocation != null) {
                RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)resourceLocation);
                dimensionBlacklist.add((RegistryKey<World>)worldKey);
                continue;
            }
            FlatterEntities.LOGGER.error("Invalid dimension blacklist value: {}, Are you sure this is the resource location of the dimension?", (Object)value);
        }
    }
}

