/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.npc.VillagerTrades;

public class EntityTrades {
    private final Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap;

    public EntityTrades(Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap) {
        this.tradeMap = ImmutableMap.copyOf(tradeMap);
    }

    public Map<TradeRarity, List<VillagerTrades.ItemListing>> getTradeMap() {
        return this.tradeMap;
    }

    public static class Builder {
        private final Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap = (Map)Util.m_137537_(() -> {
            EnumMap map = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> map.put((TradeRarity)((Object)((Object)rarity)), new ArrayList()));
            return map;
        });

        private Builder() {
        }

        public EntityTrades build() {
            return new EntityTrades(this.tradeMap);
        }

        void deserialize(TradeRarity rarity, JsonObject object) {
            List<VillagerTrades.ItemListing> trades = this.tradeMap.get((Object)rarity);
            if (GsonHelper.m_13855_((JsonObject)object, (String)"replace", (boolean)false)) {
                trades.clear();
            }
            JsonArray tradeArray = GsonHelper.m_13933_((JsonObject)object, (String)"trades");
            for (JsonElement tradeElement : tradeArray) {
                JsonObject tradeObject = tradeElement.getAsJsonObject();
                String rawType = GsonHelper.m_13906_((JsonObject)tradeObject, (String)"type");
                ResourceLocation typeKey = ResourceLocation.m_135820_((String)rawType);
                if (typeKey == null) {
                    throw new JsonParseException("");
                }
                TradeSerializer<?> serializer = TradeManager.instance().getTypeSerializer(typeKey);
                if (serializer == null) {
                    throw new JsonParseException(String.format("Invalid trade type: %s", typeKey));
                }
                trades.add((VillagerTrades.ItemListing)serializer.deserialize(tradeObject).createVillagerTrade());
            }
        }

        static Builder create() {
            return new Builder();
        }
    }
}

