/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.datagen;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.jab125.util.tradehelper.TradeRarities;
import com.jab125.util.tradehelper.type.ITradeType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hat.gt.GobT;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7403;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public abstract class TradeProvider
implements class_2405 {
    private static final Logger LOGGER = GobT.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;
    private Map<class_1299<?>, EnumMap<TradeRarities, List<ITradeType<?>>>> trades = new HashMap();

    protected TradeProvider(class_2403 generator) {
        this.generator = generator;
    }

    protected abstract void registerTrades();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected void registerVanillaTrades() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected final void addTrade(class_1299<?> type, TradeRarities rarity, boolean isVanilla, ITradeType<?> trade) {
        if (isVanilla) {
            return;
        }
        this.addTrade(type, rarity, trade);
    }

    protected final void addTrade(class_1299<?> type, TradeRarities rarity, ITradeType<?> trade) {
        this.trades.putIfAbsent(type, new EnumMap(TradeRarities.class));
        this.trades.get(type).putIfAbsent(rarity, new ArrayList());
        this.trades.get(type).get(rarity).add(trade);
    }

    public void method_10319(class_7403 writer) {
        System.out.println("STARING");
        try {
            this.trades.clear();
            this.registerTrades();
            this.trades.forEach((entityType, tradeRarityListEnumMap) -> tradeRarityListEnumMap.forEach((tradeRarity, tradeList) -> {
                JsonObject object = new JsonObject();
                object.addProperty("replace", Boolean.valueOf(false));
                JsonArray tradeArray = new JsonArray();
                tradeList.forEach(trade -> tradeArray.add((JsonElement)trade.serialize()));
                object.add("trades", (JsonElement)tradeArray);
                class_2960 id = Objects.requireNonNull(class_2378.field_11145.method_10221(entityType));
                Path path = this.generator.method_10313().resolve("data/" + id.method_12836() + "/trades/" + id.method_12832() + "/" + tradeRarity.getKey() + ".json");
                try {
                    TradeProvider.writeToPath(writer, (JsonElement)object, path);
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
                }
            }));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static void writeToPath(class_7403 writer, JsonElement json, Path path) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
        OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8);
        JsonWriter jsonWriter = new JsonWriter((Writer)writer2);
        jsonWriter.setSerializeNulls(false);
        jsonWriter.setIndent("  ");
        class_3518.method_43677((JsonWriter)jsonWriter, (JsonElement)json, null);
        jsonWriter.close();
        writer.method_43346(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
    }

    public String method_10321() {
        return "Trades: goblintraders";
    }
}

