/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.jab125.util.tradehelper.TradeManager;
import com.jab125.util.tradehelper.TradeRarities;
import com.jab125.util.tradehelper.TradeSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3853;

public class EntityTrades {
    private final Map<TradeRarities, List<class_3853.class_1652>> tradeMap;

    public EntityTrades(Map<TradeRarities, List<class_3853.class_1652>> tradeMap) {
        this.tradeMap = ImmutableMap.copyOf(tradeMap);
    }

    public Map<TradeRarities, List<class_3853.class_1652>> getTradeMap() {
        return this.tradeMap;
    }

    public static class Builder {
        private final Map<TradeRarities, List<class_3853.class_1652>> tradeMap = (Map)class_156.method_656(() -> {
            EnumMap map = new EnumMap(TradeRarities.class);
            Arrays.stream(TradeRarities.values()).forEach(rarity -> map.put((TradeRarities)rarity, new ArrayList()));
            return map;
        });

        private Builder() {
        }

        static Builder create() {
            return new Builder();
        }

        public EntityTrades build() {
            return new EntityTrades(this.tradeMap);
        }

        void deserialize(TradeRarities rarity, JsonObject object) {
            List<class_3853.class_1652> trades = this.tradeMap.get(rarity);
            if (class_3518.method_15258((JsonObject)object, (String)"replace", (boolean)false)) {
                trades.clear();
            }
            JsonArray tradeArray = class_3518.method_15261((JsonObject)object, (String)"trades");
            for (JsonElement tradeElement : tradeArray) {
                JsonObject tradeObject = tradeElement.getAsJsonObject();
                boolean required = !class_3518.method_15254((JsonObject)tradeObject, (String)"required") || class_3518.method_15270((JsonObject)tradeObject, (String)"required");
                try {
                    String rawType = class_3518.method_15265((JsonObject)tradeObject, (String)"type");
                    class_2960 typeKey = class_2960.method_12829((String)rawType);
                    if (typeKey == null) {
                        throw new JsonParseException("");
                    }
                    TradeSerializer<?> serializer = TradeManager.instance().getTypeSerializer(typeKey);
                    if (serializer == null) {
                        throw new JsonParseException(String.format("Invalid trade type: %s", typeKey));
                    }
                    trades.add((class_3853.class_1652)serializer.deserialize(tradeObject).createTradeOffer());
                }
                catch (Exception error) {
                    if (!required) continue;
                    throw error;
                }
            }
        }
    }
}

