/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.jab125.limeappleboat.gobt.api.GobTEvents;
import com.jab125.util.tradehelper.EntityTrades;
import com.jab125.util.tradehelper.TradeRarities;
import com.jab125.util.tradehelper.TradeSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.hat.gt.GobT;
import net.hat.gt.entities.AbstractGoblinEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import org.jetbrains.annotations.Nullable;

public class TradeManager
implements IdentifiableResourceReloadListener {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON = new GsonBuilder().create();
    public static TradeManager instance;
    private List<class_1299<?>> traders = new ArrayList();
    private Map<class_1299<?>, EntityTrades> tradeMap = new HashMap();
    private Map<class_2960, TradeSerializer<?>> tradeSerializer = new HashMap();

    public static TradeManager instance() {
        if (instance == null) {
            instance = new TradeManager();
        }
        return instance;
    }

    public void registerTrader(class_1299<? extends AbstractGoblinEntity> type) {
        if (!this.traders.contains(type)) {
            this.traders.add(type);
        }
    }

    @Nullable
    public EntityTrades getTrades(class_1299<? extends AbstractGoblinEntity> type) {
        return this.tradeMap.get(type);
    }

    public void registerTypeSerializer(TradeSerializer<?> serializer) {
        this.tradeSerializer.putIfAbsent(serializer.getId(), serializer);
    }

    @Nullable
    public TradeSerializer<?> getTypeSerializer(class_2960 id) {
        return this.tradeSerializer.get(id);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 manager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        HashMap entityToResourceList = new HashMap();
        return CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.traders.forEach(entityType -> {
            String folder = String.format("trades/%s", Objects.requireNonNull(class_1299.method_5890((class_1299)entityType)).method_12832());
            HashMap<class_2960, class_3298> resources = new HashMap<class_2960, class_3298>(manager.method_14488(folder, fileName -> fileName.method_12832().endsWith(".json")));
            resources.forEach((identifier, resource) -> System.out.println(identifier.toString() + "," + resource.toString()));
            HashMap news = new HashMap(resources);
            HashMap<class_2960, class_3298> builtin = new HashMap<class_2960, class_3298>();
            resources.forEach((r1, r2) -> {
                if (r1.method_12836().equals("goblintraders")) {
                    news.remove(r1);
                    builtin.put((class_2960)r1, (class_3298)r2);
                }
            });
            resources = news;
            EnumMap tradeResources = new EnumMap(TradeRarities.class);
            Arrays.stream(TradeRarities.values()).forEach(rarity -> tradeResources.put((TradeRarities)rarity, new LinkedHashSet()));
            builtin.forEach((resource, r) -> {
                String path = resource.method_12832().substring(0, resource.method_12832().length() - FILE_TYPE_LENGTH_VALUE);
                String[] splitPath = path.split("/");
                if (splitPath.length != 3) {
                    return;
                }
                Arrays.stream(TradeRarities.values()).forEach(rarity -> {
                    if (rarity.getKey().equals(splitPath[2])) {
                        ((LinkedHashSet)tradeResources.get(rarity)).add(resource);
                    }
                });
            });
            resources.forEach((resource, r) -> {
                String path = resource.method_12832().substring(0, resource.method_12832().length() - FILE_TYPE_LENGTH_VALUE);
                String[] splitPath = path.split("/");
                if (splitPath.length != 3) {
                    return;
                }
                Arrays.stream(TradeRarities.values()).forEach(rarity -> {
                    if (rarity.getKey().equals(splitPath[2])) {
                        ((LinkedHashSet)tradeResources.get(rarity)).add(resource);
                    }
                });
            });
            EntityTrades.Builder builder = EntityTrades.Builder.create();
            Arrays.stream(TradeRarities.values()).forEach(rarity -> {
                class_1269 result = ((GobTEvents.TradeLoaded)GobTEvents.TRADE_LOADED.invoker()).interact(null, (TradeRarities)rarity);
                if (result == class_1269.field_5814) {
                    return;
                }
                this.deserializeTrades(manager, builder, (TradeRarities)rarity, (LinkedHashSet)tradeResources.get(rarity));
            });
            entityToResourceList.put(entityType, builder.build());
            this.tradeMap = ImmutableMap.copyOf((Map)entityToResourceList);
        }), backgroundExecutor)).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0));
    }

    private void deserializeTrades(class_3300 manager, EntityTrades.Builder builder, TradeRarities rarity, LinkedHashSet<class_2960> resources) {
        for (class_2960 resource : resources) {
            try {
                InputStream inputstream = ((class_3298)manager.method_14486(resource).get()).method_14482();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonObject object = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    builder.deserialize(rarity, object);
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class_2960 getFabricId() {
        return GobT.id("reload_trades");
    }
}

