/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.util.forgehelper.CraftingHelper;
import com.jab125.util.tradehelper.GoblinTrade;
import com.jab125.util.tradehelper.TradeSerializer;
import com.jab125.util.tradehelper.type.ITradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2237;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ContainerTrade
implements ITradeType<GoblinTrade> {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_1799 offerStack;
    private final class_1799 paymentStack;
    private final class_1799 secondaryPaymentStack;
    private final SlotItem[] slotItems;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int experience;
    private final boolean isRequired;

    public ContainerTrade(class_1799 offerStack, class_1799 paymentStack, class_1799 secondaryPaymentStack, float priceMultiplier, int maxTrades, int experience, SlotItem[] slotItems, boolean isRequired) {
        this.offerStack = offerStack;
        this.paymentStack = paymentStack;
        this.secondaryPaymentStack = secondaryPaymentStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.experience = experience;
        this.slotItems = slotItems;
        this.isRequired = isRequired;
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    @Override
    public GoblinTrade createTradeOffer() {
        class_1799 container = this.offerStack.method_7972();
        class_2499 itemList = new class_2499();
        for (SlotItem slotItem : this.slotItems) {
            class_2487 blockEntityTag;
            class_2487 nbtCompound = container.method_7948();
            class_2487 itemCompound = new class_2487();
            this.writeNbt(itemCompound, slotItem);
            itemList.add((Object)itemCompound);
            if (!nbtCompound.method_10545("BlockEntityTag")) {
                nbtCompound.method_10566("BlockEntityTag", (class_2520)new class_2487());
            }
            if ((blockEntityTag = nbtCompound.method_10562("BlockEntityTag")).method_10545("Items")) continue;
            blockEntityTag.method_10566("Items", (class_2520)itemList);
        }
        return new GoblinTrade(container, this.paymentStack.method_7972(), this.secondaryPaymentStack.method_7972(), this.maxTrades, this.experience, this.priceMultiplier);
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    public class_2487 writeNbt(class_2487 nbt, SlotItem item) {
        class_2960 identifier = class_2378.field_11142.method_10221((Object)item.getItemStack().method_7909());
        nbt.method_10582("id", identifier == null ? "minecraft:air" : identifier.toString());
        nbt.method_10567("Slot", (byte)item.getSlot());
        nbt.method_10567("Count", (byte)item.getItemStack().method_7947());
        if (item.getItemStack().method_7969() != null) {
            nbt.method_10566("tag", (class_2520)item.getItemStack().method_7969().method_10553());
        }
        return nbt;
    }

    public static class SlotItem {
        private int slot;
        private class_1799 itemStack;

        public SlotItem(int slot, class_1799 itemStack) {
            this.slot = slot;
            this.itemStack = itemStack;
        }

        public class_1799 getItemStack() {
            return this.itemStack;
        }

        public int getSlot() {
            return this.slot;
        }
    }

    public static class Serializer
    extends TradeSerializer<ContainerTrade> {
        Serializer() {
            super(new class_2960("goblintraders", "container"));
        }

        @Override
        public ContainerTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setOfferStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"offer_item"), true));
            builder.setPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"payment_item"), true));
            if (class_3518.method_15294((JsonObject)object, (String)"secondary_payment_item")) {
                builder.setSecondaryPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"secondary_payment_item"), true));
            }
            builder.setPriceMultiplier(class_3518.method_15277((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(class_3518.method_15282((JsonObject)object, (String)"max_trades", (int)12));
            builder.setExperience(class_3518.method_15282((JsonObject)object, (String)"experience", (int)0));
            if (class_3518.method_15294((JsonObject)object, (String)"container_items")) {
                Collection<SlotItem> slotItems = this.getSlotItems(class_3518.method_15261((JsonObject)object, (String)"container_items"));
                for (SlotItem item : slotItems) {
                    builder.setContainerItem(item.getItemStack(), item.getSlot());
                }
            }
            return builder.build();
        }

        public Collection<SlotItem> getSlotItems(JsonArray slotArray) {
            ArrayList<SlotItem> slotItems = new ArrayList<SlotItem>();
            for (JsonElement slotElement : slotArray) {
                JsonObject bundleObject = slotElement.getAsJsonObject();
                SlotItem itemStack = CraftingHelper.getSlotItem(bundleObject, true);
                slotItems.add(itemStack);
            }
            return slotItems;
        }

        @Override
        public JsonObject serialize(ContainerTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("offer_item", (JsonElement)this.serializeItemStack(trade.offerStack));
            object.add("payment_item", (JsonElement)this.serializeItemStack(trade.paymentStack));
            if (!trade.secondaryPaymentStack.method_7960()) {
                object.add("secondary_payment_item", (JsonElement)this.serializeItemStack(trade.secondaryPaymentStack));
            }
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.experience != 0) {
                object.addProperty("experience", (Number)trade.experience);
            }
            if (trade.slotItems.length > 0) {
                JsonArray itemsArray = new JsonArray();
                for (SlotItem slotItem : trade.slotItems) {
                    itemsArray.add((JsonElement)this.serializeSlotItem(slotItem));
                }
                object.add("container_items", (JsonElement)itemsArray);
            }
            return object;
        }

        private JsonObject serializeItemStack(class_1799 stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.method_7909())).toString());
            object.addProperty("count", (Number)stack.method_7947());
            if (stack.method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.method_7969()).toString());
            }
            return object;
        }

        private JsonObject serializeSlotItem(SlotItem stack) {
            JsonObject object = new JsonObject();
            object.addProperty("slot", (Number)stack.getSlot());
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.getItemStack().method_7909())).toString());
            object.addProperty("count", (Number)stack.getItemStack().method_7947());
            if (stack.getItemStack().method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.getItemStack().method_7969()).toString());
            }
            return object;
        }
    }

    public static class Builder {
        private class_1799 offerStack;
        private class_1799 paymentStack;
        private ArrayList<SlotItem> slotItems = new ArrayList();
        private class_1799 secondaryPaymentStack = class_1799.field_8037;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int experience = 10;
        private boolean required = true;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public ContainerTrade build() {
            return new ContainerTrade(this.offerStack, this.paymentStack, this.secondaryPaymentStack, this.priceMultiplier, this.maxTrades, this.experience, this.slotItems.toArray(new SlotItem[0]), this.required);
        }

        public Builder setOfferStack(class_1799 offerStack) {
            if (offerStack.method_7909() instanceof class_1747) {
                if (!(((class_1747)offerStack.method_7909()).method_7711() instanceof class_2237)) {
                    throw new RuntimeException("ItemStack need to be of minecraft:block_with_entity!");
                }
            } else {
                throw new RuntimeException("ItemStack need to be of minecraft:block_with_entity!");
            }
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPaymentStack(class_1799 paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(class_1799 secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        @Deprecated
        public Builder setExperience(int experience) {
            return this.setMerchantExperience(experience);
        }

        public Builder setMerchantExperience(int merchantExperience) {
            this.experience = merchantExperience;
            return this;
        }

        @Deprecated
        public Builder setPlayerExperience(int playerExperience) {
            return this;
        }

        public Builder setContainerItem(class_1799 itemStack, int slot) {
            for (SlotItem slotItem : this.slotItems) {
                if (slot != slotItem.getSlot()) continue;
                throw new RuntimeException("Tried to override existing slot with another item.");
            }
            this.slotItems.add(new SlotItem(slot, itemStack));
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }
    }
}

