/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.tradehelper.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.util.forgehelper.CraftingHelper;
import com.jab125.util.tradehelper.TradeSerializer;
import com.jab125.util.tradehelper.UpgradedGoblinTrade;
import com.jab125.util.tradehelper.type.ContainerTrade;
import com.jab125.util.tradehelper.type.ITradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2237;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class UpgradedContainerTrade
implements ITradeType<UpgradedGoblinTrade> {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_1799 offerStack;
    private final class_1799 paymentStack;
    private final class_1799 secondaryPaymentStack;
    private final ContainerTrade.SlotItem[] slotItems;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int merchantExperience;
    private final int playerExperience;
    private final boolean isRequired;

    public UpgradedContainerTrade(class_1799 offerStack, class_1799 paymentStack, class_1799 secondaryPaymentStack, float priceMultiplier, int maxTrades, int merchantExperience, int playerExperience, ContainerTrade.SlotItem[] slotItems, boolean isRequired) {
        this.offerStack = offerStack;
        this.paymentStack = paymentStack;
        this.secondaryPaymentStack = secondaryPaymentStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.merchantExperience = merchantExperience;
        this.playerExperience = playerExperience;
        this.slotItems = slotItems;
        this.isRequired = isRequired;
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    @Override
    public UpgradedGoblinTrade createTradeOffer() {
        class_1799 container = this.offerStack.method_7972();
        class_2499 itemList = new class_2499();
        for (ContainerTrade.SlotItem slotItem : this.slotItems) {
            class_2487 blockEntityTag;
            class_2487 nbtCompound = container.method_7948();
            class_2487 itemCompound = new class_2487();
            this.writeNbt(itemCompound, slotItem);
            itemList.add((Object)itemCompound);
            if (!nbtCompound.method_10545("BlockEntityTag")) {
                nbtCompound.method_10566("BlockEntityTag", (class_2520)new class_2487());
            }
            if ((blockEntityTag = nbtCompound.method_10562("BlockEntityTag")).method_10545("Items")) continue;
            blockEntityTag.method_10566("Items", (class_2520)itemList);
        }
        return new UpgradedGoblinTrade(container, this.paymentStack.method_7972(), this.secondaryPaymentStack.method_7972(), this.maxTrades, this.merchantExperience, this.playerExperience, this.priceMultiplier);
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    public class_2487 writeNbt(class_2487 nbt, ContainerTrade.SlotItem item) {
        class_2960 identifier = class_2378.field_11142.method_10221((Object)item.getItemStack().method_7909());
        nbt.method_10582("id", identifier == null ? "minecraft:air" : identifier.toString());
        nbt.method_10567("Slot", (byte)item.getSlot());
        nbt.method_10567("Count", (byte)item.getItemStack().method_7947());
        if (item.getItemStack().method_7969() != null) {
            nbt.method_10566("tag", (class_2520)item.getItemStack().method_7969().method_10553());
        }
        return nbt;
    }

    public static class Serializer
    extends TradeSerializer<UpgradedContainerTrade> {
        Serializer() {
            super(new class_2960("goblintraders", "upgraded_container"));
        }

        @Override
        public UpgradedContainerTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setOfferStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"offer_item"), true));
            builder.setPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"payment_item"), true));
            if (class_3518.method_15294((JsonObject)object, (String)"secondary_payment_item")) {
                builder.setSecondaryPaymentStack(CraftingHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)"secondary_payment_item"), true));
            }
            builder.setPriceMultiplier(class_3518.method_15277((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(class_3518.method_15282((JsonObject)object, (String)"max_trades", (int)12));
            builder.setMerchantExperience(class_3518.method_15282((JsonObject)object, (String)"merchant_experience", (int)0));
            builder.setPlayerExperience(class_3518.method_15282((JsonObject)object, (String)"player_experience", (int)0));
            if (class_3518.method_15294((JsonObject)object, (String)"container_items")) {
                Collection<ContainerTrade.SlotItem> slotItems = this.getSlotItems(class_3518.method_15261((JsonObject)object, (String)"container_items"));
                for (ContainerTrade.SlotItem item : slotItems) {
                    builder.setContainerItem(item.getItemStack(), item.getSlot());
                }
            }
            return builder.build();
        }

        public Collection<ContainerTrade.SlotItem> getSlotItems(JsonArray slotArray) {
            ArrayList<ContainerTrade.SlotItem> slotItems = new ArrayList<ContainerTrade.SlotItem>();
            for (JsonElement slotElement : slotArray) {
                JsonObject bundleObject = slotElement.getAsJsonObject();
                ContainerTrade.SlotItem itemStack = CraftingHelper.getSlotItem(bundleObject, true);
                slotItems.add(itemStack);
            }
            return slotItems;
        }

        @Override
        public JsonObject serialize(UpgradedContainerTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("offer_item", (JsonElement)this.serializeItemStack(trade.offerStack));
            object.add("payment_item", (JsonElement)this.serializeItemStack(trade.paymentStack));
            if (!trade.secondaryPaymentStack.method_7960()) {
                object.add("secondary_payment_item", (JsonElement)this.serializeItemStack(trade.secondaryPaymentStack));
            }
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.merchantExperience != 0) {
                object.addProperty("merchant_experience", (Number)trade.merchantExperience);
            }
            if (trade.playerExperience != 0) {
                object.addProperty("player_experience", (Number)trade.playerExperience);
            }
            if (trade.slotItems.length > 0) {
                JsonArray itemsArray = new JsonArray();
                for (ContainerTrade.SlotItem slotItem : trade.slotItems) {
                    itemsArray.add((JsonElement)this.serializeSlotItem(slotItem));
                }
                object.add("container_items", (JsonElement)itemsArray);
            }
            return object;
        }

        private JsonObject serializeItemStack(class_1799 stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.method_7909())).toString());
            object.addProperty("count", (Number)stack.method_7947());
            if (stack.method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.method_7969()).toString());
            }
            return object;
        }

        private JsonObject serializeSlotItem(ContainerTrade.SlotItem stack) {
            JsonObject object = new JsonObject();
            object.addProperty("slot", (Number)stack.getSlot());
            object.addProperty("item", Objects.requireNonNull(class_2378.field_11142.method_10221((Object)stack.getItemStack().method_7909())).toString());
            object.addProperty("count", (Number)stack.getItemStack().method_7947());
            if (stack.getItemStack().method_7985()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.getItemStack().method_7969()).toString());
            }
            return object;
        }
    }

    public static class Builder {
        private class_1799 offerStack;
        private class_1799 paymentStack;
        private ArrayList<ContainerTrade.SlotItem> slotItems = new ArrayList();
        private class_1799 secondaryPaymentStack = class_1799.field_8037;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int merchantExperience = 10;
        private int playerExperience = 10;
        private boolean required = true;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public UpgradedContainerTrade build() {
            return new UpgradedContainerTrade(this.offerStack, this.paymentStack, this.secondaryPaymentStack, this.priceMultiplier, this.maxTrades, this.merchantExperience, this.playerExperience, this.slotItems.toArray(new ContainerTrade.SlotItem[0]), this.required);
        }

        public Builder setOfferStack(class_1799 offerStack) {
            if (offerStack.method_7909() instanceof class_1747) {
                if (!(((class_1747)offerStack.method_7909()).method_7711() instanceof class_2237)) {
                    throw new RuntimeException("ItemStack need to be of minecraft:block_with_entity!");
                }
            } else {
                throw new RuntimeException("ItemStack need to be of minecraft:block_with_entity!");
            }
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPaymentStack(class_1799 paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(class_1799 secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        @Deprecated
        public Builder setExperience(int experience) {
            return this.setMerchantExperience(experience);
        }

        public Builder setMerchantExperience(int merchantExperience) {
            this.merchantExperience = merchantExperience;
            return this;
        }

        public Builder setPlayerExperience(int playerExperience) {
            this.playerExperience = playerExperience;
            return this;
        }

        public Builder setContainerItem(class_1799 itemStack, int slot) {
            for (ContainerTrade.SlotItem slotItem : this.slotItems) {
                if (slot != slotItem.getSlot()) continue;
                throw new RuntimeException("Tried to override existing slot with another item.");
            }
            this.slotItems.add(new ContainerTrade.SlotItem(slot, itemStack));
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }
    }
}

