/*
 * Decompiled with CFR 0.152.
 */
package net.hat.gt.entities;

import com.jab125.thonkutil.api.IdentifiableTrade;
import com.jab125.thonkutil.util.Util;
import com.jab125.util.tradehelper.EntityTrades;
import com.jab125.util.tradehelper.TradeManager;
import com.jab125.util.tradehelper.TradeRarities;
import com.jab125.util.tradehelper.type.UpgradedBasicTrade;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.hat.gt.GobT;
import net.hat.gt.entities.ai.AttackRevengeTargetGoal;
import net.hat.gt.entities.ai.EatFavouriteFoodGoal;
import net.hat.gt.entities.ai.FindPreferredFoodsGoal;
import net.hat.gt.entities.ai.FirePanicGoal;
import net.hat.gt.entities.ai.FollowPotentialCustomerGoal;
import net.hat.gt.entities.ai.GoblinSwimGoal;
import net.hat.gt.entities.ai.StunGoal;
import net.hat.gt.entities.ai.TradeWithPlayerGoal;
import net.hat.gt.init.ModSounds;
import net.hat.gt.init.ModStats;
import net.hat.gt.trades.UpgradedTradeOffer;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1364;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGoblinEntity
extends class_3988
implements class_1655 {
    @Nullable
    private class_2338 wanderTarget;
    private final int fallVelocity = 0;
    private final Set<UUID> tradedCustomers = new HashSet<UUID>();
    private int despawnDelay;
    private int stunDelay;
    private int fallCounter;
    private static final class_2940<? super Float> STUN_ROTATION = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<? super Boolean> STUNNED = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<? super Boolean> RAINING = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<? super Boolean> HAS_BAG = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<? super class_1799> FOODS = class_2945.method_12791(AbstractGoblinEntity.class, (class_2941)class_2943.field_13322);

    public class_5819 method_6051() {
        return super.method_6051();
    }

    public AbstractGoblinEntity(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new StunGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GoblinSwimGoal(this));
        this.field_6201.method_6277(1, (class_1352)new FirePanicGoal(this, 0.5));
        this.field_6201.method_6277(2, (class_1352)new TradeWithPlayerGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1364((class_3988)this));
        this.field_6201.method_6277(2, (class_1352)new AttackRevengeTargetGoal(this));
        this.field_6201.method_6277(3, (class_1352)new EatFavouriteFoodGoal(this));
        this.field_6201.method_6277(4, (class_1352)new FindPreferredFoodsGoal(this));
        for (class_1799 food : this.getPreferredFoods()) {
            this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, (double)0.45f, class_1856.method_8101((class_1799[])new class_1799[]{food}), false));
        }
        this.field_6201.method_6277(6, (class_1352)new FollowPotentialCustomerGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 0.35));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
    }

    public int getFallCounter() {
        return this.fallCounter;
    }

    protected void method_18008(class_1914 offer) {
        System.out.println(IdentifiableTrade.getIdOf((class_1914)offer));
        if (offer.method_8256()) {
            int i = IdentifiableTrade.getIdOf((class_1914)offer).equals((Object)new class_2960("goblintraders", "upgraded_trade_offer")) ? ((UpgradedTradeOffer)offer).getPlayerExperience() : offer.method_19279() * 10;
            this.field_6002.method_8649((class_1297)new class_1303(this.field_6002, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!(!this.method_5805() || this.method_18009() || !this.method_5753() && this.method_5809() || this.isStunned())) {
            if (player.method_5998(class_1268.field_5808).method_7909().equals(this.getFavouriteFood().method_7909()) && player.method_5998(class_1268.field_5808).method_7947() >= 30 && GobT.config.ALL_GOBLIN_TRADERS_CONFIG.CAN_BE_RESTOCKED && this.noStockLeft()) {
                player.method_5998(class_1268.field_5808).method_7939(player.method_5998(class_1268.field_5808).method_7947() - 30);
                this.method_8264().forEach(class_1914::method_19275);
                this.method_18007((class_2394)class_2398.field_11211);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (this.noStockLeft() && !GobT.config.ALL_GOBLIN_TRADERS_CONFIG.CAN_BE_RESTOCKED) {
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (hand.equals((Object)class_1268.field_5808)) {
                player.method_7281(ModStats.TRADE_WITH_GOBLIN);
            }
            if (!this.method_8264().isEmpty() && !this.field_6002.field_9236) {
                this.method_8259(player);
                this.method_17449(player, this.method_5476(), 1);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5931(class_1657 player) {
        return GobT.config.ALL_GOBLIN_TRADERS_CONFIG.CAN_BE_LEASHED;
    }

    public class_1799 method_18866(class_1937 level, class_1799 stack) {
        if (stack.method_7909() == this.getFavouriteFood().method_7909() && stack.method_7909().method_19264() != null && this.method_5805()) {
            this.method_6033(this.method_6032() + (float)stack.method_7909().method_19264().method_19230());
        }
        return super.method_18866(level, stack);
    }

    protected void method_6040() {
        class_1268 hand = this.method_6058();
        if (!this.field_6277.equals(this.method_5998(hand))) {
            this.method_6075();
        } else if (!this.field_6277.method_7960() && this.method_6115()) {
            this.method_6098(this.getFavouriteFood(), 16);
            class_1799 itemStack = this.field_6277.method_7910(this.field_6002, (class_1309)this);
            if (itemStack != this.field_6277) {
                this.method_6122(hand, itemStack);
            }
            this.method_6021();
        }
    }

    protected void method_6098(class_1799 stack, int count) {
        if (!stack.method_7960() && this.method_6115()) {
            if (stack.method_7976() == class_1839.field_8946) {
                this.method_5783(this.method_18807(stack), 0.5f, this.field_6002.field_9229.method_43057() * 0.1f + 0.9f);
            }
            if (stack.method_7976() == class_1839.field_8950) {
                this.spawnFoodParticles(stack, count);
                this.method_5783(this.method_18869(stack), 0.5f + 0.5f * (float)this.field_5974.method_43048(2), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    protected void spawnFoodParticles(class_1799 stack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 frontPosition = class_243.method_1030((float)0.0f, (float)this.field_6283).method_1021(0.25);
            frontPosition = frontPosition.method_1031(0.0, 0.35, 0.0);
            frontPosition = frontPosition.method_1019(this.method_19538());
            class_243 motion = new class_243(this.method_6051().method_43058() * 0.2 - 0.1, 0.1, this.method_6051().method_43058() * 0.2 - 0.1);
            if (this.field_6002 instanceof class_3218) {
                ((class_3218)this.field_6002).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), frontPosition.field_1352, frontPosition.field_1351, frontPosition.field_1350, 1, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350, 0.0);
                continue;
            }
            this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), frontPosition.field_1352, frontPosition.field_1351, frontPosition.field_1350, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("DespawnDelay", this.despawnDelay);
        nbt.method_10556("IsStunned", this.isStunned());
        nbt.method_10556("HasBag", ((Boolean)this.field_6011.method_12789(HAS_BAG)).booleanValue());
        nbt.method_10569("StunDuration", this.stunDelay);
        nbt.method_10548("StunRotation", this.getStunRotation());
        if (this.wanderTarget != null) {
            nbt.method_10566("WanderTarget", (class_2520)class_2512.method_10692((class_2338)this.wanderTarget));
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("DespawnDelay", 99)) {
            this.despawnDelay = nbt.method_10550("DespawnDelay");
        }
        if (nbt.method_10545("WanderTarget")) {
            this.wanderTarget = class_2512.method_10691((class_2487)nbt.method_10562("WanderTarget"));
        }
        if (nbt.method_10545("IsStunned")) {
            this.field_6011.method_12778(STUNNED, (Object)nbt.method_10577("IsStunned"));
        }
        if (nbt.method_10545("StunDuration")) {
            this.stunDelay = nbt.method_10550("StunDuration");
        }
        if (nbt.method_10545("StunRotation")) {
            this.field_6011.method_12778(STUN_ROTATION, (Object)Float.valueOf(nbt.method_10583("StunRotation")));
        }
        if (nbt.method_10545("HasBag")) {
            this.field_6011.method_12778(HAS_BAG, (Object)nbt.method_10577("HasBag"));
        }
        this.method_5614(Math.max(0, this.method_5618()));
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_20708() {
        return super.method_20708();
    }

    public void method_17449(class_1657 player, class_2561 test, int levelProgress) {
        super.method_17449(player, test, levelProgress);
    }

    public boolean method_19270() {
        return false;
    }

    protected class_3414 method_5994() {
        return ModSounds.IDLE_GRUNT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.IDLE_GRUNT;
    }

    protected class_3414 method_6002() {
        return ModSounds.IDLE_GRUNT;
    }

    protected class_3414 method_18012(boolean sold) {
        return sold ? ModSounds.IDLE_GRUNT : ModSounds.ANNOYED_GRUNT;
    }

    public boolean isPreviousCustomer(class_1657 player) {
        return !this.tradedCustomers.contains(player.method_5667());
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean attacked = super.method_5643(source, amount);
        if (attacked && source.method_5529() instanceof class_1657 && GobT.config.ALL_GOBLIN_TRADERS_CONFIG.FALL) {
            this.method_5942().method_6340();
            this.field_6011.method_12778(STUNNED, (Object)true);
            if (!this.isStunned()) {
                this.field_6011.method_12778(STUN_ROTATION, (Object)Float.valueOf(this.getStunRotation(source.method_5529())));
            }
            this.stunDelay = Math.max(GobT.config.ALL_GOBLIN_TRADERS_CONFIG.CAN_GET_KNOCKED_OUT ? (amount > this.method_6063() - 5.0f ? Util.secondsToTick((double)60.0) : Math.min(Util.secondsToTick((double)30.0), 20 + (int)(amount * 2.0f))) : Math.min(Util.secondsToTick((double)30.0), 20 + (int)(amount * 2.0f)), this.stunDelay);
        }
        return attacked;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STUNNED, (Object)false);
        this.field_6011.method_12784(FOODS, (Object)class_1799.field_8037);
        this.field_6011.method_12784(STUN_ROTATION, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(RAINING, (Object)false);
        this.field_6011.method_12784(HAS_BAG, (Object)true);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.addToInventoryOnSpawn();
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private float getStunRotation(@Nullable class_1297 entity) {
        return entity != null ? entity.method_36454() : 0.0f;
    }

    public boolean isStunned() {
        return (Boolean)this.field_6011.method_12789(STUNNED);
    }

    public float getStunRotation() {
        return ((Float)this.field_6011.method_12789(STUN_ROTATION)).floatValue();
    }

    public boolean isRaining() {
        return (Boolean)this.field_6011.method_12789(RAINING);
    }

    public boolean isHoldingItem(class_1268 hand) {
        return !this.method_5998(hand).method_7960();
    }

    public void method_5773() {
        if (this.isStunned()) {
            this.method_19181();
        }
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0) {
                this.field_6011.method_12778(STUNNED, (Object)false);
                this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.ANNOYED_GRUNT, class_3419.field_15254, 1.0f, 0.9f + this.method_6051().method_43057() * 0.2f);
                if (GobT.config.ALL_GOBLIN_TRADERS_CONFIG.NO_ATTACK_CREATIVE) {
                    try {
                        if (this.method_6065() != null && this.method_6065().method_31747() && ((class_1657)Objects.requireNonNull(this.method_6065())).method_7337()) {
                            this.method_6015(null);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        if (((Boolean)this.field_6011.method_12789(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
        if (this.field_6002.method_8419() && this.isBeingRainedOn()) {
            this.field_6011.method_12778(RAINING, (Object)true);
        } else {
            this.field_6011.method_12778(RAINING, (Object)false);
        }
        if (!this.field_6002.field_9236 && !this.method_5947()) {
            this.handleDespawn();
        }
        super.method_5773();
    }

    private boolean isBeingRainedOn() {
        class_2338 blockPos = this.method_24515();
        return this.field_6002.method_8520(blockPos) || this.field_6002.method_8520(new class_2338((double)blockPos.method_10263(), this.method_5829().field_1325, (double)blockPos.method_10260()));
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.method_18009() && --this.despawnDelay == 0) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.62f;
    }

    public abstract class_1799 getFavouriteFood();

    public Collection<class_1799> getPreferredFoods() {
        ArrayList<class_1799> preferredFoods = new ArrayList<class_1799>();
        preferredFoods.add(this.getFavouriteFood());
        return preferredFoods;
    }

    public abstract boolean canAttackBack();

    public abstract boolean canSwimToFood();

    public void addFoodToStorage(class_1799 food) {
        this.method_35199().method_5491(food);
    }

    protected void method_16078() {
        if (this.field_6002.method_8450().method_8355(class_1928.field_19391)) {
            List inventory = this.method_35199().method_24514();
            for (class_1799 currentItem : inventory) {
                this.method_5775(currentItem);
            }
        }
    }

    protected void addToInventoryOnSpawn() {
        for (int i = Math.min((int)(Math.random() * 5.0) + 1, this.getFavouriteFood().method_7914()); i > 0; --i) {
            this.method_35199().method_5491(this.getFavouriteFood().method_7972());
        }
    }

    public class_1916 method_8264() {
        if (this.field_17721 == null) {
            this.field_17721 = new class_1916();
            this.populateTradeData();
        }
        return this.field_17721;
    }

    public void populateTradeData() {
        class_1916 offers = this.method_8264();
        EntityTrades entityTrades = TradeManager.instance().getTrades((class_1299<? extends AbstractGoblinEntity>)this.method_5864());
        if (entityTrades != null) {
            System.out.println("has trades");
            Map<TradeRarities, List<class_3853.class_1652>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarities rarity : TradeRarities.values()) {
                List<class_3853.class_1652> trades = tradeMap.get(rarity);
                System.out.println(trades);
                int min = rarity.getMinimum().apply(trades, this.method_6051());
                int max = rarity.getMaximum().apply(trades, this.method_6051());
                this.addTrades(offers, trades, Math.max(min, max), rarity.shouldShuffle());
            }
        } else {
            System.out.println("No Trades!");
        }
    }

    protected void addTrades(class_1916 offers, @Nullable List<class_3853.class_1652> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            class_3853.class_1652 trade = trades.get(index);
            class_1914 offer = trade.method_7246((class_1297)this, this.method_6051());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
        if (LocalDate.now().isBefore(LocalDate.ofYearDay(2021, 340)) & (int)(Math.random() * 4.0) == 0) {
            offers.add((Object)UpgradedBasicTrade.Builder.create().setMerchantExperience(10).setPlayerExperience(25).setOfferStack(new class_1799((class_1935)class_1802.field_17534).method_7977((class_2561)class_2561.method_43471((String)class_1802.field_17534.method_7876()).method_27692(class_124.field_1065))).setMaxTrades(1).setPaymentStack(new class_1799((class_1935)class_1802.field_28866, 32)).build().createTradeOffer().method_7246((class_1297)this, this.method_6051()));
        }
    }

    protected void method_7237() {
    }

    private boolean noStockLeft() {
        AtomicBoolean b = new AtomicBoolean(true);
        this.method_8264().forEach(tradeOffer -> {
            if (!tradeOffer.method_8255()) {
                b.set(false);
            }
        });
        return b.get();
    }

    private void discardBag() {
        if (!GobT.config.ALL_GOBLIN_TRADERS_CONFIG.DISCARD_BAG) {
            return;
        }
        this.field_6011.method_12778(HAS_BAG, (Object)false);
    }

    public boolean hasBag() {
        return (Boolean)this.field_6011.method_12789(HAS_BAG);
    }

    public void updateFloating() {
        if (this.isInWater()) {
            class_3726 shapeContext = class_3726.method_16195((class_1297)this);
            if (shapeContext.method_16192(class_2404.field_24412, this.method_24515(), true) && !this.field_6002.method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15517)) {
                this.field_5952 = true;
            } else {
                this.method_18799(this.method_18798().method_1021(0.5).method_1031(0.0, 0.05, 0.0));
            }
        }
    }

    private boolean isInWater() {
        return !this.field_5953 && this.field_5964.getDouble((Object)class_3486.field_15517) > 0.0;
    }

    public abstract int minSpawnHeight();

    public abstract int maxSpawnHeight();

    public abstract int spawnDelay();

    public abstract int spawnChance();

    public abstract boolean canSpawn();
}

