/*
 * Decompiled with CFR 0.152.
 */
package net.hat.gt.spawning;

import com.jab125.thonkutil.api.Tick;
import com.jab125.thonkutil.api.annotations.SubscribeEvent;
import com.jab125.thonkutil.api.events.server.ServerStartEvent;
import com.jab125.thonkutil.api.events.server.ServerStopEvent;
import com.jab125.thonkutil.api.events.world.WorldTickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.hat.gt.entities.GoblinTraderEntity;
import net.hat.gt.init.ModEntities;
import net.hat.gt.spawning.GoblinTraderSpawner;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7134;

public class SpawnHandler {
    private static final Map<class_2960, ArrayList<GoblinTraderSpawner>> spawners = new HashMap<class_2960, ArrayList<GoblinTraderSpawner>>();
    static boolean loaded = false;

    @SubscribeEvent
    public static void onServerStart(ServerStartEvent event) {
        SpawnHandler.addToSpawners(class_7134.field_37666.method_29177(), new GoblinTraderSpawner(event.server(), "GoblinTrader", ModEntities.GOBLIN_TRADER, Objects.requireNonNull((GoblinTraderEntity)ModEntities.GOBLIN_TRADER.method_5883((class_1937)event.server().method_30002()))));
        SpawnHandler.addToSpawners(class_7134.field_37667.method_29177(), new GoblinTraderSpawner(event.server(), "VeinGoblinTrader", ModEntities.VEIN_GOBLIN_TRADER, Objects.requireNonNull((GoblinTraderEntity)ModEntities.GOBLIN_TRADER.method_5883((class_1937)event.server().method_30002()))));
        loaded = true;
    }

    @SubscribeEvent
    public static void onServerStop(ServerStopEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(WorldTickEvent event) {
        if (!event.phase().equals((Object)Tick.Phase.END)) {
            return;
        }
        if (event.isClient()) {
            return;
        }
        ArrayList<GoblinTraderSpawner> spawnerList = spawners.get(event.world().method_27983().method_29177());
        if (spawnerList != null) {
            for (GoblinTraderSpawner spawner : spawnerList) {
                if (spawner == null) continue;
                spawner.tick(event.world());
            }
        }
    }

    @Deprecated
    public static Map<class_2960, ArrayList<GoblinTraderSpawner>> getSpawners() {
        return spawners;
    }

    public static void addToSpawners(class_2960 world, GoblinTraderSpawner spawner) {
        if (!spawners.containsKey(world)) {
            spawners.put(world, new ArrayList());
        }
        spawners.get(world).add(spawner);
    }
}

