/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.platform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.item.GoblinSpawnEggItem;
import com.mrcrayfish.goblintraders.platform.services.IPlatformHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1869;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_3518;

public class FabricPlatformHelper
implements IPlatformHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @Override
    public class_1826 createSpawnEgg(Supplier<class_1299<? extends AbstractGoblinEntity>> type, int primaryColour, int secondaryColour, class_1792.class_1793 properties) {
        return new GoblinSpawnEggItem(type, primaryColour, secondaryColour, properties);
    }

    @Override
    public class_1799 deserializeItem(JsonObject object) {
        class_1799 stack = class_1869.method_35228((JsonObject)object);
        Optional.ofNullable(object.get("nbt")).flatMap(this::parseTag).ifPresent(arg_0 -> ((class_1799)stack).method_7980(arg_0));
        return stack;
    }

    private Optional<class_2487> parseTag(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return Optional.of(class_2522.method_10718((String)GSON.toJson(element)));
            }
            return Optional.of(class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt")));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

