/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.grenades;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.grenades.GrenadesMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class GrenadesModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public GrenadesModElements() {
        sounds.put(new ResourceLocation("grenades", "heal"), new SoundEvent(new ResourceLocation("grenades", "heal")));
        sounds.put(new ResourceLocation("grenades", "bip"), new SoundEvent(new ResourceLocation("grenades", "bip")));
        sounds.put(new ResourceLocation("grenades", "shot"), new SoundEvent(new ResourceLocation("grenades", "shot")));
        sounds.put(new ResourceLocation("grenades", "drim"), new SoundEvent(new ResourceLocation("grenades", "drim")));
        sounds.put(new ResourceLocation("grenades", "carro_ascend"), new SoundEvent(new ResourceLocation("grenades", "carro_ascend")));
        sounds.put(new ResourceLocation("grenades", "carro_spawn"), new SoundEvent(new ResourceLocation("grenades", "carro_spawn")));
        sounds.put(new ResourceLocation("grenades", "carro_descend"), new SoundEvent(new ResourceLocation("grenades", "carro_descend")));
        sounds.put(new ResourceLocation("grenades", "carro_rebote"), new SoundEvent(new ResourceLocation("grenades", "carro_rebote")));
        sounds.put(new ResourceLocation("grenades", "carro_rebote_1"), new SoundEvent(new ResourceLocation("grenades", "carro_rebote_1")));
        sounds.put(new ResourceLocation("grenades", "carro_hurt"), new SoundEvent(new ResourceLocation("grenades", "carro_hurt")));
        sounds.put(new ResourceLocation("grenades", "carro_ambient"), new SoundEvent(new ResourceLocation("grenades", "carro_ambient")));
        sounds.put(new ResourceLocation("grenades", "invisible"), new SoundEvent(new ResourceLocation("grenades", "invisible")));
        sounds.put(new ResourceLocation("grenades", "carro_ride"), new SoundEvent(new ResourceLocation("grenades", "carro_ride")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("grenades").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        GrenadesMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final GrenadesModElements elements;
        protected final int sortid;

        public ModElement(GrenadesModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

