/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.common.container.christmas.star.ChristmasStarContainer;
import com.jumpcutfindo.happyholidays.common.handlers.PacketHandler;
import com.jumpcutfindo.happyholidays.common.network.christmas.SummonSantaPacket;
import com.jumpcutfindo.happyholidays.common.tileentity.christmas.ChristmasStarTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.network.PacketDistributor;

public class ChristmasStarScreen
extends ContainerScreen<ChristmasStarContainer> {
    private static final ResourceLocation CHRISTMAS_STAR_GUI = new ResourceLocation("happyholidays", "textures/gui/container/christmas_star.png");
    private static final int[] STAR_HEIGHTS = new int[]{0, 6, 12, 18, 24, 31};

    public ChristmasStarScreen(ChristmasStarContainer screenContainer, PlayerInventory playerInv, ITextComponent title) {
        super((Container)screenContainer, playerInv, title);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 190;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.createMenuControls();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_238653_a_(matrixStack, null, mouseX, mouseY);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(CHRISTMAS_STAR_GUI);
        int x = (this.field_230708_k_ - this.getXSize()) / 2;
        int y = (this.field_230709_l_ - this.getYSize()) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int tier = ((ChristmasStarContainer)this.field_147002_h).getCurrentTier();
        this.func_238474_b_(matrixStack, x + 72, y + 39 + (31 - STAR_HEIGHTS[tier]), 176, 31 - STAR_HEIGHTS[tier], 32, STAR_HEIGHTS[tier]);
        TranslationTextComponent tierComponent = new TranslationTextComponent("block.happyholidays.christmas_star.tier", new Object[]{tier});
        if (((ChristmasStarContainer)this.field_147002_h).tileEntity.isBonusActive()) {
            tierComponent.func_230529_a_((ITextComponent)new TranslationTextComponent("block.happyholidays.christmas_star.bonus"));
        }
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)tierComponent, (float)(x + this.field_238742_p_), (float)(y + this.field_238743_q_), 0x404040);
        String christmasPointsString = String.format("%d", ((ChristmasStarContainer)this.field_147002_h).getCurrentPoints());
        this.field_230712_o_.func_238421_b_(matrixStack, christmasPointsString, (float)(x + 89 - this.field_230712_o_.func_78256_a(christmasPointsString) / 2), (float)(y + 52), 0x404040);
    }

    protected void func_230459_a_(MatrixStack p_230459_1_, int p_230459_2_, int p_230459_3_) {
        super.func_230459_a_(p_230459_1_, p_230459_2_, p_230459_3_);
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_243248_b(p_230451_1_, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    private void createMenuControls() {
        int x = (this.field_230708_k_ - this.getXSize()) / 2;
        int y = (this.field_230709_l_ - this.getYSize()) / 2;
        this.func_230480_a_((Widget)new SummonSantaButton(this, x + 72, y + 39, 32, 31, DialogTexts.field_240632_c_, pred -> {
            if (((ChristmasStarContainer)this.field_147002_h).tileEntity.getCurrentTier() >= 5) {
                Minecraft.func_71410_x().func_147108_a((Screen)null);
                PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new SummonSantaPacket(((ChristmasStarContainer)this.field_147002_h).tileEntity.func_174877_v()));
            }
        }));
    }

    public ChristmasStarTileEntity getTileEntity() {
        return ((ChristmasStarContainer)this.field_147002_h).getTileEntity();
    }

    public void drawTooltip(MatrixStack matrixStack, ITextComponent textComponent, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)Lists.newArrayList((Object[])new ITextComponent[]{textComponent}), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
    }

    public class SummonSantaButton
    extends Button {
        private static final String SUMMON_SANTA_TOOLTIP = "block.happyholidays.christmas_star.summon_tooltip";
        private final ChristmasStarScreen screen;

        public SummonSantaButton(ChristmasStarScreen screen, int p_i232255_1_, int p_i232255_2_, int p_i232255_3_, int p_i232255_4_, ITextComponent p_i232255_5_, Button.IPressable p_i232255_6_) {
            super(p_i232255_1_, p_i232255_2_, p_i232255_3_, p_i232255_4_, p_i232255_5_, p_i232255_6_);
            this.screen = screen;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.screen.getTileEntity().getCurrentTier() == 5) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CHRISTMAS_STAR_GUI);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 176, 31, 32, 31);
                if (this.field_230692_n_) {
                    ChristmasStarScreen.this.drawTooltip(matrixStack, (ITextComponent)new TranslationTextComponent(SUMMON_SANTA_TOOLTIP), mouseX, mouseY);
                }
            }
        }
    }
}

