/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides;

import com.google.common.collect.Lists;
import com.jumpcutfindo.happyholidays.client.screen.guides.GuideProcessor;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.common.guide.Guide;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuideScreen
extends Screen {
    public static final ResourceLocation DEFAULT_BOOK_GUI = new ResourceLocation("happyholidays", "textures/gui/guide/guide_book.png");
    public static final ResourceLocation CHRISTMAS_GUIDE_BOOK_GUI = new ResourceLocation("happyholidays", "textures/gui/guide/christmas_guide_book.png");
    public static final int PAGE_LEFT_X_START = 12;
    public static final int PAGE_LEFT_X_END = 157;
    public static final int PAGE_RIGHT_X_START = 180;
    public static final int PAGE_RIGHT_X_END = 325;
    public static final int PAGE_Y_START = 12;
    public static final int PAGE_Y_END = 188;
    public static final int PAGE_WIDTH = 145;
    public static final int PAGE_HEIGHT = 176;
    private final Guide guide;
    private GuideProcessor guideProcessor;
    public final int bgWidth;
    public final int bgHeight;
    public final int textureWidth;
    public final int textureHeight;
    public final ResourceLocation guideBookGUI;
    private ChangePageButton forwardButton;
    private ChangePageButton backButton;
    private ChangePageButton tableOfContentsButton;
    private RecipeManager recipeManager;
    private IPageLine hoveredLine;
    public double mouseX;
    public double mouseY;

    public GuideScreen(Guide guide) {
        super((ITextComponent)new StringTextComponent("Guide Book"));
        this.guide = guide;
        this.bgWidth = 337;
        this.bgHeight = 200;
        this.textureWidth = 512;
        this.textureHeight = 512;
        this.guideBookGUI = this.guide.getId().equals("christmas") ? CHRISTMAS_GUIDE_BOOK_GUI : DEFAULT_BOOK_GUI;
    }

    protected void func_231160_c_() {
        this.guideProcessor = new GuideProcessor(this, this.guide);
        this.createMenuControls();
        this.createPageControlButtons();
        this.recipeManager = this.field_230706_i_ != null ? this.field_230706_i_.field_71441_e.func_199532_z() : null;
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.guideBookGUI);
        int x = (this.field_230708_k_ - this.bgWidth) / 2;
        int y = (this.field_230709_l_ - this.bgHeight) / 2;
        GuideScreen.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.bgWidth, (int)this.bgHeight, (int)this.textureWidth, (int)this.textureHeight);
        super.func_230430_a_(matrixStack, p_230430_2_, p_230430_3_, p_230430_4_);
        this.guideProcessor.draw(matrixStack);
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public ItemRenderer getItemRenderer() {
        return this.field_230707_j_;
    }

    protected void pageBack() {
        this.guideProcessor.pageBack();
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        this.guideProcessor.pageForward();
        this.updateButtonVisibility();
    }

    protected void pageTableOfContents() {
        this.guideProcessor.setCurrentPage(1, false);
        this.updateButtonVisibility();
    }

    protected void createMenuControls() {
        int x = (this.field_230708_k_ - this.bgWidth) / 2;
        int y = (this.field_230709_l_ - this.bgHeight) / 2;
        this.func_230480_a_((Widget)new GuideCloseButton(x + 338 - 9, y - 9, 18, 18, DialogTexts.field_240632_c_, p_214161_1_ -> this.field_230706_i_.func_147108_a((Screen)null)));
    }

    protected void createPageControlButtons() {
        int x = (this.field_230708_k_ - this.bgWidth) / 2;
        int y = (this.field_230709_l_ - this.bgHeight) / 2;
        this.forwardButton = (ChangePageButton)this.func_230480_a_((Widget)new GuideChangePageButton(x + 306, y + 198, true, p_214159_1_ -> this.pageForward(), true));
        this.backButton = (ChangePageButton)this.func_230480_a_((Widget)new GuideChangePageButton(x + 281, y + 198, false, p_214158_1_ -> this.pageBack(), true));
        this.tableOfContentsButton = (ChangePageButton)this.func_230480_a_((Widget)new GuideTableOfContentsButton(x + 259, y + 195, true, p_onPress_1_ -> this.pageTableOfContents(), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.forwardButton.field_230694_p_ = this.guideProcessor.getCurrentPageIndex() < this.guideProcessor.getNumPages() - 1;
        this.backButton.field_230694_p_ = this.guideProcessor.getCurrentPageIndex() > 0;
        this.tableOfContentsButton.field_230694_p_ = !this.guideProcessor.isTablePage() && !this.guideProcessor.isTitlePage();
    }

    private void setMousePos(double mouseX, double mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.setMousePos(mouseX, mouseY);
        IPageLine pageLine = this.guideProcessor.getLineAt(mouseX, mouseY);
        if (pageLine != null) {
            if (this.hoveredLine == null) {
                this.hoveredLine = pageLine;
                pageLine.setHovered(true);
            } else if (!this.hoveredLine.equals(pageLine)) {
                this.hoveredLine.setHovered(false);
                this.hoveredLine = pageLine;
                pageLine.setHovered(true);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int value) {
        Style style;
        if (value == 0 && this.guideProcessor.isTablePage() && (style = this.guideProcessor.getClickedComponentStyleAt(mouseX, mouseY)) != null && this.func_230455_a_(style)) {
            this.updateButtonVisibility();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, value);
    }

    public boolean func_230455_a_(Style p_230455_1_) {
        ClickEvent clickevent = p_230455_1_.func_150235_h();
        if (clickevent == null) {
            return false;
        }
        if (clickevent.func_150669_a() == ClickEvent.Action.CHANGE_PAGE) {
            String s = clickevent.func_150668_b();
            try {
                int i = Integer.parseInt(s) - 1;
                return this.guideProcessor.setCurrentPage(i, true);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public void drawTooltip(MatrixStack matrixStack, ITextComponent textComponent, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)Lists.newArrayList((Object[])new ITextComponent[]{textComponent}), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
    }

    public class GuideTableOfContentsButton
    extends ChangePageButton {
        private static final String TABLE_OF_CONTENTS_TOOLTIP = "guide.happyholidays.table_of_contents_button.tooltip";
        private final boolean playTurnSound;

        public GuideTableOfContentsButton(int p_i51079_1_, int p_i51079_2_, boolean p_i51079_3_, Button.IPressable p_i51079_4_, boolean p_i51079_5_) {
            super(p_i51079_1_, p_i51079_2_, p_i51079_3_, p_i51079_4_, p_i51079_5_);
            this.playTurnSound = p_i51079_5_;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuideScreen.this.guideBookGUI);
            int i = 338;
            int j = 44;
            if (this.func_230449_g_()) {
                i += 19;
            }
            GuideTableOfContentsButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)i, (float)j, (int)19, (int)18, (int)GuideScreen.this.textureWidth, (int)GuideScreen.this.textureHeight);
            if (this.field_230692_n_) {
                GuideScreen.this.drawTooltip(matrixStack, (ITextComponent)new TranslationTextComponent(TABLE_OF_CONTENTS_TOOLTIP), mouseX, mouseY);
            }
        }
    }

    public class GuideChangePageButton
    extends ChangePageButton {
        private static final String FORWARD_BUTTON_TOOLTIP = "guide.happyholidays.forward_button.tooltip";
        private static final String BACKWARD_BUTTON_TOOLTIP = "guide.happyholidays.backward_button.tooltip";
        private final boolean isForward;
        private final boolean playTurnSound;

        public GuideChangePageButton(int p_i51079_1_, int p_i51079_2_, boolean p_i51079_3_, Button.IPressable p_i51079_4_, boolean p_i51079_5_) {
            super(p_i51079_1_, p_i51079_2_, p_i51079_3_, p_i51079_4_, p_i51079_5_);
            this.isForward = p_i51079_3_;
            this.playTurnSound = p_i51079_5_;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuideScreen.this.guideBookGUI);
            int i = 338;
            int j = 0;
            if (this.func_230449_g_()) {
                i += 23;
            }
            if (!this.isForward) {
                j += 13;
            }
            GuideChangePageButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)i, (float)j, (int)23, (int)13, (int)GuideScreen.this.textureWidth, (int)GuideScreen.this.textureHeight);
            if (this.field_230692_n_) {
                if (this.isForward) {
                    GuideScreen.this.drawTooltip(matrixStack, (ITextComponent)new TranslationTextComponent(FORWARD_BUTTON_TOOLTIP), mouseX, mouseY);
                } else {
                    GuideScreen.this.drawTooltip(matrixStack, (ITextComponent)new TranslationTextComponent(BACKWARD_BUTTON_TOOLTIP), mouseX, mouseY);
                }
            }
        }
    }

    public class GuideCloseButton
    extends Button {
        private static final String CLOSE_BUTTON_TOOLTIP = "guide.happyholidays.close_button.tooltip";

        public GuideCloseButton(int p_i232255_1_, int p_i232255_2_, int p_i232255_3_, int p_i232255_4_, ITextComponent p_i232255_5_, Button.IPressable p_i232255_6_) {
            super(p_i232255_1_, p_i232255_2_, p_i232255_3_, p_i232255_4_, p_i232255_5_, p_i232255_6_);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float p_230431_4_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuideScreen.this.guideBookGUI);
            int i = 338;
            int j = 26;
            GuideCloseButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)i, (float)j, (int)18, (int)18, (int)GuideScreen.this.textureWidth, (int)GuideScreen.this.textureHeight);
            if (this.field_230692_n_) {
                GuideScreen.this.drawTooltip(matrixStack, (ITextComponent)new TranslationTextComponent(CLOSE_BUTTON_TOOLTIP), mouseX, mouseY);
            }
        }
    }
}

