/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides.lines;

import com.jumpcutfindo.happyholidays.client.screen.guides.GuideScreen;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.common.guide.sections.RecipeSection;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;

public class RecipeLine
implements IPageLine {
    public static final int ITEM_WIDTH = 18;
    public static final int ITEM_HEIGHT = 18;
    private GuideScreen guideScreen;
    private RecipeSection recipeSection;
    private int recipeIndex;
    private int internalTimer;
    private boolean isHovered;
    private int xPos;
    private int yPos;

    public RecipeLine(GuideScreen guideScreen, RecipeSection recipeSection) {
        this.guideScreen = guideScreen;
        this.recipeSection = recipeSection;
        this.recipeIndex = 0;
    }

    @Override
    public void draw(MatrixStack matrixStack, int xPos, int yPos) {
        List<IRecipe> recipes = this.recipeSection.getRecipes();
        int baseX = xPos + 16;
        int baseY = yPos - 1;
        this.xPos = baseX;
        this.yPos = baseY;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.guideScreen.guideBookGUI);
        GuideScreen.func_238463_a_((MatrixStack)matrixStack, (int)baseX, (int)baseY, (float)337.0f, (float)80.0f, (int)114, (int)54, (int)512, (int)512);
        this.nextRecipe();
        ItemRenderer itemRenderer = this.guideScreen.getItemRenderer();
        IRecipe recipe = recipes.get(this.recipeIndex);
        int width = 3;
        int height = 3;
        if (recipe instanceof ShapedRecipe) {
            width = ((ShapedRecipe)recipe).func_192403_f();
            height = ((ShapedRecipe)recipe).func_192404_g();
        }
        for (int i = 0; i < height; ++i) {
            int currIndex;
            for (int j = 0; j < width && (currIndex = i * width + j) < recipe.func_192400_c().size(); ++j) {
                Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(currIndex);
                ItemStack[] itemStacks = ingredient.func_193365_a();
                if (itemStacks.length <= 0) continue;
                itemRenderer.func_175042_a(itemStacks[0], baseX + j * 18 + 1, baseY + i * 18 + 1);
            }
        }
        itemRenderer.func_175042_a(recipe.func_77571_b(), baseX + 97, baseY + 19);
        this.drawTooltip(matrixStack);
    }

    private void nextRecipe() {
        if (++this.internalTimer == 200) {
            this.internalTimer = 0;
            this.recipeIndex = this.recipeIndex >= this.recipeSection.getRecipes().size() - 1 ? 0 : ++this.recipeIndex;
        }
    }

    public void drawTooltip(MatrixStack matrixStack) {
        ItemStack itemStack;
        if (this.isHovered && (itemStack = this.getItemAtPos(this.guideScreen.mouseX, this.guideScreen.mouseY)) != null) {
            this.guideScreen.drawTooltip(matrixStack, itemStack.func_200301_q(), (int)this.guideScreen.mouseX, (int)this.guideScreen.mouseY);
        }
    }

    public ItemStack getItemAtPos(double x, double y) {
        int screenX = (int)(x - (double)(this.guideScreen.field_230708_k_ - this.guideScreen.bgWidth) / 2.0);
        int screenY = (int)(y - (double)(this.guideScreen.field_230709_l_ - this.guideScreen.bgHeight) / 2.0);
        if (screenY > 12 && screenY <= 188) {
            if (screenX > 12 && screenX <= 157) {
                int lineX = (int)x - this.xPos;
                int lineY = (int)y - this.yPos;
                if (lineX <= 54 && lineY <= 54) {
                    int currIndex;
                    IRecipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    int i = lineX / 18;
                    int j = lineY / 18;
                    int width = 3;
                    int height = 3;
                    if (recipe instanceof ShapedRecipe) {
                        width = ((ShapedRecipe)recipe).func_192403_f();
                        height = ((ShapedRecipe)recipe).func_192404_g();
                    }
                    if ((currIndex = j * width + i) < 0 || currIndex > recipe.func_192400_c().size() - 1) {
                        return null;
                    }
                    Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(currIndex);
                    ItemStack[] itemStacks = ingredient.func_193365_a();
                    if (itemStacks != null && itemStacks.length != 0) {
                        return itemStacks[0];
                    }
                } else if (lineX >= 97 && lineX <= 115 && lineY <= 54 && lineY >= 18) {
                    IRecipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    return recipe.func_77571_b();
                }
            } else if (screenX > 180 && screenX <= 325) {
                int lineX = (int)x - this.xPos;
                int lineY = (int)y - this.yPos;
                if (lineX <= 54 && lineY <= 54) {
                    int currIndex;
                    IRecipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    int i = lineX / 18;
                    int j = lineY / 18;
                    int width = 3;
                    int height = 3;
                    if (recipe instanceof ShapedRecipe) {
                        width = ((ShapedRecipe)recipe).func_192403_f();
                        height = ((ShapedRecipe)recipe).func_192404_g();
                    }
                    if ((currIndex = j * width + i) < 0 || currIndex > recipe.func_192400_c().size() - 1) {
                        return null;
                    }
                    Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(currIndex);
                    ItemStack[] itemStacks = ingredient.func_193365_a();
                    if (itemStacks != null && itemStacks.length != 0) {
                        return itemStacks[0];
                    }
                } else if (lineX >= 97 && lineX <= 115 && lineY <= 36 && lineY >= 18) {
                    IRecipe recipe = this.recipeSection.getRecipes().get(this.recipeIndex);
                    return recipe.func_77571_b();
                }
            }
        }
        return null;
    }

    @Override
    public void setHovered(boolean isHovered) {
        this.isHovered = isHovered;
    }
}

