/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.client.screen.guides.pages;

import com.jumpcutfindo.happyholidays.client.screen.guides.GuideScreen;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.EmptyLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.lines.IPageLine;
import com.jumpcutfindo.happyholidays.client.screen.guides.pages.IPage;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class ContentPage
implements IPage {
    private final GuideScreen guideScreen;
    private final List<IPageLine> leftPageProcessors;
    private final List<IPageLine> rightPageProcessors;

    public ContentPage(GuideScreen guideScreen, List<IPageLine> leftPageProcessors, List<IPageLine> rightPageProcessors) {
        this.guideScreen = guideScreen;
        this.leftPageProcessors = leftPageProcessors;
        this.rightPageProcessors = rightPageProcessors;
    }

    @Override
    public void draw(MatrixStack matrixStack) {
        IPageLine pageLine;
        int i;
        FontRenderer font = this.guideScreen.getFontRenderer();
        int x = (this.guideScreen.field_230708_k_ - this.guideScreen.bgWidth) / 2;
        int y = (this.guideScreen.field_230709_l_ - this.guideScreen.bgHeight) / 2;
        for (i = 0; i < this.leftPageProcessors.size(); ++i) {
            pageLine = this.leftPageProcessors.get(i);
            pageLine.draw(matrixStack, x + 12, y + 12 + i * 9);
        }
        for (i = 0; i < this.rightPageProcessors.size(); ++i) {
            pageLine = this.rightPageProcessors.get(i);
            pageLine.draw(matrixStack, x + 180, y + 12 + i * 9);
        }
    }

    @Override
    public IPageLine getLineAtPos(double x, double y) {
        int screenX = (int)(x - (double)(this.guideScreen.field_230708_k_ - this.guideScreen.bgWidth) / 2.0);
        int screenY = (int)(y - (double)(this.guideScreen.field_230709_l_ - this.guideScreen.bgHeight) / 2.0);
        List<IPageLine> processors = null;
        if (screenY > 12 && screenY <= 188) {
            if (screenX > 12 && screenX <= 157) {
                processors = this.leftPageProcessors;
            } else if (screenX > 180 && screenX <= 325) {
                processors = this.rightPageProcessors;
            }
        }
        if (processors == null) {
            return null;
        }
        int clickedIndex = (screenY - 12) / 9;
        if (clickedIndex < processors.size()) {
            IPageLine line = processors.get(clickedIndex);
            if (line instanceof EmptyLine && ((EmptyLine)line).getType() == EmptyLine.Type.BUFFER) {
                IPageLine currLine = line;
                int curr = clickedIndex;
                while (clickedIndex > 0 && currLine instanceof EmptyLine) {
                    currLine = processors.get(curr--);
                }
                return currLine;
            }
            return line;
        }
        return null;
    }
}

