/*
 * Decompiled with CFR 0.152.
 */
package com.jumpcutfindo.happyholidays.common.block.christmas.decorations;

import com.jumpcutfindo.happyholidays.HappyHolidaysMod;
import com.jumpcutfindo.happyholidays.common.block.christmas.ChristmasBlock;
import com.jumpcutfindo.happyholidays.common.block.christmas.decorations.WallDecorationShape;
import com.jumpcutfindo.happyholidays.common.utils.HappyHolidaysUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ConnectedOrnamentBlock
extends ChristmasBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<WallDecorationShape> WALL_SHAPE = EnumProperty.func_177709_a((String)"decoration_shape", WallDecorationShape.class);
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties().func_200916_a(HappyHolidaysMod.HAPPY_HOLIDAYS_GROUP);
    private final VoxelShape shape;

    public ConnectedOrnamentBlock(AbstractBlock.Properties blockProperties, VoxelShape shape) {
        super(blockProperties);
        this.shape = shape;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(WALL_SHAPE, (Comparable)((Object)WallDecorationShape.STRAIGHT))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void configureBlock() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228645_f_());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate;
        Direction clickedFaceDirection = context.func_196000_l();
        BlockPos clickedPos = context.func_195995_a();
        World world = context.func_195991_k();
        if (!clickedFaceDirection.func_176740_k().func_176722_c()) {
            clickedFaceDirection = context.func_195992_f().func_176734_d();
        }
        boolean isWaterlogged = (fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a())).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)clickedFaceDirection)).func_206870_a(WALL_SHAPE, (Comparable)((Object)this.getWallShapeState((IWorld)world, clickedPos, clickedFaceDirection)))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.func_206894_a(new Property[]{WALL_SHAPE, FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockReader, BlockPos blockPos, ISelectionContext context) {
        Direction direction = (Direction)blockState.func_177229_b((Property)FACING);
        if (direction == Direction.SOUTH) {
            return this.shape;
        }
        if (direction == Direction.NORTH) {
            return HappyHolidaysUtils.rotateShape(this.shape, Rotation.CLOCKWISE_180);
        }
        if (direction == Direction.WEST) {
            return HappyHolidaysUtils.rotateShape(this.shape, Rotation.CLOCKWISE_90);
        }
        return HappyHolidaysUtils.rotateShape(this.shape, Rotation.COUNTERCLOCKWISE_90);
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState1, IWorld world, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos1, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        Direction facingDirection = (Direction)blockState.func_177229_b((Property)FACING);
        if (!this.func_196260_a(blockState, (IWorldReader)world, pos1)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return (BlockState)((BlockState)blockState.func_206870_a((Property)FACING, (Comparable)facingDirection)).func_206870_a(WALL_SHAPE, (Comparable)((Object)this.getWallShapeState(world, pos1, facingDirection)));
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader world, BlockPos position) {
        BlockState onBlockState;
        Direction facingDirection = (Direction)blockState.func_177229_b((Property)FACING);
        Object object = facingDirection == Direction.NORTH ? world.func_180495_p(position.func_177968_d()) : (facingDirection == Direction.SOUTH ? world.func_180495_p(position.func_177978_c()) : (facingDirection == Direction.EAST ? world.func_180495_p(position.func_177976_e()) : (onBlockState = facingDirection == Direction.WEST ? world.func_180495_p(position.func_177974_f()) : null)));
        if (onBlockState != null) {
            return onBlockState.func_224755_d((IBlockReader)world, position, facingDirection) || onBlockState.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E);
        }
        return false;
    }

    private WallDecorationShape getWallShapeState(IWorld world, BlockPos blockPos, Direction facingDirection) {
        boolean isOppositeSupportive;
        Direction oppDir;
        Direction rightDir;
        Direction leftDir;
        BlockPos oppPos;
        BlockPos rightPos;
        BlockPos leftPos;
        if (facingDirection == Direction.NORTH) {
            leftPos = blockPos.func_177976_e();
            rightPos = blockPos.func_177974_f();
            oppPos = blockPos.func_177978_c();
            leftDir = Direction.WEST;
            rightDir = Direction.EAST;
            oppDir = Direction.NORTH;
        } else if (facingDirection == Direction.SOUTH) {
            leftPos = blockPos.func_177974_f();
            rightPos = blockPos.func_177976_e();
            oppPos = blockPos.func_177968_d();
            leftDir = Direction.EAST;
            rightDir = Direction.WEST;
            oppDir = Direction.SOUTH;
        } else if (facingDirection == Direction.EAST) {
            leftPos = blockPos.func_177978_c();
            rightPos = blockPos.func_177968_d();
            oppPos = blockPos.func_177974_f();
            leftDir = Direction.NORTH;
            rightDir = Direction.SOUTH;
            oppDir = Direction.EAST;
        } else {
            leftPos = blockPos.func_177968_d();
            rightPos = blockPos.func_177978_c();
            oppPos = blockPos.func_177976_e();
            leftDir = Direction.SOUTH;
            rightDir = Direction.NORTH;
            oppDir = Direction.WEST;
        }
        boolean isLeftSupportive = world.func_180495_p(leftPos).func_224755_d((IBlockReader)world, leftPos, leftDir) || world.func_180495_p(leftPos).func_235714_a_((ITag)BlockTags.field_206952_E);
        boolean isRightSupportive = world.func_180495_p(rightPos).func_224755_d((IBlockReader)world, rightPos, rightDir) || world.func_180495_p(rightPos).func_235714_a_((ITag)BlockTags.field_206952_E);
        boolean bl = isOppositeSupportive = world.func_180495_p(oppPos).func_224755_d((IBlockReader)world, oppPos, oppDir) || world.func_180495_p(oppPos).func_235714_a_((ITag)BlockTags.field_206952_E);
        if (isLeftSupportive && isRightSupportive && isOppositeSupportive) {
            return WallDecorationShape.ALL_FACE;
        }
        if (isLeftSupportive && isRightSupportive) {
            return WallDecorationShape.SIDE_FACE;
        }
        if (isLeftSupportive) {
            return WallDecorationShape.LEFT_FACE;
        }
        if (isRightSupportive) {
            return WallDecorationShape.RIGHT_FACE;
        }
        return WallDecorationShape.STRAIGHT;
    }
}

